/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.job.orchestration.context.cache;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.ikasan.job.orchestration.core.machine.ContextMachine;
import org.ikasan.spec.scheduled.instance.model.InstanceStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextMachineCache {
    private Logger logger = LoggerFactory.getLogger(ContextMachineCache.class);
    private static ContextMachineCache INSTANCE;
    private final ConcurrentHashMap<String, ContextMachine> contextInstanceByContextInstanceIdCache = new ConcurrentHashMap();
    private final Set<String> contextNames = new HashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ContextMachineCache instance() {
        if (INSTANCE != null) return INSTANCE;
        Class<ContextMachineCache> clazz = ContextMachineCache.class;
        synchronized (ContextMachineCache.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new ContextMachineCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public ConcurrentHashMap<String, ContextMachine> getContextInstanceByContextInstanceIdCache() {
        return this.contextInstanceByContextInstanceIdCache;
    }

    private ContextMachineCache() {
    }

    public void put(ContextMachine contextMachine) {
        this.contextInstanceByContextInstanceIdCache.put(contextMachine.getContext().getId(), contextMachine);
        this.contextNames.add(contextMachine.getContext().getName());
        if (!InstanceStatus.PREPARED.equals((Object)contextMachine.getContext().getStatus())) {
            contextMachine.registerToNotificationMonitors();
        }
    }

    public ContextMachine getFirstByContextName(String contextName) {
        List<ContextMachine> deleteMeSoon = this.getAllByContextName(contextName);
        if (deleteMeSoon != null && !deleteMeSoon.isEmpty()) {
            return deleteMeSoon.get(0);
        }
        return null;
    }

    public List<ContextMachine> getAllByContextName(String contextName) {
        this.logger.debug(String.format("%s attempting to get context using context name[%s]", this, contextName));
        if (contextName == null) {
            return null;
        }
        return this.contextInstanceByContextInstanceIdCache.values().stream().filter(contextMachine -> contextMachine.getContext().getName().equals(contextName)).collect(Collectors.toList());
    }

    public List<ContextMachine> getAllRunningByContextName(String contextName) {
        List<ContextMachine> contextMachines = this.getAllByContextName(contextName);
        contextMachines.removeIf(contextMachine -> contextMachine.getContext().getStatus().equals((Object)InstanceStatus.PREPARED));
        return contextMachines;
    }

    public ContextMachine getByContextInstanceId(String contextInstanceId) {
        this.logger.debug(String.format("Attempting to get context using context instance id[%s]", contextInstanceId));
        if (contextInstanceId == null) {
            return null;
        }
        return this.contextInstanceByContextInstanceIdCache.get(contextInstanceId);
    }

    public List<String> getListOfContextInstanceIdByEnvironmentGroup(String environmentGroup, boolean ignoreEnvironmentGroup) {
        ArrayList<String> contextInstanceIdList = new ArrayList<String>();
        this.contextInstanceByContextInstanceIdCache.forEach((contextInstance, contextMachine) -> {
            if (ignoreEnvironmentGroup) {
                contextInstanceIdList.add((String)contextInstance);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)contextMachine.getContext().getEnvironmentGroup(), (CharSequence)environmentGroup)) {
                contextInstanceIdList.add((String)contextInstance);
            }
        });
        this.logger.debug("Found {} context instances. environmentGroup=[{}], ignoreEnvironmentGroup=[{}]", new Object[]{contextInstanceIdList.size(), environmentGroup, ignoreEnvironmentGroup});
        return contextInstanceIdList;
    }

    public boolean containsInstanceIdentifier(String contextInstanceId) {
        if (contextInstanceId == null) {
            return false;
        }
        boolean result = this.contextInstanceByContextInstanceIdCache.containsKey(contextInstanceId);
        this.logger.debug(String.format("Check contains[%s] - result [%s]", contextInstanceId, result));
        return result;
    }

    public Set<String> contextNames() {
        return Set.copyOf(this.contextNames);
    }

    public Set<String> contextInstanceIdentifiers() {
        return this.contextInstanceByContextInstanceIdCache.keySet();
    }

    public void remove(ContextMachine contextMachine) {
        contextMachine.unregisterToNotificationMonitors();
        this.contextInstanceByContextInstanceIdCache.remove(contextMachine.getContext().getId(), contextMachine);
        this.contextNames.remove(contextMachine.getContext().getName());
    }

    public void resetAllCache() {
        this.contextInstanceByContextInstanceIdCache.clear();
        this.contextNames.clear();
    }

    public boolean cacheIsEmpty() {
        return this.contextInstanceByContextInstanceIdCache.isEmpty() && this.contextNames.isEmpty();
    }

    public String toString() {
        StringBuffer cacheContexts = new StringBuffer("ContextMachineCache[");
        this.contextInstanceIdentifiers().forEach(id -> {
            ContextMachine machine = this.getByContextInstanceId((String)id);
            cacheContexts.append("{contextName[").append(machine.getContext().getName()).append("], contextInstanceId[").append(machine.getContext().getId()).append("]} ");
        });
        cacheContexts.append("]");
        return cacheContexts.toString();
    }
}

