/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.job.orchestration.context.parameters;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ikasan.job.orchestration.context.parameters.ContextParametersFactory;
import org.ikasan.job.orchestration.model.instance.ContextParameterInstanceImpl;
import org.ikasan.job.orchestration.util.ContextHelper;
import org.ikasan.spec.scheduled.context.model.ContextTemplate;
import org.ikasan.spec.scheduled.instance.model.ContextInstance;
import org.ikasan.spec.scheduled.instance.model.ContextParameterInstance;
import org.ikasan.spec.scheduled.instance.model.InternalEventDrivenJobInstance;
import org.ikasan.spec.scheduled.instance.service.ContextParametersInstanceService;
import org.ikasan.spec.scheduled.job.model.InternalEventDrivenJob;

public class ContextParametersInstanceServiceImpl
implements ContextParametersInstanceService {
    private final ContextParametersFactory contextParametersFactory;

    public ContextParametersInstanceServiceImpl(ContextParametersFactory contextParametersFactory) {
        if (contextParametersFactory == null) {
            throw new IllegalArgumentException("contextParametersFactory cannot be null!");
        }
        this.contextParametersFactory = contextParametersFactory;
    }

    public void populateContextParameters() {
        this.contextParametersFactory.populateContextParameters();
    }

    public String getContextParameterValue(String contextName, String parameterValue) {
        return this.contextParametersFactory.getContextParameter(contextName, parameterValue);
    }

    public List<ContextParameterInstance> getAllContextParameters(String contextName) {
        return this.contextParametersFactory.getAllContextParameters(contextName);
    }

    public void populateContextParametersOnContextInstance(ContextInstance contextInstance, Map<String, InternalEventDrivenJobInstance> internalJobs) {
        List<ContextParameterInstance> propertyBackedContextParameterInstances = this.getAllContextParameters(contextInstance.getName());
        List defaultContextParameterInstances = contextInstance.getContextParameters();
        HashMap finalContextParameters = new HashMap();
        propertyBackedContextParameterInstances.forEach(contextParameterInstance -> finalContextParameters.put(contextParameterInstance.getName(), contextParameterInstance));
        defaultContextParameterInstances.forEach(contextParameterInstance -> {
            if (!finalContextParameters.containsKey(contextParameterInstance.getName())) {
                contextParameterInstance.setValue(contextParameterInstance.getDefaultValue());
                finalContextParameters.put(contextParameterInstance.getName(), contextParameterInstance);
            }
        });
        List parameterInstancesFromJobs = ContextHelper.getUniqueContextParameterInstancesFromJobInstances(internalJobs);
        parameterInstancesFromJobs.forEach(contextParameterInstance -> {
            if (!finalContextParameters.containsKey(contextParameterInstance.getName())) {
                contextParameterInstance.setValue(contextParameterInstance.getDefaultValue());
                finalContextParameters.put(contextParameterInstance.getName(), contextParameterInstance);
            }
        });
        contextInstance.setContextParameters(finalContextParameters.values().stream().collect(Collectors.toList()));
    }

    public List<ContextParameterInstance> getContextParameterInstancesForContext(ContextTemplate contextTemplate, Map<String, InternalEventDrivenJob> internalJobs) {
        List<ContextParameterInstance> propertyBackedContextParameterInstances = this.getAllContextParameters(contextTemplate.getName());
        List defaultContextParameters = contextTemplate.getContextParameters();
        HashMap finalContextParameters = new HashMap();
        propertyBackedContextParameterInstances.forEach(contextParameterInstance -> finalContextParameters.put(contextParameterInstance.getName(), contextParameterInstance));
        defaultContextParameters.forEach(contextParameter -> {
            if (!finalContextParameters.containsKey(contextParameter.getName())) {
                ContextParameterInstanceImpl contextParameterInstance = new ContextParameterInstanceImpl();
                contextParameterInstance.setValue(contextParameter.getDefaultValue());
                contextParameterInstance.setName(contextParameter.getName());
                contextParameterInstance.setDefaultValue(contextParameter.getDefaultValue());
                finalContextParameters.put(contextParameter.getName(), contextParameterInstance);
            }
        });
        List parameterInstancesFromJobs = ContextHelper.getUniqueContextParameterInstancesFromJobs(internalJobs);
        parameterInstancesFromJobs.forEach(contextParameterInstance -> {
            if (!finalContextParameters.containsKey(contextParameterInstance.getName())) {
                contextParameterInstance.setValue(contextParameterInstance.getDefaultValue());
                finalContextParameters.put(contextParameterInstance.getName(), contextParameterInstance);
            }
        });
        return finalContextParameters.values().stream().collect(Collectors.toList());
    }
}

