/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.job.orchestration.context.register;

import java.time.ZoneId;
import org.ikasan.job.orchestration.context.register.ContextInstanceSchedulerService;
import org.ikasan.spec.scheduled.context.service.ContextInstanceRegistrationService;
import org.ikasan.spec.scheduler.DashboardJob;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextInstanceEndJob
implements DashboardJob {
    public static final String END_JOB_EXTENSION = "-EndJob";
    private static final Logger LOG = LoggerFactory.getLogger(ContextInstanceEndJob.class);
    private final String jobName;
    private final String cronExpressionEndTime;
    private String timezone;
    private final ContextInstanceRegistrationService contextInstanceRegistrationService;
    private final ContextInstanceSchedulerService contextInstanceSchedulerService;

    public ContextInstanceEndJob(String jobName, String cronExpressionEndTime, String timezone, ContextInstanceRegistrationService contextInstanceRegistrationService, ContextInstanceSchedulerService contextInstanceSchedulerService) {
        this.jobName = jobName;
        if (this.jobName == null) {
            throw new IllegalArgumentException("jobName cannot be null!");
        }
        if (!this.jobName.endsWith(END_JOB_EXTENSION)) {
            throw new IllegalArgumentException("jobName does not end correctly with -EndJob !");
        }
        this.cronExpressionEndTime = cronExpressionEndTime;
        if (this.cronExpressionEndTime == null) {
            throw new IllegalArgumentException("cronExpressionEndTime cannot be null!");
        }
        this.timezone = timezone;
        if (this.timezone == null) {
            this.timezone = ZoneId.systemDefault().getId();
        }
        this.contextInstanceRegistrationService = contextInstanceRegistrationService;
        if (this.contextInstanceRegistrationService == null) {
            throw new IllegalArgumentException("contextInstanceRegistrationService cannot be null!");
        }
        this.contextInstanceSchedulerService = contextInstanceSchedulerService;
        if (this.contextInstanceSchedulerService == null) {
            throw new IllegalArgumentException("contextInstanceSchedulerService cannot be null!");
        }
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getCronExpression() {
        return this.cronExpressionEndTime;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            if (context != null) {
                this.contextInstanceSchedulerService.removeEndJobTrigger(context.getTrigger());
            }
            String contextInstanceId = (String)context.getTrigger().getJobDataMap().get((Object)"contextInstanceId");
            LOG.info("Executing jobExecutionContext end context " + this.jobName + " context Instance ID [" + contextInstanceId + "]");
            this.contextInstanceRegistrationService.deRegisterById(contextInstanceId);
        }
        catch (Exception e) {
            LOG.error(String.format("An error has occurred executing ContextInstanceEndJob[%s]", e.getMessage()), (Throwable)e);
            throw new JobExecutionException((Throwable)e);
        }
    }
}

