/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.job.orchestration.context.register;

import java.time.ZoneId;
import org.ikasan.spec.scheduled.context.service.ContextInstanceRegistrationService;
import org.ikasan.spec.scheduler.DashboardJob;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextInstanceRegisterJob
implements DashboardJob {
    private static Logger logger = LoggerFactory.getLogger(ContextInstanceRegisterJob.class);
    private final String jobName;
    private final String cronExpression;
    private String timezone;
    private final ContextInstanceRegistrationService contextInstanceRegistrationService;

    public ContextInstanceRegisterJob(String jobName, String cronExpression, String timezone, ContextInstanceRegistrationService contextInstanceRegistrationService) {
        this.jobName = jobName;
        if (this.jobName == null) {
            throw new IllegalArgumentException("jobName cannot be null!");
        }
        this.cronExpression = cronExpression;
        if (this.cronExpression == null) {
            throw new IllegalArgumentException("cronExpression cannot be null!");
        }
        this.timezone = timezone;
        if (this.timezone == null) {
            this.timezone = ZoneId.systemDefault().getId();
        }
        this.contextInstanceRegistrationService = contextInstanceRegistrationService;
        if (this.contextInstanceRegistrationService == null) {
            throw new IllegalArgumentException("contextInstanceRegistrationService cannot be null!");
        }
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        logger.info("Executing jobExecutionContext start context " + this.jobName);
        try {
            this.contextInstanceRegistrationService.register(this.jobName);
        }
        catch (Exception e) {
            logger.error(String.format("An error has occurred executing ContextInstanceRegisterJob[%s]", e.getMessage()), (Throwable)e);
            throw new JobExecutionException((Throwable)e);
        }
    }
}

