/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.job.orchestration.context.register;

import javax.annotation.PostConstruct;
import org.ikasan.job.orchestration.context.register.ContextInstanceEndJob;
import org.ikasan.job.orchestration.context.register.ContextInstanceRegisterJob;
import org.ikasan.quartz.AbstractDashboardSchedulerService;
import org.ikasan.scheduler.ScheduledJobFactory;
import org.ikasan.spec.scheduled.context.model.ScheduledContextRecord;
import org.ikasan.spec.scheduled.context.service.ContextInstanceRegistrationService;
import org.ikasan.spec.scheduled.context.service.ScheduledContextService;
import org.ikasan.spec.search.SearchResults;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextInstanceSchedulerService
extends AbstractDashboardSchedulerService {
    private static final Logger LOG = LoggerFactory.getLogger(ContextInstanceSchedulerService.class);
    private final ScheduledContextService scheduledContextService;
    private final ContextInstanceRegistrationService contextInstanceRegistrationService;
    private final boolean isContextLifeCycleActive;
    private boolean isIkasanEnterpriseSchedulerInstance;

    public ContextInstanceSchedulerService(Scheduler scheduler, ScheduledJobFactory scheduledJobFactory, ScheduledContextService scheduledContextService, ContextInstanceRegistrationService contextInstanceRegistrationService, boolean isContextLifeCycleActive, boolean isIkasanEnterpriseSchedulerInstance) {
        super(scheduler, scheduledJobFactory);
        this.scheduledContextService = scheduledContextService;
        if (this.scheduledContextService == null) {
            throw new IllegalArgumentException("scheduledContextService cannot be null!");
        }
        this.contextInstanceRegistrationService = contextInstanceRegistrationService;
        if (this.contextInstanceRegistrationService == null) {
            throw new IllegalArgumentException("scheduledContextService cannot be null!");
        }
        this.isContextLifeCycleActive = isContextLifeCycleActive;
        this.isIkasanEnterpriseSchedulerInstance = isIkasanEnterpriseSchedulerInstance;
    }

    @PostConstruct
    public void registerJobs() {
        LOG.info("ContextInstanceSchedulerService Registering Jobs!");
        if (!this.isIkasanEnterpriseSchedulerInstance) {
            LOG.info("ContextInstanceSchedulerService not running as dashboard is not configured as scheduler instance");
            return;
        }
        if (!this.isContextLifeCycleActive) {
            LOG.info("ContextInstanceSchedulerService not running as usePostConstructs is false");
            return;
        }
        try {
            SearchResults scheduledContextRecords = this.scheduledContextService.findAll();
            for (ScheduledContextRecord scheduledContextRecord : scheduledContextRecords.getResultList()) {
                this.registerStartJobAndTrigger(scheduledContextRecord.getContextName(), scheduledContextRecord.getContext().getTimeWindowStart(), scheduledContextRecord.getContext().getTimezone());
            }
        }
        catch (Exception ex) {
            LOG.error(String.format("An exception has occurred registering contexts [%s]", ex.getMessage()), (Throwable)ex);
        }
    }

    public void registerStartJobAndTrigger(String contextName, String cronExpressionToTriggerJob, String timezone) {
        ContextInstanceRegisterJob job = new ContextInstanceRegisterJob(contextName, cronExpressionToTriggerJob, timezone, this.contextInstanceRegistrationService);
        JobDetail jobDetail = this.scheduledJobFactory.createJobDetail((Job)job, ContextInstanceRegisterJob.class, job.getJobName(), "context start");
        this.dashboardJobDetailsMap.put(job.getJobName(), jobDetail);
        this.dashboardJobsMap.put(jobDetail.getKey().toString(), job);
        LOG.info(String.format("Registering context instance job [%s]", jobDetail.getKey().getName()));
        try {
            this.contextInstanceRegistrationService.prepareFutureContextInstance(contextName);
            this.addJob(jobDetail);
        }
        catch (RuntimeException e) {
            LOG.warn("Unable to register the start trigger job for the context instance job [{}]", (Object)jobDetail.getKey().getName(), (Object)e);
        }
    }

    public void registerEndJobAndTrigger(String contextName, String cronExpressionToTriggerJob, String timezone, String contextInstanceId) {
        ContextInstanceEndJob endJob = new ContextInstanceEndJob(contextName + "-EndJob", cronExpressionToTriggerJob, timezone, this.contextInstanceRegistrationService, this);
        JobDetail endJobDetail = this.scheduledJobFactory.createJobDetail((Job)endJob, ContextInstanceEndJob.class, endJob.getJobName(), "context end");
        this.dashboardJobDetailsMap.put(endJob.getJobName(), endJobDetail);
        this.dashboardJobsMap.put(endJobDetail.getKey().toString(), endJob);
        LOG.info(String.format("Registering context instance job [%s] and instance [%s]", endJobDetail.getKey().getName(), contextInstanceId));
        try {
            this.scheduleEndTrigger(endJobDetail, contextInstanceId);
        }
        catch (RuntimeException e) {
            LOG.warn("Unable to register the end trigger job for the context instance job [{}]", (Object)endJobDetail.getKey().getName(), (Object)e);
        }
    }
}

