/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.job.orchestration.context.util;

import com.cronutils.builder.CronBuilder;
import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.field.expression.FieldExpression;
import com.cronutils.model.field.expression.FieldExpressionFactory;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ikasan.job.orchestration.context.util.QuartzTimeWindowChecker;
import org.ikasan.job.orchestration.context.util.TimeService;

public class CronUtils {
    private static CronParser cronParser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));
    private static TimeService timeService = new TimeService();

    public static String buildCronFromOriginalWithMillisecondOffset(long startTime, long offset, String zoneId) {
        Instant instant = Instant.ofEpochMilli(startTime);
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, zoneId != null && !zoneId.isEmpty() ? ZoneId.of(zoneId) : ZoneId.systemDefault());
        zonedDateTime = zonedDateTime.plus(offset, ChronoUnit.MILLIS);
        Cron cron = CronBuilder.cron((CronDefinition)CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ)).withSecond((FieldExpression)FieldExpressionFactory.on((int)zonedDateTime.get(ChronoField.SECOND_OF_MINUTE))).withMinute((FieldExpression)FieldExpressionFactory.on((int)zonedDateTime.get(ChronoField.MINUTE_OF_HOUR))).withHour((FieldExpression)FieldExpressionFactory.on((int)zonedDateTime.get(ChronoField.HOUR_OF_DAY))).withDoW((FieldExpression)FieldExpressionFactory.questionMark()).withDoM((FieldExpression)FieldExpressionFactory.on((int)zonedDateTime.get(ChronoField.DAY_OF_MONTH))).withMonth((FieldExpression)FieldExpressionFactory.on((int)zonedDateTime.get(ChronoField.MONTH_OF_YEAR))).withYear((FieldExpression)FieldExpressionFactory.on((int)zonedDateTime.get(ChronoField.YEAR))).instance();
        return cron.asString();
    }

    public static String buildCronFromOriginal(long startTime, String zoneId) {
        Instant instant = Instant.ofEpochMilli(startTime);
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, zoneId != null && !zoneId.isEmpty() ? ZoneId.of(zoneId) : ZoneId.systemDefault());
        Cron cron = CronBuilder.cron((CronDefinition)CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ)).withSecond((FieldExpression)FieldExpressionFactory.on((int)zonedDateTime.get(ChronoField.SECOND_OF_MINUTE))).withMinute((FieldExpression)FieldExpressionFactory.on((int)zonedDateTime.get(ChronoField.MINUTE_OF_HOUR))).withHour((FieldExpression)FieldExpressionFactory.on((int)zonedDateTime.get(ChronoField.HOUR_OF_DAY))).withDoW((FieldExpression)FieldExpressionFactory.questionMark()).withDoM((FieldExpression)FieldExpressionFactory.on((int)zonedDateTime.get(ChronoField.DAY_OF_MONTH))).withMonth((FieldExpression)FieldExpressionFactory.on((int)zonedDateTime.get(ChronoField.MONTH_OF_YEAR))).withYear((FieldExpression)FieldExpressionFactory.on((int)zonedDateTime.get(ChronoField.YEAR))).instance();
        return cron.asString();
    }

    public static String buildCronFromOriginalAllDays(long startTime, String zoneId) {
        Instant instant = Instant.ofEpochMilli(startTime);
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, zoneId != null && !zoneId.isEmpty() ? ZoneId.of(zoneId) : ZoneId.systemDefault());
        Cron cron = CronBuilder.cron((CronDefinition)CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ)).withSecond((FieldExpression)FieldExpressionFactory.on((int)zonedDateTime.get(ChronoField.SECOND_OF_MINUTE))).withMinute((FieldExpression)FieldExpressionFactory.on((int)zonedDateTime.get(ChronoField.MINUTE_OF_HOUR))).withHour((FieldExpression)FieldExpressionFactory.on((int)zonedDateTime.get(ChronoField.HOUR_OF_DAY))).withDoW((FieldExpression)FieldExpressionFactory.questionMark()).withDoM(FieldExpression.always()).withMonth(FieldExpression.always()).withYear(FieldExpression.always()).instance();
        return cron.asString();
    }

    public static boolean isDurationGreaterThanNextFireTime(String cronExpression, long duration, int intervalMultiplier) {
        ZonedDateTime now = ZonedDateTime.now();
        ExecutionTime executionTime = ExecutionTime.forCron((Cron)cronParser.parse(cronExpression));
        Optional timeToNextExecution = executionTime.timeToNextExecution(now);
        return (timeToNextExecution = executionTime.timeToNextExecution(now = now.plus(((Duration)timeToNextExecution.get()).getSeconds() + 1L, ChronoUnit.SECONDS))).isPresent() && ((Duration)timeToNextExecution.get()).getSeconds() * 1000L * (long)intervalMultiplier > duration;
    }

    public static long getEpochMilliOfNextFireTime(String cronExpression) {
        ZonedDateTime now = ZonedDateTime.now();
        ExecutionTime executionTime = ExecutionTime.forCron((Cron)cronParser.parse(cronExpression));
        Optional nextExecutionTime = executionTime.nextExecution(now);
        if (nextExecutionTime.isPresent()) {
            return ((ZonedDateTime)nextExecutionTime.get()).toInstant().toEpochMilli();
        }
        return -1L;
    }

    public static long getEpochMilliOfPreviousFireTime(String cronExpression) {
        ZonedDateTime now = ZonedDateTime.now();
        ExecutionTime executionTime = ExecutionTime.forCron((Cron)cronParser.parse(cronExpression));
        Optional previousExecutionTime = executionTime.lastExecution(now);
        if (previousExecutionTime.isPresent()) {
            return ((ZonedDateTime)previousExecutionTime.get()).toInstant().toEpochMilli();
        }
        return -1L;
    }

    public static long getEpochMilliOfNextFireTimeAccountingForBlackoutWindow(String cronExpression, List<String> blackoutCronExpressions, Map<Long, Long> blackoutWindowDateTimeRanges, String timezone) {
        ZonedDateTime now = ZonedDateTime.now();
        ExecutionTime executionTime = ExecutionTime.forCron((Cron)cronParser.parse(cronExpression));
        Optional nextExecutionTime = Optional.of(now);
        while (nextExecutionTime.isPresent()) {
            Date compareDate;
            if (!(nextExecutionTime = executionTime.nextExecution(nextExecutionTime.get())).isPresent() || QuartzTimeWindowChecker.fallsWithinCronBlackoutWindows(blackoutCronExpressions, timezone, compareDate = timeService.getDate(((ZonedDateTime)nextExecutionTime.get()).toInstant().toEpochMilli())) || QuartzTimeWindowChecker.fallsWithinDateTimeBlackoutRanges(blackoutWindowDateTimeRanges, compareDate)) continue;
            return ((ZonedDateTime)nextExecutionTime.get()).toInstant().toEpochMilli();
        }
        return -1L;
    }
}

