/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.job.orchestration.context.util;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import java.text.ParseException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.ikasan.job.orchestration.context.util.CronUtils;
import org.quartz.CronExpression;

public class QuartzTimeWindowChecker {
    public static final long TWENTY_FOUR_HOURS_MILLISECONDS = 86400000L;

    public static boolean withinOperatingWindow(String timezone, String startTimeCronExpression, long contextTtl, Date referenceDateTime) {
        ZoneId zoneId = timezone != null ? ZoneId.of(timezone) : ZoneId.systemDefault();
        ZonedDateTime referenceZDateTime = ZonedDateTime.ofInstant(referenceDateTime.toInstant(), zoneId);
        ZonedDateTime nextExecutionStart = QuartzTimeWindowChecker.getNextExecution(startTimeCronExpression, referenceZDateTime);
        ZonedDateTime previousExecutionStart = QuartzTimeWindowChecker.getPreviousExecution(startTimeCronExpression, referenceZDateTime);
        String endTimeCronExpressionFromPrevious = CronUtils.buildCronFromOriginalWithMillisecondOffset(previousExecutionStart.toEpochSecond() * 1000L, contextTtl, timezone);
        String endTimeCronExpressionFromNext = CronUtils.buildCronFromOriginalWithMillisecondOffset(nextExecutionStart.toEpochSecond() * 1000L, contextTtl, timezone);
        ZonedDateTime executionEndFromPrevious = QuartzTimeWindowChecker.getNextExecution(endTimeCronExpressionFromPrevious, referenceZDateTime);
        if (executionEndFromPrevious == null) {
            executionEndFromPrevious = QuartzTimeWindowChecker.getPreviousExecution(endTimeCronExpressionFromPrevious, referenceZDateTime);
        }
        ZonedDateTime executionEndFromNext = QuartzTimeWindowChecker.getNextExecution(endTimeCronExpressionFromNext, referenceZDateTime);
        if (QuartzTimeWindowChecker.isOnFireTime(zoneId, startTimeCronExpression, endTimeCronExpressionFromPrevious, referenceDateTime) || QuartzTimeWindowChecker.isOnFireTime(zoneId, startTimeCronExpression, endTimeCronExpressionFromNext, referenceDateTime)) {
            return true;
        }
        return executionEndFromPrevious != null && referenceZDateTime.isAfter(previousExecutionStart) && referenceZDateTime.isBefore(executionEndFromPrevious) || referenceZDateTime.isAfter(nextExecutionStart) && referenceZDateTime.isBefore(executionEndFromNext);
    }

    public static boolean withinOperatingWindowOnRecovery(long startTime, long endTime, long currentTime) {
        return startTime < currentTime && endTime > currentTime;
    }

    public static boolean fallsWithinCronBlackoutWindows(List<String> blackoutWindowCronExpressions, String timezone, Date referenceDateTime) {
        if (blackoutWindowCronExpressions != null && !blackoutWindowCronExpressions.isEmpty()) {
            ZoneId zoneId = timezone != null ? ZoneId.of(timezone) : ZoneId.systemDefault();
            for (String cronExpression : blackoutWindowCronExpressions) {
                if (!QuartzTimeWindowChecker.isSatisfiedBy(zoneId, cronExpression, referenceDateTime)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isSatisfiedBy(ZoneId zoneId, String cronExpression, Date referenceDateTime) {
        try {
            CronExpression cronExpressionStart = new CronExpression(cronExpression);
            cronExpressionStart.setTimeZone(TimeZone.getTimeZone(zoneId));
            return cronExpressionStart.isSatisfiedBy(referenceDateTime);
        }
        catch (ParseException e) {
            throw new RuntimeException("Can not parse quartz expression " + cronExpression);
        }
    }

    public static boolean fallsWithinDateTimeBlackoutRanges(Map<Long, Long> blackoutDateTimeRanges, Date referenceDateTime) {
        if (blackoutDateTimeRanges != null && !blackoutDateTimeRanges.isEmpty()) {
            ZoneId zoneId = ZoneId.of("UTC");
            ZonedDateTime utcReferenceZDateTime = ZonedDateTime.ofInstant(referenceDateTime.toInstant(), zoneId);
            for (Map.Entry<Long, Long> dateRangeEntry : blackoutDateTimeRanges.entrySet()) {
                long utcFrom = dateRangeEntry.getKey();
                long utcTo = dateRangeEntry.getValue();
                long fireTime = utcReferenceZDateTime.toInstant().toEpochMilli();
                if (fireTime < utcFrom || fireTime > utcTo) continue;
                return true;
            }
        }
        return false;
    }

    protected static boolean isOnFireTime(ZoneId zoneId, String startTimeCronExpression, String endTimeCronExpression, Date referenceDateTime) {
        return QuartzTimeWindowChecker.isSatisfiedBy(zoneId, startTimeCronExpression, referenceDateTime) || QuartzTimeWindowChecker.isSatisfiedBy(zoneId, endTimeCronExpression, referenceDateTime);
    }

    protected static ZonedDateTime getPreviousExecution(String cronExpression, ZonedDateTime referenceZonedDateTime) {
        ExecutionTime executionTime = QuartzTimeWindowChecker.getExecutionTime(cronExpression);
        return executionTime.lastExecution(referenceZonedDateTime).orElse(null);
    }

    protected static ZonedDateTime getNextExecution(String cronExpression, ZonedDateTime referenceZonedDateTime) {
        ExecutionTime executionTime = QuartzTimeWindowChecker.getExecutionTime(cronExpression);
        return executionTime.nextExecution(referenceZonedDateTime).orElse(null);
    }

    private static ExecutionTime getExecutionTime(String cronExpression) {
        try {
            CronDefinition cronDefinition = CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ);
            CronParser cronParser = new CronParser(cronDefinition);
            Cron parse = cronParser.parse(cronExpression);
            return ExecutionTime.forCron((Cron)parse);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Can not parse quartz expression " + cronExpression, e);
        }
    }
}

