/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.job.orchestration.context.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.ikasan.job.orchestration.configuration.JobContextParamsSetupConfiguration;
import org.ikasan.job.orchestration.model.instance.ContextParameterInstanceImpl;
import org.ikasan.spec.scheduled.instance.model.ContextParameterInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class SchedulerContextParametersPropertiesProvider
extends Properties {
    private static final Logger LOG = LoggerFactory.getLogger(SchedulerContextParametersPropertiesProvider.class);
    private Map<String, String> spelExpressionMap;
    private JobContextParamsSetupConfiguration jobContextParamsSetupConfiguration;

    public SchedulerContextParametersPropertiesProvider(JobContextParamsSetupConfiguration jobContextParamsSetupConfiguration, Map<String, String> spelExpressionMap) {
        this.jobContextParamsSetupConfiguration = jobContextParamsSetupConfiguration;
        if (this.jobContextParamsSetupConfiguration == null || this.jobContextParamsSetupConfiguration.getParamsToReplace() == null) {
            throw new IllegalArgumentException("jobContextParamsSetupConfiguration cannot be null!");
        }
        this.spelExpressionMap = spelExpressionMap == null ? Collections.emptyMap() : spelExpressionMap;
        String message = String.format("Creating SchedulerContextParametersPropertiesProvider configuration with use, parametersToReplaceContext %s, spelExpressionMap %s", this.jobContextParamsSetupConfiguration.getParamsToReplace().keySet(), this.spelExpressionMap);
        LOG.info(message);
    }

    public String getContextParameter(String contextName, String paramName) {
        Map<String, String> paramMap;
        if (contextName != null && paramName != null && (paramMap = this.jobContextParamsSetupConfiguration.getParamsToReplace().get(contextName)) != null) {
            return this.replaceParameterWithSpel(paramName, paramMap.get(paramName));
        }
        return null;
    }

    public List<ContextParameterInstance> getAllContextParameters(String contextName) {
        Map<String, String> paramMap;
        ArrayList<ContextParameterInstance> params = new ArrayList<ContextParameterInstance>();
        if (contextName != null && (paramMap = this.jobContextParamsSetupConfiguration.getParamsToReplace().get(contextName)) != null) {
            for (String name : paramMap.keySet()) {
                ContextParameterInstanceImpl param = new ContextParameterInstanceImpl();
                param.setName(name);
                String value = paramMap.get(name);
                value = this.replaceParameterWithSpel(name, value);
                param.setValue(value);
                params.add((ContextParameterInstance)param);
            }
        }
        return params;
    }

    private String replaceParameterWithSpel(String name, String value) {
        if (this.spelExpressionMap != null && !this.spelExpressionMap.isEmpty()) {
            for (String key : this.spelExpressionMap.keySet()) {
                if (!key.equals(value)) continue;
                String spel = this.spelExpressionMap.get(key);
                SpelExpressionParser parser = new SpelExpressionParser();
                Expression exp = parser.parseExpression(spel);
                String newValue = (String)exp.getValue((Object)spel, String.class);
                LOG.info(String.format("Replacing name [%s] parameter [%s] with new value [%s]", name, value, newValue));
                return newValue;
            }
        }
        return value;
    }
}

