/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.job.orchestration.context.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ikasan.job.orchestration.context.validation.ContextError;
import org.ikasan.job.orchestration.context.validation.InvalidContextTemplateException;
import org.ikasan.job.orchestration.util.ContextHelper;
import org.ikasan.spec.scheduled.context.model.Context;
import org.ikasan.spec.scheduled.context.model.ContextTemplate;
import org.ikasan.spec.scheduled.context.model.JobLock;
import org.ikasan.spec.scheduled.context.model.LogicalGrouping;
import org.ikasan.spec.scheduled.job.model.SchedulerJob;

public class ContextTemplateValidator {
    private StringBuffer errorReport = new StringBuffer("The context template is invalid!\n");
    private List<ContextError> errors = new ArrayList<ContextError>();
    private boolean inError = false;
    List<String> childContextName = new ArrayList<String>();

    public void validate(ContextTemplate contextTemplate) throws InvalidContextTemplateException {
        this.inError = false;
        this.errors = new ArrayList<ContextError>();
        this.errorReport = new StringBuffer("The context template is invalid!\n");
        this.assertThatContextJobsPresentInContextForAllJobDependencies(contextTemplate);
        this.childContextName.add(contextTemplate.getName());
        if (contextTemplate.getContexts() != null) {
            contextTemplate.getContexts().forEach(contextTemplate1 -> this.validateChildContext((ContextTemplate)contextTemplate1));
        }
        this.assertThatAllContextNamesAreUnique();
        if (this.inError) {
            throw new InvalidContextTemplateException(this.errorReport.toString(), this.errors);
        }
    }

    public void validateJobs(ContextTemplate contextTemplate, List<SchedulerJob> jobTemplates) throws InvalidContextTemplateException {
        this.inError = false;
        this.errors = new ArrayList<ContextError>();
        this.errorReport = new StringBuffer("The context template is invalid!\n");
        List schedulerJobs = ContextHelper.getAllJobs((ContextTemplate)contextTemplate);
        Set jobTemplatesSet = jobTemplates.stream().map(job -> job.getJobName()).collect(Collectors.toSet());
        Set<String> contextTemplatesJobSet = schedulerJobs.stream().map(job -> job.getJobName()).collect(Collectors.toSet());
        contextTemplatesJobSet.removeAll(jobTemplatesSet);
        if (!contextTemplatesJobSet.isEmpty()) {
            contextTemplatesJobSet.forEach(jobName -> {
                List contexts = ContextHelper.getContextsWhereJobFilterMatchResides((Context)contextTemplate, (String)jobName);
                contexts.forEach(contextName -> {
                    this.errorReport.append(String.format("Job[%s] appears in job plan but there is no job template defined for it in the database!\n", jobName));
                    ContextError contextError = new ContextError((String)contextName, String.format("Job[%s] appears in job plan but there is no job template defined for it in the database!", jobName), (String)jobName);
                    this.errors.add(contextError);
                });
            });
            throw new InvalidContextTemplateException(this.errorReport.toString(), this.errors);
        }
    }

    private void validateChildContext(ContextTemplate contextTemplate) {
        this.assertThatContextJobsPresentInContextForAllJobDependencies(contextTemplate);
        this.childContextName.add(contextTemplate.getName());
        if (contextTemplate.getContexts() != null) {
            contextTemplate.getContexts().forEach(contextTemplate1 -> this.validateChildContext((ContextTemplate)contextTemplate1));
        }
    }

    private void assertThatContextsJobLocksCannotBeAtTheSameLevel(ContextTemplate contextTemplate) {
        if (contextTemplate.getContexts() != null && !contextTemplate.getContexts().isEmpty() && contextTemplate.getJobLocksMap() != null && !contextTemplate.getJobLocksMap().isEmpty()) {
            this.inError = true;
            this.errorReport.append("Context[").append(contextTemplate.getName()).append("] contains both jobs locks and contexts.").append(" A context cannot contain contexts and job locks.\n");
        }
    }

    private void assertJobLocksContainOnlyJobsAssociatedWithTheContext(ContextTemplate contextTemplate) {
        if (contextTemplate.getJobLocksMap() != null) {
            contextTemplate.getJobLocksMap().entrySet().forEach(entry -> {
                boolean jobExists;
                boolean bl = jobExists = ((JobLock)entry.getValue()).getJobs().values().stream().flatMap(Collection::stream).filter(job -> contextTemplate.getScheduledJobs().stream().filter(schedulerJob -> job.getIdentifier().equals(schedulerJob.getIdentifier())).findFirst().isPresent()).collect(Collectors.toList()).size() == ((JobLock)entry.getValue()).getJobs().size();
                if (!jobExists) {
                    this.inError = true;
                    this.errorReport.append("Context[").append(contextTemplate.getName()).append("] contains jobs locks and and jobs, however there ").append("are job identifiers defined in job lock[").append((String)entry.getKey()).append("] that do not reference scheduler jobs defined within the context.\n");
                }
            });
        }
    }

    private void assertThatStartAndEndTimeWindowArePresent(ContextTemplate contextTemplate) {
        if (contextTemplate.getTimeWindowStart() == null || contextTemplate.getTimeWindowStart().isEmpty()) {
            this.inError = true;
            this.errorReport.append("Context[").append(contextTemplate.getName()).append("] must contain a time window start cron expression.\n");
        }
    }

    private void assertThatStartAndEndTimeWindowAreNotPresent(ContextTemplate contextTemplate) {
        if (contextTemplate.getTimeWindowStart() != null && !contextTemplate.getTimeWindowStart().isEmpty()) {
            this.inError = true;
            this.errorReport.append("Context[").append(contextTemplate.getName()).append("] must not contain a time window start cron expression. This field can only be present in the root context.\n");
        }
    }

    private void assertThatContextParametersNotPresent(ContextTemplate contextTemplate) {
        if (contextTemplate.getContextParameters() != null && !contextTemplate.getContextParameters().isEmpty()) {
            this.inError = true;
            this.errorReport.append("Context[").append(contextTemplate.getName()).append("] must not contain any context parameters. Context parameters can only be present in the root context.\n");
        }
    }

    private void assertThatContextJobsPresentInContextForAllJobDependencies(ContextTemplate contextTemplate) {
        HashSet jobs = new HashSet();
        if (contextTemplate.getJobDependencies() != null) {
            contextTemplate.getJobDependencies().forEach(jobDependency -> {
                if (jobDependency.getJobIdentifier() != null) {
                    jobs.add(jobDependency.getJobIdentifier());
                }
                if (jobDependency.getLogicalGrouping() != null) {
                    this.manageLogicalGrouping(jobDependency.getLogicalGrouping(), jobs);
                }
            });
        }
        HashSet contextJobs = new HashSet();
        contextTemplate.getScheduledJobs().forEach(schedulerJob -> contextJobs.add(schedulerJob.getIdentifier()));
        contextJobs.removeAll(jobs);
        if (!contextJobs.isEmpty()) {
            this.inError = true;
            contextJobs.forEach(jobIdentifier -> {
                StringBuffer error = new StringBuffer();
                error.append("Context[").append(contextTemplate.getName()).append("] The following job [").append((String)jobIdentifier).append("] appears in the scheduler jobs collection, but is not defined in any job dependencies.");
                this.errorReport.append(error).append("\n");
                this.errors.add(new ContextError(contextTemplate.getName(), error.toString()));
            });
        }
        HashSet contextJobs2 = new HashSet();
        contextTemplate.getScheduledJobs().forEach(schedulerJob -> contextJobs2.add(schedulerJob.getIdentifier()));
        jobs.removeAll(contextJobs2);
        if (!jobs.isEmpty()) {
            this.inError = true;
            jobs.forEach(jobIdentifier -> {
                StringBuffer error = new StringBuffer();
                error.append("Context[").append(contextTemplate.getName()).append("] The following job [").append((String)jobIdentifier).append("] appears in a job dependency, but is not defined in the scheduler job collection.");
                this.errorReport.append(error).append("\n");
                this.errors.add(new ContextError(contextTemplate.getName(), error.toString()));
            });
        }
    }

    private void assertThatAllContextNamesAreUnique() {
        HashMap<String, Integer> childContextNameMap = new HashMap<String, Integer>();
        for (String string : this.childContextName) {
            if (childContextNameMap.containsKey(string)) {
                childContextNameMap.put(string, (Integer)childContextNameMap.get(string) + 1);
                continue;
            }
            childContextNameMap.put(string, 1);
        }
        for (Map.Entry entry : childContextNameMap.entrySet()) {
            if ((Integer)entry.getValue() <= 1) continue;
            this.inError = true;
            this.errorReport.append("The context name [" + (String)entry.getKey() + "] has been repeated [" + entry.getValue() + "] times within the template. Context Names needs to be unique.\n");
        }
    }

    private void manageLogicalGrouping(LogicalGrouping logicalGrouping, Set<String> jobs) {
        if (logicalGrouping.getLogicalGrouping() != null) {
            this.manageLogicalGrouping(logicalGrouping.getLogicalGrouping(), jobs);
        }
        if (logicalGrouping.getAnd() != null) {
            logicalGrouping.getAnd().forEach(and -> {
                if (and.getIdentifier() != null) {
                    jobs.add(and.getIdentifier());
                }
                if (and.getLogicalGrouping() != null) {
                    this.manageLogicalGrouping(and.getLogicalGrouping(), jobs);
                }
            });
        }
        if (logicalGrouping.getOr() != null) {
            logicalGrouping.getOr().forEach(or -> {
                if (or.getIdentifier() != null) {
                    jobs.add(or.getIdentifier());
                }
                if (or.getLogicalGrouping() != null) {
                    this.manageLogicalGrouping(or.getLogicalGrouping(), jobs);
                }
            });
        }
        if (logicalGrouping.getNot() != null) {
            logicalGrouping.getNot().forEach(not -> {
                if (not.getIdentifier() != null) {
                    jobs.add(not.getIdentifier());
                }
                if (not.getLogicalGrouping() != null) {
                    this.manageLogicalGrouping(not.getLogicalGrouping(), jobs);
                }
            });
        }
    }
}

