/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.job.orchestration.core.component.converter;

import java.util.ArrayList;
import org.ikasan.job.orchestration.model.status.ContextInstanceStatus;
import org.ikasan.job.orchestration.model.status.SchedulerJobInstanceStatus;
import org.ikasan.spec.component.transformation.Converter;
import org.ikasan.spec.component.transformation.TransformationException;
import org.ikasan.spec.scheduled.instance.model.ContextInstance;
import org.ikasan.spec.scheduled.instance.model.SchedulerJobInstance;

public class ContextInstanceToContextInstanceStatusConverter
implements Converter<ContextInstance, ContextInstanceStatus> {
    public ContextInstanceStatus convert(ContextInstance contextInstance) throws TransformationException {
        ContextInstanceStatus contextInstanceStatus = new ContextInstanceStatus();
        try {
            return this.populateStatus(contextInstanceStatus, contextInstance);
        }
        catch (Exception e) {
            throw new TransformationException("An error has occurred trying to convert a ContextInstance to a ContextInstanceStatus", (Throwable)e);
        }
    }

    private ContextInstanceStatus populateStatus(ContextInstanceStatus contextInstanceStatus, ContextInstance contextInstance) {
        contextInstanceStatus.setContextName(contextInstance.getName());
        contextInstanceStatus.setInstanceStatus(contextInstance.getStatus());
        if (contextInstance.getScheduledJobs() != null) {
            ArrayList<SchedulerJobInstanceStatus> schedulerJobInstanceStatuses = new ArrayList<SchedulerJobInstanceStatus>();
            for (SchedulerJobInstance schedulerJobInstance : contextInstance.getScheduledJobs()) {
                SchedulerJobInstanceStatus instance = new SchedulerJobInstanceStatus();
                instance.setJobName(schedulerJobInstance.getJobName());
                instance.setAgentName(schedulerJobInstance.getAgentName());
                instance.setInstanceStatus(schedulerJobInstance.getStatus());
                schedulerJobInstanceStatuses.add(instance);
            }
            contextInstanceStatus.setSchedulerJobInstanceStatuses(schedulerJobInstanceStatuses);
        }
        if (contextInstance.getContexts() != null) {
            ArrayList<ContextInstanceStatus> contextInstanceStatuses = new ArrayList<ContextInstanceStatus>();
            for (ContextInstance instance : contextInstance.getContexts()) {
                contextInstanceStatuses.add(this.populateStatus(new ContextInstanceStatus(), instance));
            }
            contextInstanceStatus.setContextInstanceStatuses(contextInstanceStatuses);
        }
        return contextInstanceStatus;
    }
}

