/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.job.orchestration.core.machine;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.ikasan.job.orchestration.core.machine.ContextMachineException;
import org.ikasan.spec.scheduled.context.model.LogicalGrouping;
import org.ikasan.spec.scheduled.instance.model.InstanceStatus;
import org.ikasan.spec.scheduled.instance.model.StatefulEntity;

public class AbstractLogicMachine<STATEFUL_ENTITY extends StatefulEntity> {
    protected boolean assessAnd(LogicalGrouping logicalGrouping, Map<String, STATEFUL_ENTITY> statefulEntityMap) {
        AtomicBoolean and = new AtomicBoolean(false);
        if (logicalGrouping.getAnd() != null && !logicalGrouping.getAnd().isEmpty()) {
            and.set(true);
            logicalGrouping.getAnd().forEach(operator -> {
                if (operator.getLogicalGrouping() != null) {
                    if (!this.assessBaseLogic(operator.getLogicalGrouping(), statefulEntityMap)) {
                        and.set(false);
                    }
                } else {
                    StatefulEntity statefulEntity = (StatefulEntity)statefulEntityMap.get(operator.getIdentifier());
                    if (statefulEntity == null) {
                        throw new ContextMachineException(String.format("Could not locate stateful entity[%s] when trying to assess logical group and[%s]", operator.getIdentifier(), logicalGrouping));
                    }
                    if (!statefulEntity.getStatus().equals((Object)InstanceStatus.COMPLETE) && !statefulEntity.getStatus().equals((Object)InstanceStatus.SKIPPED_COMPLETE)) {
                        and.set(false);
                    }
                }
            });
        }
        return and.get();
    }

    protected boolean assessOr(LogicalGrouping logicalGrouping, Map<String, STATEFUL_ENTITY> statefulEntityMap) {
        AtomicBoolean or = new AtomicBoolean(false);
        if (logicalGrouping.getOr() != null && !logicalGrouping.getOr().isEmpty()) {
            logicalGrouping.getOr().forEach(operator -> {
                if (operator.getLogicalGrouping() != null) {
                    if (this.assessBaseLogic(operator.getLogicalGrouping(), statefulEntityMap)) {
                        or.set(true);
                    }
                } else {
                    StatefulEntity statefulEntity = (StatefulEntity)statefulEntityMap.get(operator.getIdentifier());
                    if (statefulEntity == null) {
                        throw new ContextMachineException(String.format("Could not locate stateful entity[%s] when trying to assess logical group or[%s]", operator.getIdentifier(), logicalGrouping));
                    }
                    if (statefulEntity.getStatus().equals((Object)InstanceStatus.COMPLETE) || statefulEntity.getStatus().equals((Object)InstanceStatus.SKIPPED_COMPLETE)) {
                        or.set(true);
                    }
                }
            });
        }
        return or.get();
    }

    protected boolean assessNot(LogicalGrouping logicalGrouping, Map<String, STATEFUL_ENTITY> statefulEntityMap) {
        AtomicBoolean not = new AtomicBoolean(false);
        if (logicalGrouping.getNot() != null && !logicalGrouping.getNot().isEmpty()) {
            logicalGrouping.getNot().forEach(operator -> {
                if (operator.getLogicalGrouping() != null) {
                    if (this.assessBaseLogic(operator.getLogicalGrouping(), statefulEntityMap)) {
                        not.set(true);
                    }
                } else {
                    StatefulEntity statefulEntity = (StatefulEntity)statefulEntityMap.get(operator.getIdentifier());
                    if (statefulEntity == null) {
                        throw new ContextMachineException(String.format("Could not locate stateful entity[%s] when trying to assess logical group or[%s]", operator.getIdentifier(), logicalGrouping));
                    }
                    if (statefulEntity.getStatus().equals((Object)InstanceStatus.COMPLETE) || statefulEntity.getStatus().equals((Object)InstanceStatus.SKIPPED_COMPLETE)) {
                        not.set(true);
                    }
                }
            });
        }
        return not.get();
    }

    protected boolean assessBaseLogic(LogicalGrouping logicalGrouping, Map<String, STATEFUL_ENTITY> statefulEntityMap) {
        boolean andAssessment = this.assessAnd(logicalGrouping, statefulEntityMap);
        boolean orAssessment = this.assessOr(logicalGrouping, statefulEntityMap);
        boolean notAssessment = this.assessNot(logicalGrouping, statefulEntityMap);
        return (andAssessment || orAssessment) && !notAssessment;
    }

    protected boolean jobIdentifierIsInLogicalGrouping(LogicalGrouping logicalGrouping, String jobIdentifier) {
        AtomicBoolean result = new AtomicBoolean(false);
        if (logicalGrouping.getAnd() != null && !logicalGrouping.getAnd().isEmpty()) {
            logicalGrouping.getAnd().forEach(and -> {
                if (and.getIdentifier() != null && and.getIdentifier().equals(jobIdentifier)) {
                    result.set(true);
                } else if (and.getLogicalGrouping() != null && this.jobIdentifierIsInLogicalGrouping(and.getLogicalGrouping(), jobIdentifier)) {
                    result.set(true);
                }
            });
        }
        if (logicalGrouping.getOr() != null && !logicalGrouping.getOr().isEmpty()) {
            logicalGrouping.getOr().forEach(or -> {
                if (or.getIdentifier() != null && or.getIdentifier().equals(jobIdentifier)) {
                    result.set(true);
                } else if (or.getLogicalGrouping() != null && this.jobIdentifierIsInLogicalGrouping(or.getLogicalGrouping(), jobIdentifier)) {
                    result.set(true);
                }
            });
        }
        if (logicalGrouping.getNot() != null && !logicalGrouping.getNot().isEmpty()) {
            logicalGrouping.getNot().forEach(not -> {
                if (not.getIdentifier() != null && not.getIdentifier().equals(jobIdentifier)) {
                    result.set(true);
                } else if (not.getLogicalGrouping() != null && this.jobIdentifierIsInLogicalGrouping(not.getLogicalGrouping(), jobIdentifier)) {
                    result.set(true);
                }
            });
        }
        if (logicalGrouping.getLogicalGrouping() != null && this.jobIdentifierIsInLogicalGrouping(logicalGrouping.getLogicalGrouping(), jobIdentifier)) {
            result.set(true);
        }
        return result.get();
    }
}

