/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.job.orchestration.core.machine;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.ikasan.bigqueue.BigQueueImpl;
import org.ikasan.bigqueue.IBigQueue;
import org.ikasan.component.endpoint.bigqueue.builder.BigQueueMessageBuilder;
import org.ikasan.component.endpoint.bigqueue.message.BigQueueMessageImpl;
import org.ikasan.component.endpoint.bigqueue.service.BigQueueDirectoryManagementServiceImpl;
import org.ikasan.job.orchestration.context.cache.ContextMachineCache;
import org.ikasan.job.orchestration.context.util.CronUtils;
import org.ikasan.job.orchestration.context.util.JobThreadFactory;
import org.ikasan.job.orchestration.core.component.converter.ContextInstanceToContextInstanceStatusConverter;
import org.ikasan.job.orchestration.core.machine.ContextMachineException;
import org.ikasan.job.orchestration.core.machine.ContextStateHelper;
import org.ikasan.job.orchestration.core.machine.JobLogicMachine;
import org.ikasan.job.orchestration.core.notification.MonitorManagement;
import org.ikasan.job.orchestration.model.event.ContextInstanceStateChangeEventImpl;
import org.ikasan.job.orchestration.model.event.ContextualisedScheduledProcessEventImpl;
import org.ikasan.job.orchestration.model.event.SchedulerJobInitiationEventImpl;
import org.ikasan.job.orchestration.model.event.SchedulerJobInstanceStateChangeEventImpl;
import org.ikasan.job.orchestration.model.instance.ScheduledContextInstanceAuditAggregateImpl;
import org.ikasan.job.orchestration.model.instance.ScheduledContextInstanceAuditAggregateRecordImpl;
import org.ikasan.job.orchestration.model.instance.ScheduledContextInstanceRecordImpl;
import org.ikasan.job.orchestration.model.instance.SchedulerJobInstancesInitialisationParametersImpl;
import org.ikasan.job.orchestration.model.status.ContextInstanceStatus;
import org.ikasan.job.orchestration.service.BigQueueContextMachineManagementServiceImpl;
import org.ikasan.job.orchestration.service.ContextService;
import org.ikasan.job.orchestration.util.ContextHelper;
import org.ikasan.job.orchestration.util.ObjectMapperFactory;
import org.ikasan.spec.bigqueue.message.BigQueueMessage;
import org.ikasan.spec.bigqueue.service.BigQueueManagementService;
import org.ikasan.spec.metadata.ModuleMetaData;
import org.ikasan.spec.scheduled.context.model.Context;
import org.ikasan.spec.scheduled.context.model.ContextTemplate;
import org.ikasan.spec.scheduled.context.model.JobLockCache;
import org.ikasan.spec.scheduled.context.service.ScheduledContextService;
import org.ikasan.spec.scheduled.core.listener.ContextInstanceStateChangeEventListener;
import org.ikasan.spec.scheduled.core.listener.SchedulerJobInitiationEventRaisedListener;
import org.ikasan.spec.scheduled.core.listener.SchedulerJobInstanceStateChangeEventListener;
import org.ikasan.spec.scheduled.event.model.ContextInstanceStateChangeEvent;
import org.ikasan.spec.scheduled.event.model.ContextualisedScheduledProcessEvent;
import org.ikasan.spec.scheduled.event.model.DryRunParameters;
import org.ikasan.spec.scheduled.event.model.ScheduledProcessEvent;
import org.ikasan.spec.scheduled.event.model.SchedulerJobInitiationEvent;
import org.ikasan.spec.scheduled.instance.model.ContextInstance;
import org.ikasan.spec.scheduled.instance.model.ContextParameterInstance;
import org.ikasan.spec.scheduled.instance.model.GlobalEventJobInstance;
import org.ikasan.spec.scheduled.instance.model.InstanceStatus;
import org.ikasan.spec.scheduled.instance.model.InternalEventDrivenJobInstance;
import org.ikasan.spec.scheduled.instance.model.QuartzScheduleDrivenJobInstance;
import org.ikasan.spec.scheduled.instance.model.ScheduledContextInstanceAuditAggregate;
import org.ikasan.spec.scheduled.instance.model.ScheduledContextInstanceAuditAggregateRecord;
import org.ikasan.spec.scheduled.instance.model.ScheduledContextInstanceRecord;
import org.ikasan.spec.scheduled.instance.model.SchedulerJobInstance;
import org.ikasan.spec.scheduled.instance.model.SchedulerJobInstanceRecord;
import org.ikasan.spec.scheduled.instance.service.ContextInstancePublicationService;
import org.ikasan.spec.scheduled.instance.service.ContextParametersInstanceService;
import org.ikasan.spec.scheduled.instance.service.ScheduledContextInstanceService;
import org.ikasan.spec.scheduled.instance.service.SchedulerJobInstanceService;
import org.ikasan.spec.scheduled.instance.service.SchedulerJobInstancesInitialisationParameters;
import org.ikasan.spec.scheduled.instance.service.exception.SchedulerJobInstanceInitialisationException;
import org.ikasan.spec.scheduled.job.model.SchedulerJob;
import org.ikasan.spec.scheduled.joblock.service.JobLockCacheInitialisationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextMachine {
    private Logger logger = LoggerFactory.getLogger(ContextMachine.class);
    public static final String MANUAL_SUBMISSION = "group (manual fire)";
    private ContextInstance contextInstance;
    private JobLogicMachine jobLogicMachine;
    private ContextInstanceToContextInstanceStatusConverter statusConverter;
    private List<ContextInstanceStateChangeEventListener> contextInstanceStateChangeEventListeners;
    private ExecutorService statusListenerExecutor;
    private ExecutorService schedulerInitiatorEventRaisedListenerExecutor;
    private ExecutorService contextExecutor;
    private IBigQueue inboundQueue;
    private IBigQueue outboundQueue;
    private ListenableFuture<byte[]> inboundListenableFuture;
    private ListenableFuture<byte[]> outboundListenableFuture;
    private ObjectMapper objectMapper;
    private ScheduledContextInstanceService scheduledContextInstanceService;
    private SchedulerJobInstanceService schedulerJobInstanceService;
    private ScheduledContextService scheduledContextService;
    private SchedulerJobInitiationEventRaisedListener schedulerJobInitiationEventRaisedListener;
    private final JobLockCacheInitialisationService jobLockCacheInitialisationService;
    private final ContextInstancePublicationService<ContextInstance> contextInstancePublicationService;
    private final ContextParametersInstanceService contextParametersInstanceService;
    private ContextTemplate context;
    private int attempts;
    private long maxWait;
    private DryRunParameters dryRunParameters;
    private Map<String, InternalEventDrivenJobInstance> internalEventDrivenJobInstances;
    private Map<String, GlobalEventJobInstance> globalEventJobInstanceMap;
    private Map<String, QuartzScheduleDrivenJobInstance> quartzScheduleDrivenJobInstanceMap;
    private Map<String, ModuleMetaData> agents;
    private String queueDir;
    private JobLockCache jobLockCache;
    private OutboundQueueMessageRunner outboundQueueMessageRunner;
    private InboundQueueMessageRunner inboundQueueMessageRunner;
    private ContextStateHelper contextStateHelper;
    private boolean tornDown = false;

    public ContextMachine(ContextTemplate context, ContextInstance contextInstance, ScheduledContextInstanceService scheduledContextInstanceService, Map<String, GlobalEventJobInstance> globalEventJobInstanceMap, Map<String, QuartzScheduleDrivenJobInstance> quartzScheduleDrivenJobInstanceMap, Map<String, InternalEventDrivenJobInstance> internalEventDrivenJobInstances, String queueDir, Map<String, ModuleMetaData> agents, JobLockCache jobLockCache, ContextParametersInstanceService contextParametersInstanceService, ScheduledContextService scheduledContextService, SchedulerJobInstanceService schedulerJobInstanceService, JobLockCacheInitialisationService jobLockCacheInitialisationService, ContextInstancePublicationService<ContextInstance> contextInstancePublicationService) {
        this.context = context;
        this.contextInstance = contextInstance;
        ContextHelper.enrichJobs((ContextInstance)contextInstance);
        this.internalEventDrivenJobInstances = internalEventDrivenJobInstances;
        this.globalEventJobInstanceMap = globalEventJobInstanceMap;
        if (this.globalEventJobInstanceMap == null) {
            this.globalEventJobInstanceMap = new HashMap<String, GlobalEventJobInstance>();
        }
        this.quartzScheduleDrivenJobInstanceMap = quartzScheduleDrivenJobInstanceMap;
        if (this.quartzScheduleDrivenJobInstanceMap == null) {
            this.quartzScheduleDrivenJobInstanceMap = new HashMap<String, QuartzScheduleDrivenJobInstance>();
        }
        this.agents = agents;
        this.queueDir = queueDir;
        this.statusConverter = new ContextInstanceToContextInstanceStatusConverter();
        this.contextInstanceStateChangeEventListeners = new ArrayList<ContextInstanceStateChangeEventListener>();
        this.statusListenerExecutor = Executors.newSingleThreadExecutor(new JobThreadFactory("ContextMachine-StatusChangeListener"));
        this.contextExecutor = Executors.newSingleThreadExecutor(new JobThreadFactory("ContextMachine-ContextExecutor"));
        this.schedulerInitiatorEventRaisedListenerExecutor = Executors.newSingleThreadExecutor(new JobThreadFactory("ContextMachine-EventRaisedListener"));
        this.objectMapper = ObjectMapperFactory.newInstance();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.scheduledContextInstanceService = scheduledContextInstanceService;
        this.scheduledContextService = scheduledContextService;
        this.schedulerJobInstanceService = schedulerJobInstanceService;
        this.jobLockCacheInitialisationService = jobLockCacheInitialisationService;
        this.contextInstancePublicationService = contextInstancePublicationService;
        this.contextParametersInstanceService = contextParametersInstanceService;
        this.jobLockCache = jobLockCache;
        this.jobLogicMachine = new JobLogicMachine(this.agents, this.jobLockCache, contextParametersInstanceService);
        this.contextStateHelper = new ContextStateHelper();
    }

    public void init() throws IOException {
        String inboundQueueName = this.getInboundQueueName();
        String outboundQueueName = this.getOutboundQueueName();
        this.inboundQueue = new BigQueueImpl(this.queueDir, inboundQueueName);
        this.outboundQueue = new BigQueueImpl(this.queueDir, outboundQueueName);
        this.addInboundListener();
        this.addOutboundListener();
        this.saveContext();
        this.attempts = 0;
        this.maxWait = 10000L;
    }

    public void registerToNotificationMonitors() {
        MonitorManagement.startMonitoring(this);
    }

    public void unregisterToNotificationMonitors() {
        this.logger.info("Call to stop monitoring for the context {} and instanceId {}", (Object)this.contextInstance.getName(), (Object)this.contextInstance.getId());
        MonitorManagement.stopMonitoring(this);
    }

    public String getOutboundQueueName() {
        return "outbound-" + this.contextInstance.getId() + "-queue";
    }

    public String getInboundQueueName() {
        return "inbound-" + this.contextInstance.getId() + "-queue";
    }

    public IBigQueue getInboundQueue() {
        return this.inboundQueue;
    }

    public IBigQueue getOutboundQueue() {
        return this.outboundQueue;
    }

    public void resetContextInstance(boolean holdCommandJobs, boolean initiateWithSameParameters, List<ContextParameterInstance> contextParameterInstances) throws IOException, SchedulerJobInstanceInitialisationException {
        if (this.context != null) {
            String contextName = this.contextInstance.getName();
            this.teardownBigQueue();
            ContextService contextService = new ContextService();
            this.context = this.scheduledContextService.findByName(contextName).getContext();
            ContextInstance previousContextInstance = (ContextInstance)SerializationUtils.clone((Serializable)this.contextInstance);
            this.contextInstance = contextService.getContextInstance(contextService.getContextTemplateString(this.context));
            this.contextInstance.setId(UUID.randomUUID().toString());
            ContextHelper.enrichJobs((ContextInstance)this.contextInstance);
            this.init();
            SchedulerJobInstancesInitialisationParametersImpl parameters = new SchedulerJobInstancesInitialisationParametersImpl(holdCommandJobs);
            List schedulerJobInstances = this.schedulerJobInstanceService.initialiseSchedulerJobInstancesForContext(this.contextInstance, (SchedulerJobInstancesInitialisationParameters)parameters);
            this.internalEventDrivenJobInstances = schedulerJobInstances.stream().filter(job -> job instanceof InternalEventDrivenJobInstance).map(job -> (InternalEventDrivenJobInstance)job).collect(Collectors.toMap(key -> key.getIdentifier() + "-" + key.getChildContextName(), Function.identity(), (job1, job2) -> job1));
            this.globalEventJobInstanceMap = schedulerJobInstances.stream().filter(job -> job instanceof GlobalEventJobInstance).map(job -> (GlobalEventJobInstance)job).collect(Collectors.toMap(key -> key.getIdentifier() + "-" + key.getChildContextName(), Function.identity(), (job1, job2) -> job1));
            if (holdCommandJobs) {
                ContextHelper.holdAllJobs((ContextInstance)this.contextInstance, this.internalEventDrivenJobInstances);
            }
            this.internalEventDrivenJobInstances.entrySet().forEach(job -> {
                ContextInstance child;
                if (((InternalEventDrivenJobInstance)job.getValue()).isSkip()) {
                    child = ContextHelper.getChildContextInstance((String)((InternalEventDrivenJobInstance)job.getValue()).getChildContextName(), (ContextInstance)this.contextInstance);
                    ((SchedulerJobInstance)child.getScheduledJobsMap().get(((InternalEventDrivenJobInstance)job.getValue()).getIdentifier())).setSkip(((InternalEventDrivenJobInstance)job.getValue()).isSkip());
                    ((SchedulerJobInstance)child.getScheduledJobsMap().get(((InternalEventDrivenJobInstance)job.getValue()).getIdentifier())).setStatus(((InternalEventDrivenJobInstance)job.getValue()).getStatus());
                }
                if (((InternalEventDrivenJobInstance)job.getValue()).isHeld()) {
                    child = ContextHelper.getChildContextInstance((String)((InternalEventDrivenJobInstance)job.getValue()).getChildContextName(), (ContextInstance)this.contextInstance);
                    ((SchedulerJobInstance)child.getScheduledJobsMap().get(((InternalEventDrivenJobInstance)job.getValue()).getIdentifier())).setHeld(((InternalEventDrivenJobInstance)job.getValue()).isHeld());
                    ((SchedulerJobInstance)child.getScheduledJobsMap().get(((InternalEventDrivenJobInstance)job.getValue()).getIdentifier())).setStatus(((InternalEventDrivenJobInstance)job.getValue()).getStatus());
                }
            });
            this.globalEventJobInstanceMap.entrySet().forEach(job -> {
                if (((GlobalEventJobInstance)job.getValue()).isSkip()) {
                    ContextInstance child = ContextHelper.getChildContextInstance((String)((GlobalEventJobInstance)job.getValue()).getChildContextName(), (ContextInstance)this.contextInstance);
                    ((SchedulerJobInstance)child.getScheduledJobsMap().get(((GlobalEventJobInstance)job.getValue()).getIdentifier())).setSkip(((GlobalEventJobInstance)job.getValue()).isSkip());
                    ((SchedulerJobInstance)child.getScheduledJobsMap().get(((GlobalEventJobInstance)job.getValue()).getIdentifier())).setStatus(((GlobalEventJobInstance)job.getValue()).getStatus());
                }
            });
            if (contextParameterInstances != null) {
                this.contextInstance.setContextParameters(contextParameterInstances);
            } else if (initiateWithSameParameters) {
                this.contextInstance.setContextParameters(previousContextInstance.getContextParameters());
            } else {
                this.contextParametersInstanceService.populateContextParametersOnContextInstance(this.contextInstance, this.internalEventDrivenJobInstances);
            }
            this.agents.values().forEach(agent -> this.contextInstancePublicationService.remove(agent.getUrl(), (Object)previousContextInstance));
            this.agents.values().forEach(agent -> this.contextInstancePublicationService.publish(agent.getUrl(), (Object)this.contextInstance));
            this.jobLockCacheInitialisationService.initialiseJobLockCache((Context)this.context, true);
            this.contextInstance.setStartTime(System.currentTimeMillis());
            this.contextInstance.setProjectedEndTime(CronUtils.getEpochMilliOfPreviousFireTime(this.contextInstance.getTimeWindowStart()) + this.contextInstance.getContextTtlMilliseconds());
            this.issueContextInstanceStateChangeEvent((ContextInstanceStateChangeEvent)new ContextInstanceStateChangeEventImpl(previousContextInstance.getId(), previousContextInstance, previousContextInstance.getStatus(), InstanceStatus.ENDED));
            this.saveContext();
        }
    }

    private void teardownBigQueue() throws IOException {
        BigQueueContextMachineManagementServiceImpl bigQueueManagementService = new BigQueueContextMachineManagementServiceImpl(this.getInboundQueueName(), this.inboundQueue, this.getOutboundQueueName(), this.outboundQueue);
        BigQueueDirectoryManagementServiceImpl bigQueueDirectoryManagementService = new BigQueueDirectoryManagementServiceImpl((BigQueueManagementService)bigQueueManagementService, this.queueDir);
        if (this.inboundQueue != null) {
            this.inboundQueueMessageRunner.stop();
            this.inboundQueue.close();
            this.inboundQueue.removeAll();
            this.inboundQueue.gc();
            bigQueueDirectoryManagementService.deleteQueue(this.getInboundQueueName());
            this.inboundQueueMessageRunner.start();
        }
        if (this.outboundQueue != null) {
            this.outboundQueueMessageRunner.stop();
            this.outboundQueue.close();
            this.outboundQueue.removeAll();
            this.outboundQueue.gc();
            bigQueueDirectoryManagementService.deleteQueue(this.getOutboundQueueName());
            this.outboundQueueMessageRunner.start();
        }
    }

    public void teardown() throws IOException {
        this.tornDown = true;
        try {
            InstanceStatus previousStatus = this.contextInstance.getStatus();
            this.contextInstance.setStatus(InstanceStatus.ENDED);
            this.contextInstance.setEndTime(System.currentTimeMillis());
            InstanceStatus newStatus = this.contextInstance.getStatus();
            this.issueContextInstanceStateChangeEvent((ContextInstanceStateChangeEvent)new ContextInstanceStateChangeEventImpl(this.contextInstance.getId(), this.contextInstance, previousStatus, newStatus));
            this.saveContext();
            if (this.inboundQueue != null) {
                this.inboundQueueMessageRunner.stop();
                this.inboundQueue.close();
            }
            if (this.outboundQueue != null) {
                this.outboundQueueMessageRunner.stop();
                this.outboundQueue.close();
            }
            this.statusListenerExecutor.shutdownNow();
            this.contextExecutor.shutdownNow();
            this.schedulerInitiatorEventRaisedListenerExecutor.shutdownNow();
            if (this.contextInstanceStateChangeEventListeners != null) {
                this.contextInstanceStateChangeEventListeners.clear();
                this.contextInstanceStateChangeEventListeners = null;
            }
            this.statusListenerExecutor = null;
            this.schedulerInitiatorEventRaisedListenerExecutor = null;
            this.objectMapper = null;
            this.scheduledContextInstanceService = null;
            this.schedulerJobInitiationEventRaisedListener = null;
            this.context = null;
            this.dryRunParameters = null;
            this.internalEventDrivenJobInstances = null;
            this.globalEventJobInstanceMap = null;
            this.agents = null;
            this.jobLockCache = null;
            this.contextExecutor = null;
            this.inboundListenableFuture = null;
            this.outboundListenableFuture = null;
            this.jobLogicMachine.getExecutor().shutdownNow();
            this.jobLogicMachine = null;
            BigQueueContextMachineManagementServiceImpl bigQueueManagementService = new BigQueueContextMachineManagementServiceImpl(this.getInboundQueueName(), this.inboundQueue, this.getOutboundQueueName(), this.outboundQueue);
            BigQueueDirectoryManagementServiceImpl bigQueueDirectoryManagementService = new BigQueueDirectoryManagementServiceImpl((BigQueueManagementService)bigQueueManagementService, this.queueDir);
            if (this.inboundQueue != null) {
                this.inboundQueue.removeAll();
                this.inboundQueue.gc();
                bigQueueDirectoryManagementService.deleteQueue(this.getInboundQueueName());
            }
            if (this.outboundQueue != null) {
                this.outboundQueue.removeAll();
                this.outboundQueue.gc();
                bigQueueDirectoryManagementService.deleteQueue(this.getOutboundQueueName());
            }
            this.inboundQueue = null;
            this.outboundQueue = null;
            this.queueDir = null;
            this.contextInstance = null;
            this.statusConverter = null;
        }
        catch (Exception e) {
            this.logger.warn(String.format("Could not tear down context machine: Error [%s]", e.getMessage()));
        }
    }

    public void setSchedulerJobInitiationEventRaisedListener(SchedulerJobInitiationEventRaisedListener listener) {
        this.schedulerJobInitiationEventRaisedListener = listener;
    }

    public void eventReceived(String bigQueueMessage) throws IOException {
        if (!this.tornDown && this.inboundQueue != null) {
            this.inboundQueue.enqueue(bigQueueMessage.getBytes());
        } else {
            this.logger.warn("Ignoring inbound message[{}], tornDown[{}]].", (Object)bigQueueMessage, (Object)this.tornDown);
        }
    }

    public void raiseEvent(ContextualisedScheduledProcessEvent contextualisedScheduledProcessEvent) throws IOException {
        BigQueueMessageBuilder bigQueueMessageBuilder = new BigQueueMessageBuilder();
        bigQueueMessageBuilder.withMessage((Object)this.objectMapper.writeValueAsString((Object)contextualisedScheduledProcessEvent)).withMessageId(UUID.randomUUID().toString()).withCreatedTime(System.currentTimeMillis());
        if (this.inboundQueue != null) {
            this.inboundQueue.enqueue(this.objectMapper.writeValueAsBytes((Object)bigQueueMessageBuilder.build()));
        }
    }

    public InstanceStatus getContextStatus(String contextName) {
        ContextInstance instance = this.getContextInstanceByName(contextName, this.contextInstance);
        if (instance != null) {
            return instance.getStatus();
        }
        return null;
    }

    public InstanceStatus getJobStatus(String contextName, String jobIdentifier) {
        ContextInstance instance = this.getContextInstanceByName(contextName, this.contextInstance);
        SchedulerJobInstance schedulerJobInstance = (SchedulerJobInstance)instance.getScheduledJobsMap().get(jobIdentifier);
        if (schedulerJobInstance != null) {
            return schedulerJobInstance.getStatus();
        }
        return null;
    }

    public ContextInstanceStatus getContextInstanceStatus() {
        return this.statusConverter.convert(this.contextInstance);
    }

    public ContextInstance getContext(String contextName) {
        return this.getContextInstanceByName(contextName, this.contextInstance);
    }

    public ContextInstance getContext() {
        return this.contextInstance;
    }

    public void addSchedulerJobStateChangeEventListener(SchedulerJobInstanceStateChangeEventListener listener) {
        this.jobLogicMachine.addSchedulerJobStateChangeEventListener(listener);
    }

    public void removeSchedulerJobStateChangeEventListener(SchedulerJobInstanceStateChangeEventListener listener) {
        this.jobLogicMachine.removeSchedulerJobStateChangeEventListener(listener);
    }

    public void addContextInstanceStateChangeEventListener(ContextInstanceStateChangeEventListener listener) {
        if (!this.contextInstanceStateChangeEventListeners.contains(listener)) {
            this.contextInstanceStateChangeEventListeners.add(listener);
        }
    }

    public void removeContextInstanceStateChangeEventListener(ContextInstanceStateChangeEventListener listener) {
        if (this.contextInstanceStateChangeEventListeners.contains(listener)) {
            this.contextInstanceStateChangeEventListeners.remove(listener);
        }
    }

    public void setDryRunParameters(DryRunParameters dryRunParameters) {
        this.dryRunParameters = dryRunParameters;
    }

    public boolean isDryRun() {
        return this.dryRunParameters != null;
    }

    public void disableQuartzBasedJobs() {
        this.contextInstance.setQuartzScheduleDrivenJobsDisabledForContext(true);
        this.quartzScheduleDrivenJobInstanceMap.values().forEach(quartzScheduleDrivenJobInstance -> {
            SchedulerJobInstance schedulerJobInstance = ContextHelper.getSchedulerJobInstance((String)quartzScheduleDrivenJobInstance.getJobName(), (String)quartzScheduleDrivenJobInstance.getChildContextName(), (ContextInstance)this.contextInstance);
            if (schedulerJobInstance != null) {
                schedulerJobInstance.setStatus(InstanceStatus.DISABLED);
            }
        });
        this.saveContext();
    }

    public void enableQuartzBasedJobs() {
        this.contextInstance.setQuartzScheduleDrivenJobsDisabledForContext(false);
        this.quartzScheduleDrivenJobInstanceMap.values().forEach(quartzScheduleDrivenJobInstance -> {
            SchedulerJobInstance schedulerJobInstance = ContextHelper.getSchedulerJobInstance((String)quartzScheduleDrivenJobInstance.getJobName(), (String)quartzScheduleDrivenJobInstance.getChildContextName(), (ContextInstance)this.contextInstance);
            if (schedulerJobInstance != null) {
                schedulerJobInstance.setStatus(InstanceStatus.WAITING);
            }
        });
        this.saveContext();
    }

    public void runContextUntilManuallyEnded() {
        this.contextInstance.setRunContextUntilManuallyEnded(true);
        this.saveContext();
    }

    public void skipJob(String jobIdentifier, String childContextName, boolean skipFlag) {
        SchedulerJobInstance schedulerJobInstance = this.getSchedulerJob(this.contextInstance, childContextName, jobIdentifier);
        if (schedulerJobInstance != null) {
            if (this.internalEventDrivenJobInstances.containsKey(schedulerJobInstance.getIdentifier() + "-" + childContextName) && this.internalEventDrivenJobInstances.get(schedulerJobInstance.getIdentifier() + "-" + childContextName).isTargetResidingContextOnly()) {
                this._skipJob(List.of(schedulerJobInstance), skipFlag, false);
            } else {
                List<SchedulerJobInstance> jobInstances = this.getSchedulerJobs(this.contextInstance, jobIdentifier);
                this._skipJob(jobInstances, skipFlag, false);
            }
        } else {
            throw new ContextMachineException(String.format("Attempting to set skip flag on job[%s], however this job does not appear in context[%s] with instance id[%s], or any of its nested contexts.", jobIdentifier, this.contextInstance.getName(), this.contextInstance.getId()));
        }
    }

    public void skipJobs(String childContextName, boolean skipFlag) {
        Map schedulerJobInstanceMap = ContextHelper.getAllJobs((ContextInstance)ContextHelper.getChildContextInstance((String)childContextName, (ContextInstance)this.contextInstance));
        schedulerJobInstanceMap.values().forEach(schedulerJobInstance -> {
            HashMap jobs = new HashMap();
            this.internalEventDrivenJobInstances.entrySet().forEach(entry -> jobs.put((String)entry.getKey(), (SchedulerJob)entry.getValue()));
            this.globalEventJobInstanceMap.entrySet().forEach(entry -> jobs.put((String)entry.getKey(), (SchedulerJob)entry.getValue()));
            List contextTransitions = ContextHelper.determineIfSchedulerJobsTransitionFromOtherContexts((Context)this.contextInstance, (String)schedulerJobInstance.getJobName(), (String)schedulerJobInstance.getChildContextName(), jobs);
            if ((this.internalEventDrivenJobInstances.containsKey(schedulerJobInstance.getIdentifier() + "-" + schedulerJobInstance.getChildContextName()) || this.globalEventJobInstanceMap.containsKey("GLOBAL_EVENT-" + schedulerJobInstance.getJobName() + "-" + schedulerJobInstance.getChildContextName())) && contextTransitions.isEmpty()) {
                if (this.internalEventDrivenJobInstances.containsKey(schedulerJobInstance.getIdentifier() + "-" + schedulerJobInstance.getChildContextName()) && this.internalEventDrivenJobInstances.get(schedulerJobInstance.getIdentifier() + "-" + schedulerJobInstance.getChildContextName()).isTargetResidingContextOnly()) {
                    this._skipJob(List.of(schedulerJobInstance), skipFlag, true);
                } else {
                    List<SchedulerJobInstance> jobInstances = this.getSchedulerJobs(this.contextInstance, schedulerJobInstance.getIdentifier());
                    this._skipJob(jobInstances, skipFlag, true);
                }
            }
        });
    }

    private void _skipJob(List<SchedulerJobInstance> jobs, boolean skipFlag, boolean ignoreException) {
        jobs.forEach(schedulerJobInstance -> {
            if (!schedulerJobInstance.getStatus().equals((Object)InstanceStatus.WAITING) && !schedulerJobInstance.getStatus().equals((Object)InstanceStatus.RELEASED) && skipFlag || !schedulerJobInstance.getStatus().equals((Object)InstanceStatus.SKIPPED) && !skipFlag) {
                if (!ignoreException) {
                    throw new ContextMachineException(String.format("Attempting to set skip flag to [%s] on job[%s], in context[%s] with instance id[%s]. The job currently has a status of [%s] which cannot have the skip flag set.", skipFlag, schedulerJobInstance.getIdentifier(), this.contextInstance.getName(), this.contextInstance.getId(), schedulerJobInstance.getStatus()));
                }
                return;
            }
            SchedulerJobInstanceRecord schedulerJobInstanceRecord = this.schedulerJobInstanceService.findByContextIdJobNameChildContextName(this.contextInstance.getId(), schedulerJobInstance.getJobName(), schedulerJobInstance.getChildContextName());
            SchedulerJobInstance dbInstance = schedulerJobInstanceRecord.getSchedulerJobInstance();
            dbInstance.setSkip(skipFlag);
            InstanceStatus previousState = schedulerJobInstance.getStatus();
            schedulerJobInstance.setSkip(skipFlag);
            if (skipFlag) {
                schedulerJobInstance.setStatus(InstanceStatus.SKIPPED);
                dbInstance.setStatus(InstanceStatus.SKIPPED);
                schedulerJobInstanceRecord.setStatus(InstanceStatus.SKIPPED.name());
            } else {
                schedulerJobInstance.setStatus(InstanceStatus.WAITING);
                dbInstance.setStatus(InstanceStatus.WAITING);
                schedulerJobInstanceRecord.setStatus(InstanceStatus.WAITING.name());
            }
            schedulerJobInstanceRecord.setSchedulerJobInstance(dbInstance);
            this.schedulerJobInstanceService.save(schedulerJobInstanceRecord);
            this.saveContext();
            this.logger.info(String.format("Successfully set skip flag to [%s] on job[%s]. Context[%s], Child Context[%s], Context Instance[%s].", skipFlag, schedulerJobInstance.getIdentifier(), this.contextInstance.getName(), schedulerJobInstance.getChildContextName(), this.contextInstance.getId()));
            this.jobLogicMachine.issueSchedulerJobStateChangeEvent(new SchedulerJobInstanceStateChangeEventImpl(schedulerJobInstance, this.contextInstance, previousState, schedulerJobInstance.getStatus()));
            if (this.internalEventDrivenJobInstances.containsKey(schedulerJobInstance.getIdentifier() + "-" + schedulerJobInstance.getChildContextName())) {
                this.internalEventDrivenJobInstances.get(schedulerJobInstance.getIdentifier() + "-" + schedulerJobInstance.getChildContextName()).setSkip(skipFlag);
            }
        });
    }

    public void holdJob(String jobIdentifier, String childContextName) {
        SchedulerJobInstance schedulerJobInstance = this.getSchedulerJob(this.contextInstance, childContextName, jobIdentifier);
        if (schedulerJobInstance != null) {
            if (this.internalEventDrivenJobInstances.containsKey(schedulerJobInstance.getIdentifier() + "-" + childContextName) && this.internalEventDrivenJobInstances.get(schedulerJobInstance.getIdentifier() + "-" + childContextName).isTargetResidingContextOnly()) {
                this._holdJob(List.of(schedulerJobInstance));
            } else {
                List<SchedulerJobInstance> jobInstances = this.getSchedulerJobs(this.contextInstance, jobIdentifier);
                this._holdJob(jobInstances);
            }
        } else {
            throw new ContextMachineException(String.format("Attempting to hold job[%s], however this job does not appear in context[%s] with instance id[%s], or any of its nested contexts.", jobIdentifier, this.contextInstance.getName(), this.contextInstance.getId()));
        }
    }

    private void _holdJob(List<SchedulerJobInstance> jobs) {
        jobs.forEach(schedulerJobInstance -> {
            if (!schedulerJobInstance.getStatus().equals((Object)InstanceStatus.WAITING) && !schedulerJobInstance.getStatus().equals((Object)InstanceStatus.RELEASED)) {
                throw new ContextMachineException(String.format("Attempting to hold job[%s], in context[%s] with instance id[%s]. The job currently has a status of [%s] which cannot be put on hold.", schedulerJobInstance.getIdentifier(), this.contextInstance.getName(), this.contextInstance.getId(), schedulerJobInstance.getStatus()));
            }
            InstanceStatus previousState = schedulerJobInstance.getStatus();
            schedulerJobInstance.setHeld(true);
            schedulerJobInstance.setStatus(InstanceStatus.ON_HOLD);
            schedulerJobInstance.setContextInstanceId(this.contextInstance.getId());
            SchedulerJobInstanceRecord schedulerJobInstanceRecord = this.schedulerJobInstanceService.findByContextIdJobNameChildContextName(this.contextInstance.getId(), schedulerJobInstance.getJobName(), schedulerJobInstance.getChildContextName());
            SchedulerJobInstance dbInstance = schedulerJobInstanceRecord.getSchedulerJobInstance();
            dbInstance.setHeld(true);
            dbInstance.setStatus(InstanceStatus.ON_HOLD);
            schedulerJobInstanceRecord.setSchedulerJobInstance(dbInstance);
            this.schedulerJobInstanceService.save(schedulerJobInstanceRecord);
            this.saveContext();
            this.logger.info(String.format("Successfully held job[%s]. Context[%s], Context Instance[%s].", schedulerJobInstance.getIdentifier(), this.contextInstance.getName(), this.contextInstance.getId()));
            this.jobLogicMachine.issueSchedulerJobStateChangeEvent(new SchedulerJobInstanceStateChangeEventImpl(schedulerJobInstance, this.contextInstance, previousState, schedulerJobInstance.getStatus()));
        });
    }

    public void resetJob(String jobIdentifier, String childContextName) {
        SchedulerJobInstance schedulerJobInstance = this.getSchedulerJob(this.contextInstance, childContextName, jobIdentifier);
        if (schedulerJobInstance != null) {
            if (this.internalEventDrivenJobInstances.containsKey(schedulerJobInstance.getIdentifier() + "-" + childContextName) && this.internalEventDrivenJobInstances.get(schedulerJobInstance.getIdentifier() + "-" + childContextName).isTargetResidingContextOnly()) {
                this._resetJob(List.of(schedulerJobInstance));
            } else {
                List<SchedulerJobInstance> jobInstances = this.getSchedulerJobs(this.contextInstance, jobIdentifier);
                this._resetJob(jobInstances);
            }
        } else {
            throw new ContextMachineException(String.format("Attempting to reset job[%s], however this job does not appear in context[%s] with instance id[%s], or any of its nested contexts.", jobIdentifier, this.contextInstance.getName(), this.contextInstance.getId()));
        }
    }

    private void _resetJob(List<SchedulerJobInstance> jobs) {
        jobs.forEach(schedulerJobInstance -> {
            InstanceStatus previousState;
            if (schedulerJobInstance.getChildContextName() == null) {
                return;
            }
            if (schedulerJobInstance != null) {
                if (!(schedulerJobInstance.getStatus().equals((Object)InstanceStatus.COMPLETE) || schedulerJobInstance.getStatus().equals((Object)InstanceStatus.ERROR) || schedulerJobInstance.getStatus().equals((Object)InstanceStatus.WAITING))) {
                    throw new ContextMachineException(String.format("Attempting to reset job[%s], in context[%s] with instance id[%s]. The job currently has a status of [%s] which cannot be reset.", schedulerJobInstance.getIdentifier(), this.contextInstance.getName(), this.contextInstance.getId(), schedulerJobInstance.getStatus()));
                }
                previousState = schedulerJobInstance.getStatus();
                schedulerJobInstance.setStatus(InstanceStatus.WAITING);
                schedulerJobInstance.setInitiationEventRaised(false);
                ContextInstance child = ContextHelper.getChildContextInstance((String)schedulerJobInstance.getChildContextName(), (ContextInstance)this.contextInstance);
                if (child.getStatus().equals((Object)InstanceStatus.COMPLETE)) {
                    child.setStatus(InstanceStatus.RUNNING);
                    this.issueContextInstanceStateChangeEvent((ContextInstanceStateChangeEvent)new ContextInstanceStateChangeEventImpl(this.contextInstance.getId(), child, InstanceStatus.COMPLETE, InstanceStatus.RUNNING));
                }
            } else {
                throw new ContextMachineException(String.format("Attempting to reset job[%s], however this job does not appear in context[%s] with instance id[%s], or any of its nested contexts.", schedulerJobInstance.getIdentifier(), this.contextInstance.getName(), this.contextInstance.getId()));
            }
            this.saveContext();
            this.logger.info(String.format("Successfully reset job[%s]. Context[%s], Context Instance[%s].", schedulerJobInstance.getIdentifier(), this.contextInstance.getName(), this.contextInstance.getId()));
            this.jobLogicMachine.issueSchedulerJobStateChangeEvent(new SchedulerJobInstanceStateChangeEventImpl(schedulerJobInstance, this.contextInstance, previousState, schedulerJobInstance.getStatus()));
        });
    }

    public void releaseJob(String jobIdentifier, String childContextName) {
        SchedulerJobInstance schedulerJobInstance = this.getSchedulerJob(this.contextInstance, childContextName, jobIdentifier);
        if (schedulerJobInstance != null) {
            if (this.internalEventDrivenJobInstances.containsKey(schedulerJobInstance.getIdentifier() + "-" + childContextName) && this.internalEventDrivenJobInstances.get(schedulerJobInstance.getIdentifier() + "-" + childContextName).isTargetResidingContextOnly()) {
                this._releaseJob(List.of(schedulerJobInstance));
            } else {
                List<SchedulerJobInstance> jobInstances = this.getSchedulerJobs(this.contextInstance, jobIdentifier);
                this._releaseJob(jobInstances);
            }
        } else {
            throw new ContextMachineException(String.format("Attempting to hold job[%s], however this job does not appear in context[%s] with instance id[%s], or any of its nested contexts.", jobIdentifier, this.contextInstance.getName(), this.contextInstance.getId()));
        }
    }

    private void _releaseJob(List<SchedulerJobInstance> jobs) {
        jobs.forEach(schedulerJobInstance -> {
            if (schedulerJobInstance.getChildContextName() == null) {
                return;
            }
            SchedulerJobInitiationEvent event = (SchedulerJobInitiationEvent)this.contextInstance.getHeldJobs().get(schedulerJobInstance.getIdentifier() + "_" + schedulerJobInstance.getChildContextName());
            if (event != null) {
                InternalEventDrivenJobInstance instance = this.internalEventDrivenJobInstances.get(schedulerJobInstance.getIdentifier());
                if (instance != null && instance.isTargetResidingContextOnly()) {
                    event.getChildContextNames().clear();
                    event.getChildContextNames().add(schedulerJobInstance.getChildContextName());
                }
                this.contextInstance.getHeldJobs().remove(schedulerJobInstance.getIdentifier() + "_" + schedulerJobInstance.getChildContextName());
                BigQueueMessage bigQueueMessage = new BigQueueMessageBuilder().withMessage((Object)event).withMessageProperties(Map.of("contextName", this.context.getName(), "contextInstanceId", this.contextInstance.getId())).build();
                try {
                    String serialised = this.objectMapper.writeValueAsString((Object)bigQueueMessage);
                    this.logger.debug("Enqueue job initiation event: " + serialised);
                    this.outboundQueue.enqueue(serialised.getBytes());
                    this.logger.debug("Outbound queue size: " + this.outboundQueue.size());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new ContextMachineException(String.format("Attempting to release job[%s] currently held in context[%s] with instance id[%s]. Could not enqueue the outbound job initiation event!", schedulerJobInstance.getChildContextName(), this.contextInstance.getName(), this.contextInstance.getId()));
                }
                InstanceStatus previousState = schedulerJobInstance.getStatus();
                schedulerJobInstance.setHeld(false);
                schedulerJobInstance.setStatus(InstanceStatus.WAITING);
                schedulerJobInstance.setContextInstanceId(this.contextInstance.getId());
                this.saveContext();
                this.logger.info(String.format("Successfully released job[%s]. Context[%s], ChildContext[%s] Context Instance[%s].", schedulerJobInstance.getIdentifier(), this.contextInstance.getName(), schedulerJobInstance.getChildContextName(), this.contextInstance.getId()));
                this.jobLogicMachine.issueSchedulerJobStateChangeEvent(new SchedulerJobInstanceStateChangeEventImpl(schedulerJobInstance, this.contextInstance, previousState, schedulerJobInstance.getStatus()));
            } else if (schedulerJobInstance != null) {
                if (!schedulerJobInstance.getStatus().equals((Object)InstanceStatus.ON_HOLD) && !schedulerJobInstance.getStatus().equals((Object)InstanceStatus.WAITING)) {
                    throw new ContextMachineException(String.format("Attempting to release job[%s], in context[%s], childContext[%s] with instance id[%s]. The job currently has a status of [%s] which cannot be released.", schedulerJobInstance.getIdentifier(), this.contextInstance.getName(), schedulerJobInstance.getChildContextName(), this.contextInstance.getId(), schedulerJobInstance.getStatus()));
                }
                InstanceStatus previousState = schedulerJobInstance.getStatus();
                schedulerJobInstance.setHeld(false);
                schedulerJobInstance.setStatus(InstanceStatus.WAITING);
                schedulerJobInstance.setContextInstanceId(this.contextInstance.getId());
                this.saveContext();
                this.logger.info(String.format("Successfully released job[%s]. Context[%s], ChildContext[%s], Context Instance[%s].", schedulerJobInstance.getIdentifier(), this.contextInstance.getName(), schedulerJobInstance.getChildContextName(), this.contextInstance.getId()));
                this.jobLogicMachine.issueSchedulerJobStateChangeEvent(new SchedulerJobInstanceStateChangeEventImpl(schedulerJobInstance, this.contextInstance, previousState, schedulerJobInstance.getStatus()));
            } else {
                StringBuffer heldJobs = new StringBuffer();
                this.contextInstance.getHeldJobs().entrySet().forEach(entry -> heldJobs.append((String)entry.getKey()).append(", "));
                String heldJobsString = heldJobs.toString().trim();
                if (heldJobsString.endsWith(",")) {
                    heldJobsString = heldJobsString.substring(0, heldJobsString.length() - 1);
                }
                throw new ContextMachineException(String.format("Attempting to release job[%s], however this job is not currently held in context[%s] with instance id[%s]. Current held jobs[%s]. Nor is the job found in the context or any of its nested contexts!", schedulerJobInstance.getChildContextName(), this.contextInstance.getName(), this.contextInstance.getId(), heldJobsString));
            }
        });
    }

    public List<SchedulerJobInitiationEvent> getEventsThatCanRun(ContextualisedScheduledProcessEvent contextualisedScheduledProcessEvent) {
        MutableBoolean lockRaised = new MutableBoolean(false);
        List<SchedulerJobInitiationEvent> events = this.getInitiationEvents(this.contextInstance, contextualisedScheduledProcessEvent, lockRaised, false);
        ArrayList finalEvents = new ArrayList();
        events.forEach(event -> {
            if (event.getInternalEventDrivenJob() != null) {
                SchedulerJobInstance schedulerJobInstance = this.getSchedulerJob(this.contextInstance, event.getInternalEventDrivenJob().getChildContextName(), event.getInternalEventDrivenJob().getIdentifier());
                if (schedulerJobInstance != null && !schedulerJobInstance.isHeld()) {
                    finalEvents.add(event);
                }
            } else {
                GlobalEventJobInstance globalEventJobInstance = null;
                for (Map.Entry<String, GlobalEventJobInstance> globalEvents : this.globalEventJobInstanceMap.entrySet()) {
                    if (!StringUtils.equals((CharSequence)globalEvents.getValue().getJobName(), (CharSequence)event.getJobName())) continue;
                    globalEventJobInstance = globalEvents.getValue();
                    break;
                }
                if (globalEventJobInstance != null) {
                    finalEvents.add(event);
                } else {
                    this.logger.warn(String.format("Could not load internal event driven job for initiation event JobName[%s], SchedulerJobInitiationEvent[%s]", event.getJobName(), event.toString()));
                }
            }
        });
        return events;
    }

    public boolean servesAgent(String agentName) {
        if (this.agents != null) {
            return this.agents.keySet().contains(agentName);
        }
        return false;
    }

    protected List<SchedulerJobInitiationEvent> eventReceived(ContextualisedScheduledProcessEvent scheduledProcessEvent) {
        this.logger.info("Context Machine Received Event [{}]", (Object)scheduledProcessEvent);
        ContextInstance previousContextInstance = this.contextInstance;
        MutableBoolean lockRaised = new MutableBoolean(false);
        List<Object> events = new ArrayList();
        if (scheduledProcessEvent.getJobGroup() != null && !scheduledProcessEvent.getJobGroup().equals(MANUAL_SUBMISSION) && this.contextInstance.isQuartzScheduleDrivenJobsDisabledForContext() && this.quartzScheduleDrivenJobInstanceMap.containsKey(scheduledProcessEvent.getAgentName() + "-" + scheduledProcessEvent.getJobName())) {
            this.logger.info("Ignoring quartz scheduled job [{}] for context [{}] with instance id [{}]. Quartz based scheduler jobs are ignored for this context.", new Object[]{scheduledProcessEvent.getJobName(), this.contextInstance.getName(), this.contextInstance.getId()});
        } else {
            events = this.getInitiationEvents(this.contextInstance, scheduledProcessEvent, lockRaised, true);
        }
        ArrayList<SchedulerJobInitiationEvent> finalEvents = new ArrayList<SchedulerJobInitiationEvent>();
        events.forEach(event -> {
            if (event.getInternalEventDrivenJob() != null) {
                SchedulerJobInstance schedulerJobInstance = this.getSchedulerJob(this.contextInstance, event.getInternalEventDrivenJob().getChildContextName(), event.getInternalEventDrivenJob().getIdentifier());
                if (schedulerJobInstance != null && schedulerJobInstance.isHeld()) {
                    this.contextInstance.getHeldJobs().put(schedulerJobInstance.getIdentifier() + "_" + event.getInternalEventDrivenJob().getChildContextName(), event);
                } else {
                    finalEvents.add((SchedulerJobInitiationEvent)event);
                }
            } else {
                GlobalEventJobInstance globalEventJobInstance = null;
                for (Map.Entry<String, GlobalEventJobInstance> globalEvents : this.globalEventJobInstanceMap.entrySet()) {
                    if (!StringUtils.equals((CharSequence)globalEvents.getValue().getJobName(), (CharSequence)event.getJobName())) continue;
                    globalEventJobInstance = globalEvents.getValue();
                    globalEventJobInstance.setScheduledProcessEvent((ScheduledProcessEvent)scheduledProcessEvent);
                    break;
                }
                if (globalEventJobInstance != null) {
                    finalEvents.add((SchedulerJobInitiationEvent)event);
                } else {
                    this.logger.warn(String.format("Could not load internal event driven job for initiation event JobName[%s], SchedulerJobInitiationEvent[%s]", event.getJobName(), event));
                }
            }
        });
        this.saveInstanceAuditRecord(scheduledProcessEvent, finalEvents, previousContextInstance, this.contextInstance);
        return finalEvents;
    }

    private void saveInstanceAuditRecord(ContextualisedScheduledProcessEvent scheduledProcessEvent, List<SchedulerJobInitiationEvent> finalEvents, ContextInstance previousContextInstance, ContextInstance updatedContextInstance) {
        ScheduledContextInstanceAuditAggregateImpl contextInstanceAudit = new ScheduledContextInstanceAuditAggregateImpl();
        contextInstanceAudit.setProcessEvent(scheduledProcessEvent);
        contextInstanceAudit.setSchedulerJobInitiationEvents(finalEvents);
        ScheduledContextInstanceAuditAggregateRecordImpl auditRecord = new ScheduledContextInstanceAuditAggregateRecordImpl();
        auditRecord.setContextName(this.contextInstance.getName());
        auditRecord.setContextInstanceId(this.contextInstance.getId());
        auditRecord.setScheduledProcessEventName(scheduledProcessEvent.getJobName());
        auditRecord.setScheduledContextInstanceAuditAggregate((ScheduledContextInstanceAuditAggregate)contextInstanceAudit);
        this.scheduledContextInstanceService.saveAudit((ScheduledContextInstanceAuditAggregateRecord)auditRecord, previousContextInstance, updatedContextInstance);
    }

    private List<SchedulerJobInitiationEvent> getInitiationEvents(ContextInstance contextInstance, ContextualisedScheduledProcessEvent scheduledProcessEvent, MutableBoolean lockRaised, boolean markAsRaised) {
        ArrayList<SchedulerJobInitiationEvent> results = new ArrayList<SchedulerJobInitiationEvent>();
        if (contextInstance.getScheduledJobsMap().containsKey(scheduledProcessEvent.getAgentName() + "-" + scheduledProcessEvent.getJobName())) {
            List<SchedulerJobInitiationEvent> events = this.jobLogicMachine.getJobInitiationEvents(scheduledProcessEvent, contextInstance, this.dryRunParameters, this.globalEventJobInstanceMap, this.internalEventDrivenJobInstances, this.contextInstance.getContextParameters(), this.contextInstance, lockRaised, markAsRaised);
            this.setContextStatus(contextInstance);
            if (contextInstance.getContexts() == null || contextInstance.getContexts().isEmpty()) {
                return events;
            }
            results.addAll(events);
        }
        if (contextInstance.getContexts() != null && !contextInstance.getContexts().isEmpty()) {
            for (ContextInstance instance : contextInstance.getContexts()) {
                results.addAll(this.getInitiationEvents(instance, scheduledProcessEvent, lockRaised, markAsRaised));
                this.setContextStatus(contextInstance);
            }
        }
        return results;
    }

    private ContextInstance getContextInstanceByName(String contextName, ContextInstance contextInstance) {
        if (contextInstance.getName().equals(contextName)) {
            return contextInstance;
        }
        if (contextInstance.getContexts() != null) {
            for (ContextInstance context : contextInstance.getContexts()) {
                ContextInstance result = this.getContextInstanceByName(contextName, context);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private void setContextStatus(ContextInstance contextInstance) {
        AtomicBoolean allJobsComplete = new AtomicBoolean(true);
        AtomicBoolean allLogicSatisfied = new AtomicBoolean(true);
        AtomicBoolean anyRunningOrCompletedOrQueuedJobs = new AtomicBoolean(false);
        AtomicBoolean anyErrorJobs = new AtomicBoolean(false);
        AtomicBoolean allContextsComplete = new AtomicBoolean(true);
        AtomicBoolean anyRunningOrCompletedContexts = new AtomicBoolean(false);
        AtomicBoolean anyErrorContexts = new AtomicBoolean(false);
        if (contextInstance.getScheduledJobs() != null && !contextInstance.getScheduledJobs().isEmpty()) {
            Map jobsOutsideLogicConstructs = ContextHelper.getJobsOutsideLogicalGrouping((Context)contextInstance);
            jobsOutsideLogicConstructs.entrySet().forEach(entry -> {
                if (!(((SchedulerJobInstance)entry.getValue()).getStatus().equals((Object)InstanceStatus.COMPLETE) || ((SchedulerJobInstance)entry.getValue()).getStatus().equals((Object)InstanceStatus.SKIPPED) || ((SchedulerJobInstance)entry.getValue()).getStatus().equals((Object)InstanceStatus.SKIPPED_COMPLETE))) {
                    allJobsComplete.set(false);
                }
            });
            allLogicSatisfied.set(this.contextStateHelper.isAllLogicSatisfied(contextInstance, contextInstance.getScheduledJobsMap()));
            contextInstance.getScheduledJobs().forEach(job -> {
                if (job.getStatus().equals((Object)InstanceStatus.RUNNING) || job.getStatus().equals((Object)InstanceStatus.COMPLETE) || job.getStatus().equals((Object)InstanceStatus.LOCK_QUEUED)) {
                    anyRunningOrCompletedOrQueuedJobs.set(true);
                }
                if (job.getStatus().equals((Object)InstanceStatus.ERROR)) {
                    anyErrorJobs.set(true);
                }
            });
        }
        if (contextInstance.getContexts() != null && !contextInstance.getContexts().isEmpty()) {
            contextInstance.getContexts().forEach(context -> {
                if (!context.getStatus().equals((Object)InstanceStatus.COMPLETE)) {
                    allContextsComplete.set(false);
                }
                if (context.getStatus().equals((Object)InstanceStatus.RUNNING) || context.getStatus().equals((Object)InstanceStatus.COMPLETE)) {
                    anyRunningOrCompletedContexts.set(true);
                }
                if (context.getStatus().equals((Object)InstanceStatus.ERROR)) {
                    anyErrorContexts.set(true);
                }
            });
        }
        InstanceStatus previousStatus = contextInstance.getStatus();
        if (anyErrorJobs.get() || anyErrorContexts.get()) {
            contextInstance.setStatus(InstanceStatus.ERROR);
            contextInstance.setUpdatedDateTime(System.currentTimeMillis());
        } else if (allJobsComplete.get() && allContextsComplete.get() && allLogicSatisfied.get()) {
            contextInstance.setStatus(InstanceStatus.COMPLETE);
            contextInstance.setUpdatedDateTime(System.currentTimeMillis());
        } else if (anyRunningOrCompletedOrQueuedJobs.get() || anyRunningOrCompletedContexts.get()) {
            contextInstance.setStatus(InstanceStatus.RUNNING);
            contextInstance.setUpdatedDateTime(System.currentTimeMillis());
        }
        InstanceStatus newStatus = contextInstance.getStatus();
        if (!previousStatus.equals((Object)newStatus)) {
            this.issueContextInstanceStateChangeEvent((ContextInstanceStateChangeEvent)new ContextInstanceStateChangeEventImpl(this.contextInstance.getId(), contextInstance, previousStatus, newStatus));
        }
    }

    public void addQueuedSchedulerJobInitiationEvent(SchedulerJobInitiationEvent event) {
        ContextInstance childContextInstance = ContextHelper.getChildContextInstance((String)event.getInternalEventDrivenJob().getChildContextName(), (ContextInstance)this.contextInstance);
        this.jobLogicMachine.addQueuedSchedulerJobInitiationEvent(childContextInstance, this.contextInstance, event.getInternalEventDrivenJob().getIdentifier(), event);
        this.setContextStatus(childContextInstance);
        this.saveContext();
    }

    private void issueContextInstanceStateChangeEvent(ContextInstanceStateChangeEvent event) {
        this.statusListenerExecutor.submit(() -> this.contextInstanceStateChangeEventListeners.forEach(listener -> listener.onContextInstanceStateChangeEvent(event)));
    }

    public void saveContext() {
        ScheduledContextInstanceRecordImpl scheduledContextInstanceRecord = new ScheduledContextInstanceRecordImpl();
        scheduledContextInstanceRecord.setContextName(this.contextInstance.getName());
        scheduledContextInstanceRecord.setContextInstance(this.contextInstance);
        scheduledContextInstanceRecord.setTimestamp(this.contextInstance.getCreatedDateTime());
        scheduledContextInstanceRecord.setStatus(this.contextInstance.getStatus().name());
        this.scheduledContextInstanceService.save((ScheduledContextInstanceRecord)scheduledContextInstanceRecord);
    }

    private SchedulerJobInstance getSchedulerJob(ContextInstance contextInstance, String childContextName, String jobIdentifier) {
        if (contextInstance.getScheduledJobsMap() != null && contextInstance.getScheduledJobsMap().containsKey(jobIdentifier) && contextInstance.getName().equals(childContextName)) {
            return (SchedulerJobInstance)contextInstance.getScheduledJobsMap().get(jobIdentifier);
        }
        if (contextInstance.getContexts() != null && !contextInstance.getContexts().isEmpty()) {
            for (ContextInstance contextInstance1 : contextInstance.getContexts()) {
                SchedulerJobInstance schedulerJobInstance = this.getSchedulerJob(contextInstance1, childContextName, jobIdentifier);
                if (schedulerJobInstance == null) continue;
                return schedulerJobInstance;
            }
            return null;
        }
        return null;
    }

    private List<SchedulerJobInstance> getSchedulerJobs(ContextInstance contextInstance, String jobIdentifier) {
        ArrayList<SchedulerJobInstance> results = new ArrayList<SchedulerJobInstance>();
        this.getSchedulerJobs(contextInstance, jobIdentifier, results);
        return results;
    }

    private void getSchedulerJobs(ContextInstance contextInstance, String jobIdentifier, List<SchedulerJobInstance> results) {
        if (contextInstance.getScheduledJobsMap() != null && contextInstance.getScheduledJobsMap().containsKey(jobIdentifier)) {
            results.add((SchedulerJobInstance)contextInstance.getScheduledJobsMap().get(jobIdentifier));
        }
        if (contextInstance.getContexts() != null && !contextInstance.getContexts().isEmpty()) {
            for (ContextInstance contextInstance1 : contextInstance.getContexts()) {
                this.getSchedulerJobs(contextInstance1, jobIdentifier, results);
            }
        }
    }

    public void broadcastGlobalEvents(SchedulerJobInitiationEvent schedulerJobInitiationEvent, boolean ignoreEnvironmentGroup, boolean forceSending) throws IOException {
        GlobalEventJobInstance globalEventJobInstance = null;
        if (this.globalEventJobInstanceMap != null && this.globalEventJobInstanceMap.size() != 0) {
            for (Map.Entry<String, GlobalEventJobInstance> globalEvents : this.globalEventJobInstanceMap.entrySet()) {
                if (!StringUtils.equals((CharSequence)globalEvents.getValue().getJobName(), (CharSequence)schedulerJobInitiationEvent.getJobName())) continue;
                globalEventJobInstance = globalEvents.getValue();
                break;
            }
        }
        if (globalEventJobInstance != null || forceSending) {
            this.logger.info("Job [{}] is a Global Event Job - Do not send to the agent [{}] and attempt to send to all Active Contexts by Environment Group", (Object)schedulerJobInitiationEvent.getJobName(), (Object)schedulerJobInitiationEvent.getAgentUrl());
            this.logger.info("[{}] Context is part of the EnvironmentGroup [{}]. ignoreEnvironmentGroup is set to [{}]. Will send to Contexts with the same Environment Group if ignoreEnvironmentGroup = false", new Object[]{this.context.getName(), this.context.getEnvironmentGroup(), ignoreEnvironmentGroup});
            List<String> contextInstanceInContextMachineCache = ContextMachineCache.instance().getListOfContextInstanceIdByEnvironmentGroup(this.context.getEnvironmentGroup(), ignoreEnvironmentGroup);
            for (String contextInstanceIdFromCache : contextInstanceInContextMachineCache) {
                ContextMachine contextMachineFromCache = ContextMachineCache.instance().getByContextInstanceId(contextInstanceIdFromCache);
                if (contextMachineFromCache == null) {
                    this.logger.warn("Unable to find the ContextMachine for the instance [{}] in the cache, skipping sending the Global Event [{}] to it", (Object)contextInstanceIdFromCache, (Object)schedulerJobInitiationEvent.getJobName());
                    continue;
                }
                if (contextMachineFromCache.getContext().getStatus().equals((Object)InstanceStatus.PREPARED)) {
                    this.logger.info("Will not broadcast global event to instance [{}], Global Event [{}]. The instance is currently in a prepared state.", (Object)contextInstanceIdFromCache, (Object)schedulerJobInitiationEvent.getJobName());
                    continue;
                }
                if (schedulerJobInitiationEvent.isSkipped() && !schedulerJobInitiationEvent.getContextInstanceId().equals(contextInstanceIdFromCache)) continue;
                ContextualisedScheduledProcessEventImpl globalContextualisedScheduledProcessEvent = new ContextualisedScheduledProcessEventImpl();
                globalContextualisedScheduledProcessEvent.setAgentName("GLOBAL_EVENT");
                globalContextualisedScheduledProcessEvent.setJobName(schedulerJobInitiationEvent.getJobName());
                globalContextualisedScheduledProcessEvent.setSuccessful(true);
                globalContextualisedScheduledProcessEvent.setFireTime(System.currentTimeMillis());
                globalContextualisedScheduledProcessEvent.setContextName(schedulerJobInitiationEvent.getContextName());
                globalContextualisedScheduledProcessEvent.setContextInstanceId(contextInstanceIdFromCache);
                globalContextualisedScheduledProcessEvent.setJobStarting(false);
                globalContextualisedScheduledProcessEvent.setSkipped(schedulerJobInitiationEvent.isSkipped());
                globalContextualisedScheduledProcessEvent.setCatalystEvent(schedulerJobInitiationEvent.getCatalystEvent());
                String globalContextualisedScheduledProcessEventJson = this.objectMapper.writeValueAsString((Object)globalContextualisedScheduledProcessEvent);
                BigQueueMessage outgoingBigQueueMessage = new BigQueueMessageBuilder().withMessage((Object)globalContextualisedScheduledProcessEventJson).withMessageProperties(Map.of("contextName", contextMachineFromCache.getContext().getName(), "contextInstanceId", contextMachineFromCache.getContext().getId())).build();
                String jsonString = this.objectMapper.writeValueAsString((Object)outgoingBigQueueMessage);
                contextMachineFromCache.eventReceived(jsonString);
                this.logger.info("Sending Global Event [{}] to the ContextMachine [{}][{}]", new Object[]{schedulerJobInitiationEvent.getJobName(), contextMachineFromCache.getContext().getName(), contextMachineFromCache.getContext().getId()});
            }
        }
    }

    private void addInboundListener() {
        try {
            this.inboundListenableFuture = this.inboundQueue.peekAsync();
            this.inboundQueueMessageRunner = new InboundQueueMessageRunner();
            this.inboundListenableFuture.addListener((Runnable)this.inboundQueueMessageRunner, (Executor)this.contextExecutor);
        }
        catch (Exception e) {
            this.logger.warn("Could not add inbound listener for context machine. This is likely due to the context instance being ended.");
        }
    }

    protected void addOutboundListener() {
        this.outboundListenableFuture = this.outboundQueue.peekAsync();
        this.outboundQueueMessageRunner = new OutboundQueueMessageRunner();
        this.outboundListenableFuture.addListener((Runnable)this.outboundQueueMessageRunner, (Executor)this.schedulerInitiatorEventRaisedListenerExecutor);
    }

    protected Map<String, GlobalEventJobInstance> getGlobalEventJobInstanceMap() {
        return this.globalEventJobInstanceMap;
    }

    public Map<String, InternalEventDrivenJobInstance> getInternalEventDrivenJobInstancesMap() {
        return this.internalEventDrivenJobInstances;
    }

    protected class OutboundQueueMessageRunner
    implements Runnable {
        private final AtomicBoolean running = new AtomicBoolean(true);

        protected OutboundQueueMessageRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            block23: {
                BigQueueMessage bigQueueMessage;
                boolean exception;
                block21: {
                    byte[] event;
                    block19: {
                        block20: {
                            if (!this.running.get()) {
                                return;
                            }
                            exception = false;
                            bigQueueMessage = null;
                            event = ContextMachine.this.outboundQueue.peek();
                            if (event != null) break block19;
                            if (exception) break block20;
                            try {
                                ContextMachine.this.outboundQueue.dequeue();
                                ContextMachine.this.outboundQueue.gc();
                                ContextMachine.this.logger.debug("Dequeue event: " + bigQueueMessage);
                                ContextMachine.this.logger.debug("Outbound queue size: " + ContextMachine.this.outboundQueue.size());
                            }
                            catch (IOException e) {
                                ContextMachine.this.logger.error(String.format("An error has occurred attempting to dequeue outbound message [%s]", bigQueueMessage != null ? bigQueueMessage.getMessage() : "NULL message"), (Throwable)e);
                                e.printStackTrace();
                            }
                        }
                        ContextMachine.this.addOutboundListener();
                        return;
                    }
                    bigQueueMessage = (BigQueueMessage)ContextMachine.this.objectMapper.readValue(event, BigQueueMessageImpl.class);
                    String messageAsString = new String(ContextMachine.this.objectMapper.writeValueAsBytes(bigQueueMessage.getMessage()));
                    SchedulerJobInitiationEvent schedulerJobInitiationEvent = (SchedulerJobInitiationEvent)ContextMachine.this.objectMapper.readValue(messageAsString, SchedulerJobInitiationEventImpl.class);
                    if (ContextMachine.this.schedulerJobInitiationEventRaisedListener != null) {
                        ContextMachine.this.schedulerJobInitiationEventRaisedListener.onSchedulerJobInitiationEventRaised(schedulerJobInitiationEvent);
                    }
                    ContextMachine.this.attempts = 0;
                    if (exception) break block21;
                    try {
                        ContextMachine.this.outboundQueue.dequeue();
                        ContextMachine.this.outboundQueue.gc();
                        ContextMachine.this.logger.debug("Dequeue event: " + bigQueueMessage);
                        ContextMachine.this.logger.debug("Outbound queue size: " + ContextMachine.this.outboundQueue.size());
                    }
                    catch (IOException e) {
                        ContextMachine.this.logger.error(String.format("An error has occurred attempting to dequeue outbound message [%s]", bigQueueMessage != null ? bigQueueMessage.getMessage() : "NULL message"), (Throwable)e);
                        e.printStackTrace();
                    }
                }
                ContextMachine.this.addOutboundListener();
                break block23;
                catch (Exception e) {
                    block22: {
                        try {
                            ContextMachine.this.logger.error(String.format("An error has occurred attempting to raise job initiation event [%s]", bigQueueMessage != null ? bigQueueMessage.getMessage() : "NULL message"), (Throwable)e);
                            exception = true;
                            try {
                                ContextMachine.this.outboundQueue.enqueue(ContextMachine.this.outboundQueue.dequeue());
                                ContextMachine.this.outboundQueue.gc();
                                long sleepTime = 500L * (long)ContextMachine.this.attempts * 1L;
                                if (sleepTime > ContextMachine.this.maxWait) {
                                    sleepTime = ContextMachine.this.maxWait;
                                }
                                Thread.sleep(sleepTime);
                                ++ContextMachine.this.attempts;
                            }
                            catch (Exception ex) {
                                ContextMachine.this.logger.error(String.format("An error has occurred attempting to enqueue outbound message that is in error [%s]", bigQueueMessage != null ? bigQueueMessage.getMessage() : "NULL message"), (Throwable)e);
                                ex.printStackTrace();
                            }
                            if (exception) break block22;
                        }
                        catch (Throwable throwable) {
                            if (!exception) {
                                try {
                                    ContextMachine.this.outboundQueue.dequeue();
                                    ContextMachine.this.outboundQueue.gc();
                                    ContextMachine.this.logger.debug("Dequeue event: " + bigQueueMessage);
                                    ContextMachine.this.logger.debug("Outbound queue size: " + ContextMachine.this.outboundQueue.size());
                                }
                                catch (IOException e2) {
                                    ContextMachine.this.logger.error(String.format("An error has occurred attempting to dequeue outbound message [%s]", bigQueueMessage != null ? bigQueueMessage.getMessage() : "NULL message"), (Throwable)e2);
                                    e2.printStackTrace();
                                }
                            }
                            ContextMachine.this.addOutboundListener();
                            throw throwable;
                        }
                        try {
                            ContextMachine.this.outboundQueue.dequeue();
                            ContextMachine.this.outboundQueue.gc();
                            ContextMachine.this.logger.debug("Dequeue event: " + bigQueueMessage);
                            ContextMachine.this.logger.debug("Outbound queue size: " + ContextMachine.this.outboundQueue.size());
                        }
                        catch (IOException e3) {
                            ContextMachine.this.logger.error(String.format("An error has occurred attempting to dequeue outbound message [%s]", bigQueueMessage != null ? bigQueueMessage.getMessage() : "NULL message"), (Throwable)e3);
                            e3.printStackTrace();
                        }
                    }
                    ContextMachine.this.addOutboundListener();
                }
            }
        }

        public void stop() {
            this.running.set(false);
        }

        public void start() {
            this.running.set(true);
        }
    }

    protected class InboundQueueMessageRunner
    implements Runnable {
        private final AtomicBoolean running = new AtomicBoolean(true);

        protected InboundQueueMessageRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BigQueueMessage bigQueueMessage = null;
            try {
                if (!this.running.get()) {
                    return;
                }
                byte[] event = ContextMachine.this.inboundQueue.peek();
                if (event == null) {
                    return;
                }
                bigQueueMessage = (BigQueueMessage)ContextMachine.this.objectMapper.readValue(event, BigQueueMessageImpl.class);
                ContextualisedScheduledProcessEvent scheduledProcessEvent = (ContextualisedScheduledProcessEvent)ContextMachine.this.objectMapper.readValue(String.valueOf(bigQueueMessage.getMessage()), ContextualisedScheduledProcessEventImpl.class);
                List<SchedulerJobInitiationEvent> schedulerJobInitiationEvents = ContextMachine.this.eventReceived(scheduledProcessEvent);
                ContextMachine.this.saveContext();
                for (SchedulerJobInitiationEvent schedulerJobInitiationEvent : schedulerJobInitiationEvents) {
                    if (schedulerJobInitiationEvent.getInternalEventDrivenJob() != null) {
                        BigQueueMessage outgoingBigQueueMessage = new BigQueueMessageBuilder().withMessage((Object)schedulerJobInitiationEvent).withMessageProperties(Map.of("contextName", schedulerJobInitiationEvent.getContextName(), "contextInstanceId", schedulerJobInitiationEvent.getContextInstanceId())).build();
                        String serialised = ContextMachine.this.objectMapper.writeValueAsString((Object)outgoingBigQueueMessage);
                        ContextMachine.this.logger.debug("Enqueue job initiation event: " + serialised);
                        ContextMachine.this.outboundQueue.enqueue(serialised.getBytes());
                        ContextMachine.this.logger.debug("Outbound queue size: " + ContextMachine.this.outboundQueue.size());
                        continue;
                    }
                    ContextMachine.this.broadcastGlobalEvents(schedulerJobInitiationEvent, false, false);
                }
                ContextMachine.this.inboundQueue.dequeue();
                ContextMachine.this.inboundQueue.gc();
            }
            catch (ContextMachineException e) {
                ContextMachine.this.logger.error(String.format("An error has occurred attempting process scheduled process event [%s]", bigQueueMessage != null ? bigQueueMessage.getMessage() : "NULL message"), (Throwable)e);
                try {
                    ContextMachine.this.inboundQueue.dequeue();
                    ContextMachine.this.inboundQueue.gc();
                    ContextMachine.this.addInboundListener();
                }
                catch (IOException ex) {
                    ContextMachine.this.logger.error(String.format("IOException - An error has occurred attempting to dequeue inbound message [%s]", bigQueueMessage != null ? bigQueueMessage.getMessage() : "NULL message"), (Throwable)ex);
                }
            }
            catch (Exception e) {
                ContextMachine.this.logger.error(String.format("Generic Exception - An error has occurred attempting process scheduled process event [%s]", bigQueueMessage != null ? bigQueueMessage.getMessage() : "NULL message"), (Throwable)e);
            }
            finally {
                ContextMachine.this.addInboundListener();
            }
        }

        public void stop() {
            this.running.set(false);
        }

        public void start() {
            this.running.set(true);
        }
    }
}

