/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.job.orchestration.core.machine;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.ikasan.job.orchestration.context.util.JobThreadFactory;
import org.ikasan.job.orchestration.core.machine.AbstractLogicMachine;
import org.ikasan.job.orchestration.core.machine.ContextMachineException;
import org.ikasan.job.orchestration.model.event.SchedulerJobInitiationEventImpl;
import org.ikasan.job.orchestration.model.event.SchedulerJobInstanceStateChangeEventImpl;
import org.ikasan.job.orchestration.model.instance.ContextParameterInstanceImpl;
import org.ikasan.spec.metadata.ModuleMetaData;
import org.ikasan.spec.scheduled.context.model.JobDependency;
import org.ikasan.spec.scheduled.context.model.JobLockCache;
import org.ikasan.spec.scheduled.context.model.LogicalGrouping;
import org.ikasan.spec.scheduled.core.listener.SchedulerJobInstanceStateChangeEventListener;
import org.ikasan.spec.scheduled.event.model.ContextualisedScheduledProcessEvent;
import org.ikasan.spec.scheduled.event.model.DryRunParameters;
import org.ikasan.spec.scheduled.event.model.Outcome;
import org.ikasan.spec.scheduled.event.model.ScheduledProcessEvent;
import org.ikasan.spec.scheduled.event.model.SchedulerJobInitiationEvent;
import org.ikasan.spec.scheduled.event.model.SchedulerJobInstanceStateChangeEvent;
import org.ikasan.spec.scheduled.instance.model.ContextInstance;
import org.ikasan.spec.scheduled.instance.model.ContextParameterInstance;
import org.ikasan.spec.scheduled.instance.model.GlobalEventJobInstance;
import org.ikasan.spec.scheduled.instance.model.InstanceStatus;
import org.ikasan.spec.scheduled.instance.model.InternalEventDrivenJobInstance;
import org.ikasan.spec.scheduled.instance.model.SchedulerJobInstance;
import org.ikasan.spec.scheduled.instance.service.ContextParametersInstanceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobLogicMachine
extends AbstractLogicMachine<SchedulerJobInstance> {
    private Logger logger = LoggerFactory.getLogger(JobLogicMachine.class);
    private List<SchedulerJobInstanceStateChangeEventListener> schedulerJobInstanceStateChangeEventListeners;
    private ExecutorService executor;
    private Map<String, ModuleMetaData> agents;
    private JobLockCache jobLockCache;
    private ContextParametersInstanceService contextParametersInstanceService;

    public JobLogicMachine(Map<String, ModuleMetaData> agents, JobLockCache jobLockCache, ContextParametersInstanceService contextParametersInstanceService) {
        this.agents = agents;
        this.schedulerJobInstanceStateChangeEventListeners = new ArrayList<SchedulerJobInstanceStateChangeEventListener>();
        this.executor = Executors.newFixedThreadPool(5, new JobThreadFactory("JobLogicMachine"));
        this.jobLockCache = jobLockCache;
        this.contextParametersInstanceService = contextParametersInstanceService;
    }

    protected List<SchedulerJobInitiationEvent> getJobInitiationEvents(ContextualisedScheduledProcessEvent scheduledProcessEvent, ContextInstance contextInstance, DryRunParameters dryRunParameters, Map<String, GlobalEventJobInstance> globalEventJobInstanceMap, Map<String, InternalEventDrivenJobInstance> internalEventDrivenJobs, List<ContextParameterInstance> contextParameters, ContextInstance parentContextInstance, MutableBoolean lockRaised, boolean markAsRaised) {
        SchedulerJobInstance schedulerJobInstance = (SchedulerJobInstance)contextInstance.getScheduledJobsMap().get(scheduledProcessEvent.getAgentName() + "-" + scheduledProcessEvent.getJobName());
        if (schedulerJobInstance == null) {
            this.logger.warn("Scheduler job instance is null! Attempted lookup using job identifier[{}]", (Object)(scheduledProcessEvent.getAgentName() + "-" + scheduledProcessEvent.getJobName()));
        }
        if (scheduledProcessEvent.getChildContextNames() != null && scheduledProcessEvent.getChildContextNames().contains(contextInstance.getName())) {
            StringBuffer childContextNames = new StringBuffer("[");
            scheduledProcessEvent.getChildContextNames().forEach(id -> childContextNames.append("{").append(id).append("}"));
            childContextNames.append("]");
            this.logger.info("Processing Schedule Process Event [{}], for Context Instance [{}] with identifier [{}], with Child Ids {}", new Object[]{scheduledProcessEvent.getJobName(), contextInstance.getName(), contextInstance.getId(), childContextNames});
        }
        if (schedulerJobInstance != null && (scheduledProcessEvent.getChildContextNames() == null || scheduledProcessEvent.getChildContextNames().isEmpty() || scheduledProcessEvent.getChildContextNames().contains(contextInstance.getName()))) {
            InstanceStatus currentJobState = schedulerJobInstance.getStatus();
            schedulerJobInstance.setScheduledProcessEvent((ScheduledProcessEvent)scheduledProcessEvent);
            schedulerJobInstance.setChildContextName(contextInstance.getName());
            schedulerJobInstance.setContextInstanceId(parentContextInstance.getId());
            if (scheduledProcessEvent.isRaisedDueToFailureResubmission()) {
                if (scheduledProcessEvent.getInternalEventDrivenJob().getChildContextName() != null && scheduledProcessEvent.getInternalEventDrivenJob().getChildContextName().equals(contextInstance.getName())) {
                    if (!schedulerJobInstance.getStatus().equals((Object)InstanceStatus.ERROR)) {
                        throw new ContextMachineException(String.format("Job[%s], Context[%s], Child Context[%s] was in a State[%s] when attempting to raise events dues to a failure resubmission. The job must be in ERROR to resubmit due to failure.", schedulerJobInstance.getIdentifier(), schedulerJobInstance.getContextName(), schedulerJobInstance.getChildContextName(), schedulerJobInstance.getStatus().name()));
                    }
                    schedulerJobInstance.setStatus(InstanceStatus.COMPLETE);
                }
            } else {
                if (scheduledProcessEvent.isJobStarting()) {
                    if (schedulerJobInstance.isSkip()) {
                        schedulerJobInstance.setStatus(InstanceStatus.SKIPPED_RUNNING);
                    } else {
                        schedulerJobInstance.setStatus(InstanceStatus.RUNNING);
                    }
                } else if (scheduledProcessEvent.isSuccessful()) {
                    if (schedulerJobInstance.isSkip() || scheduledProcessEvent.getOutcome() != null && scheduledProcessEvent.getOutcome().equals(Outcome.EXECUTION_INVOKED_IGNORED_DAY_OF_WEEK.name())) {
                        schedulerJobInstance.setStatus(InstanceStatus.SKIPPED_COMPLETE);
                    } else {
                        schedulerJobInstance.setStatus(InstanceStatus.COMPLETE);
                    }
                } else {
                    schedulerJobInstance.setStatus(InstanceStatus.ERROR);
                }
                this.issueSchedulerJobStateChangeEvent(new SchedulerJobInstanceStateChangeEventImpl(schedulerJobInstance, parentContextInstance, currentJobState, schedulerJobInstance.getStatus()));
            }
        }
        List<SchedulerJobInitiationEvent> schedulerJobInitiationEvents = new ArrayList<SchedulerJobInitiationEvent>();
        this.getScheduledJobInitiationEventsThatCanBeRaised(scheduledProcessEvent, contextInstance, dryRunParameters, globalEventJobInstanceMap, internalEventDrivenJobs, contextParameters, parentContextInstance, schedulerJobInitiationEvents, markAsRaised);
        if (markAsRaised) {
            schedulerJobInitiationEvents = this.manageJobLocks(scheduledProcessEvent, contextInstance, parentContextInstance, schedulerJobInitiationEvents, lockRaised);
        }
        if (scheduledProcessEvent.isRaisedDueToFailureResubmission()) {
            schedulerJobInstance.setStatus(InstanceStatus.ERROR);
        }
        return schedulerJobInitiationEvents;
    }

    private void getScheduledJobInitiationEventsThatCanBeRaised(ContextualisedScheduledProcessEvent scheduledProcessEvent, ContextInstance contextInstance, DryRunParameters dryRunParameters, Map<String, GlobalEventJobInstance> globalEventJobInstanceMap, Map<String, InternalEventDrivenJobInstance> internalEventDrivenJobs, List<ContextParameterInstance> contextParameters, ContextInstance parentContextInstance, List<SchedulerJobInitiationEvent> schedulerJobInitiationEvents, boolean markAsRaised) {
        if (contextInstance.getJobDependencies() != null) {
            for (JobDependency jobDependency : contextInstance.getJobDependencies()) {
                SchedulerJobInitiationEvent event;
                String jobIdentifier = scheduledProcessEvent.getAgentName() + "-" + scheduledProcessEvent.getJobName();
                if (!this.shouldRaiseEvent(jobDependency.getLogicalGrouping(), contextInstance.getScheduledJobsMap(), jobIdentifier) || !this.jobIdentifierIsInLogicalGrouping(jobDependency.getLogicalGrouping(), jobIdentifier)) continue;
                SchedulerJobInstance jobInstance = (SchedulerJobInstance)contextInstance.getScheduledJobsMap().get(jobDependency.getJobIdentifier());
                if (jobInstance == null) {
                    this.logger.info("Encountered job dependency[{}] but no scheduled job in job map!", (Object)jobDependency.getJobIdentifier());
                    continue;
                }
                InternalEventDrivenJobInstance internalEventDrivenJob = internalEventDrivenJobs.get(jobDependency.getJobIdentifier() + "-" + contextInstance.getName());
                GlobalEventJobInstance globalEventJobInstance = globalEventJobInstanceMap.get(jobDependency.getJobIdentifier() + "-" + contextInstance.getName());
                if (!jobInstance.isInitiationEventRaised() && globalEventJobInstance != null) {
                    if (markAsRaised) {
                        jobInstance.setInitiationEventRaised(true);
                    }
                    if ((event = this.createGlobalSchedulerJobInitiationEvent(jobInstance, globalEventJobInstance, dryRunParameters, parentContextInstance, contextInstance, (ScheduledProcessEvent)scheduledProcessEvent)) == null) continue;
                    schedulerJobInitiationEvents.add(event);
                    continue;
                }
                if ((jobInstance.isInitiationEventRaised() || jobInstance.getStatus().equals((Object)InstanceStatus.COMPLETE) || jobInstance.getStatus().equals((Object)InstanceStatus.ERROR)) && (internalEventDrivenJob == null || !internalEventDrivenJob.isJobRepeatable() || internalEventDrivenJob.getJobName().equals(scheduledProcessEvent.getJobName()))) continue;
                if (markAsRaised) {
                    jobInstance.setInitiationEventRaised(true);
                }
                if ((event = this.createSchedulerJobInitiationEvent(jobInstance, internalEventDrivenJob, dryRunParameters, contextParameters, parentContextInstance, scheduledProcessEvent, contextInstance)) == null) continue;
                schedulerJobInitiationEvents.add(event);
            }
        }
    }

    private List<SchedulerJobInitiationEvent> manageJobLocks(ContextualisedScheduledProcessEvent scheduledProcessEvent, ContextInstance contextInstance, ContextInstance parentContextInstance, List<SchedulerJobInitiationEvent> schedulerJobInitiationEvents, MutableBoolean lockRaised) {
        ArrayList<SchedulerJobInitiationEvent> finalSchedulerJobInitiationEvents = new ArrayList<SchedulerJobInitiationEvent>();
        String jobIdentifier = scheduledProcessEvent.getAgentName() + "-" + scheduledProcessEvent.getJobName();
        if (!lockRaised.booleanValue() && scheduledProcessEvent.getInternalEventDrivenJob() != null && !scheduledProcessEvent.isJobStarting() && this.jobLockCache.hasLock(jobIdentifier, contextInstance.getName())) {
            lockRaised.setTrue();
            this.logger.info("Release {}", (Object)scheduledProcessEvent.getInternalEventDrivenJob());
            this.jobLockCache.release(jobIdentifier, contextInstance.getName());
            List queuedEvents = this.jobLockCache.pollSchedulerJobInitiationEventWaitQueue(jobIdentifier, contextInstance.getName());
            if (queuedEvents != null) {
                queuedEvents.forEach(contextualisedSchedulerJobInitiationEvent -> {
                    this.jobLockCache.lock(contextualisedSchedulerJobInitiationEvent.getSchedulerJobInitiationEvent().getInternalEventDrivenJob().getIdentifier(), contextualisedSchedulerJobInitiationEvent.getContextName());
                    finalSchedulerJobInitiationEvents.add(contextualisedSchedulerJobInitiationEvent.getSchedulerJobInitiationEvent());
                });
            }
        }
        schedulerJobInitiationEvents.forEach(event -> {
            if (event.getInternalEventDrivenJob() != null && this.jobLockCache.doesJobParticipateInLock(event.getInternalEventDrivenJob().getIdentifier(), contextInstance.getName())) {
                this.logger.info("Job participates in lock {}", (Object)event.getInternalEventDrivenJob());
                if (this.jobLockCache.locked(event.getInternalEventDrivenJob().getIdentifier(), contextInstance.getName())) {
                    this.addQueuedSchedulerJobInitiationEvent(contextInstance, parentContextInstance, event.getInternalEventDrivenJob().getIdentifier(), (SchedulerJobInitiationEvent)event);
                } else {
                    this.jobLockCache.lock(event.getInternalEventDrivenJob().getIdentifier(), contextInstance.getName());
                    this.logger.info("Lock {}", (Object)event.getInternalEventDrivenJob());
                    finalSchedulerJobInitiationEvents.add((SchedulerJobInitiationEvent)event);
                }
            } else {
                finalSchedulerJobInitiationEvents.add((SchedulerJobInitiationEvent)event);
            }
        });
        return finalSchedulerJobInitiationEvents;
    }

    protected void addQueuedSchedulerJobInitiationEvent(ContextInstance contextInstance, ContextInstance parentContextInstance, String jobIdentifier, SchedulerJobInitiationEvent event) {
        this.logger.info("Locked {}", (Object)event.getInternalEventDrivenJob());
        this.jobLockCache.addQueuedSchedulerJobInitiationEvent(jobIdentifier, contextInstance.getName(), event);
        InternalEventDrivenJobInstance schedulerJobInstance = event.getInternalEventDrivenJob();
        InstanceStatus currentJobState = schedulerJobInstance.getStatus();
        schedulerJobInstance.setStatus(InstanceStatus.LOCK_QUEUED);
        ((SchedulerJobInstance)contextInstance.getScheduledJobsMap().get(jobIdentifier)).setStatus(InstanceStatus.LOCK_QUEUED);
        this.issueSchedulerJobStateChangeEvent(new SchedulerJobInstanceStateChangeEventImpl((SchedulerJobInstance)schedulerJobInstance, parentContextInstance, currentJobState, schedulerJobInstance.getStatus()));
    }

    public void addSchedulerJobStateChangeEventListener(SchedulerJobInstanceStateChangeEventListener listener) {
        if (!this.schedulerJobInstanceStateChangeEventListeners.contains(listener)) {
            this.schedulerJobInstanceStateChangeEventListeners.add(listener);
        }
    }

    public void removeSchedulerJobStateChangeEventListener(SchedulerJobInstanceStateChangeEventListener listener) {
        if (this.schedulerJobInstanceStateChangeEventListeners.contains(listener)) {
            this.schedulerJobInstanceStateChangeEventListeners.remove(listener);
        }
    }

    protected void issueSchedulerJobStateChangeEvent(SchedulerJobInstanceStateChangeEventImpl event) {
        this.executor.submit(() -> this.schedulerJobInstanceStateChangeEventListeners.forEach(listener -> listener.onSchedulerJobInstanceStateChangeEvent((SchedulerJobInstanceStateChangeEvent)event)));
    }

    private SchedulerJobInitiationEvent createSchedulerJobInitiationEvent(SchedulerJobInstance schedulerJobInstance, InternalEventDrivenJobInstance internalEventDrivenJob, DryRunParameters dryRunParameters, List<ContextParameterInstance> contextParameters, ContextInstance parentContextInstance, ContextualisedScheduledProcessEvent scheduledProcessEvent, ContextInstance contextInstance) {
        SchedulerJobInitiationEventImpl schedulerJobInitiationEvent = new SchedulerJobInitiationEventImpl();
        schedulerJobInitiationEvent.setAgentName(schedulerJobInstance.getAgentName());
        schedulerJobInitiationEvent.setJobName(schedulerJobInstance.getJobName());
        schedulerJobInitiationEvent.setContextName(parentContextInstance.getName());
        schedulerJobInitiationEvent.setContextInstanceId(parentContextInstance.getId());
        schedulerJobInitiationEvent.setDryRun(dryRunParameters != null);
        schedulerJobInitiationEvent.setDryRunParameters(dryRunParameters);
        schedulerJobInitiationEvent.setCatalystEvent((ScheduledProcessEvent)scheduledProcessEvent);
        if (schedulerJobInstance.isSkip()) {
            schedulerJobInitiationEvent.setSkipped(true);
            internalEventDrivenJob.setSkip(true);
        }
        if (contextParameters != null && internalEventDrivenJob != null && internalEventDrivenJob.getContextParameters() != null) {
            schedulerJobInitiationEvent.setContextParameters(internalEventDrivenJob.getContextParameters().stream().map(contextParameter -> {
                AtomicReference instance = new AtomicReference();
                contextParameters.forEach(contextParameterInstance -> {
                    if (contextParameter.getName().equals(contextParameterInstance.getName())) {
                        instance.set(contextParameterInstance);
                    }
                });
                if (instance.get() != null) {
                    return this.replaceParamIfNotSet(parentContextInstance.getName(), (ContextParameterInstance)instance.get());
                }
                ContextParameterInstanceImpl defaultInstance = new ContextParameterInstanceImpl();
                defaultInstance.setName(contextParameter.getName());
                defaultInstance.setValue(contextParameter.getDefaultValue());
                defaultInstance.setDefaultValue(contextParameter.getDefaultValue());
                return defaultInstance;
            }).collect(Collectors.toList()));
        } else if ((contextParameters == null || contextParameters.isEmpty()) && internalEventDrivenJob != null && internalEventDrivenJob.getContextParameters() != null) {
            schedulerJobInitiationEvent.setContextParameters(internalEventDrivenJob.getContextParameters().stream().map(contextParameter -> {
                ContextParameterInstanceImpl contextParameterInstance = new ContextParameterInstanceImpl();
                contextParameterInstance.setName(contextParameter.getName());
                contextParameterInstance.setValue(contextParameter.getDefaultValue());
                contextParameterInstance.setDefaultValue(contextParameter.getDefaultValue());
                return contextParameterInstance;
            }).collect(Collectors.toList()));
        }
        schedulerJobInitiationEvent.setInternalEventDrivenJob(internalEventDrivenJob);
        if (internalEventDrivenJob.isTargetResidingContextOnly() && !internalEventDrivenJob.isJobRepeatable()) {
            if (this.isAlreadyComplete(parentContextInstance, schedulerJobInstance.getAgentName(), schedulerJobInstance.getJobName(), scheduledProcessEvent.getChildContextNames())) {
                schedulerJobInitiationEvent.setChildContextNames(List.of(contextInstance.getName()));
            } else {
                schedulerJobInitiationEvent.setChildContextNames(scheduledProcessEvent.getChildContextNames());
            }
        } else {
            schedulerJobInitiationEvent.setChildContextNames(internalEventDrivenJob.getChildContextNames());
        }
        if (this.agents.containsKey(schedulerJobInstance.getAgentName())) {
            schedulerJobInitiationEvent.setAgentUrl(this.agents.get(schedulerJobInstance.getAgentName()).getUrl());
        }
        return schedulerJobInitiationEvent;
    }

    private SchedulerJobInitiationEvent createGlobalSchedulerJobInitiationEvent(SchedulerJobInstance schedulerJobInstance, GlobalEventJobInstance globalEventJobInstance, DryRunParameters dryRunParameters, ContextInstance parentContextInstance, ContextInstance contextInstance, ScheduledProcessEvent scheduledProcessEvent) {
        SchedulerJobInitiationEventImpl schedulerJobInitiationEvent = new SchedulerJobInitiationEventImpl();
        schedulerJobInitiationEvent.setAgentName(schedulerJobInstance.getAgentName());
        schedulerJobInitiationEvent.setJobName(schedulerJobInstance.getJobName());
        schedulerJobInitiationEvent.setContextName(parentContextInstance.getName());
        schedulerJobInitiationEvent.setContextInstanceId(parentContextInstance.getId());
        schedulerJobInitiationEvent.setDryRun(dryRunParameters != null);
        schedulerJobInitiationEvent.setDryRunParameters(dryRunParameters);
        schedulerJobInitiationEvent.setCatalystEvent(scheduledProcessEvent);
        if (schedulerJobInstance.isSkip()) {
            schedulerJobInitiationEvent.setSkipped(true);
            globalEventJobInstance.setSkip(true);
        }
        schedulerJobInitiationEvent.setChildContextNames(globalEventJobInstance.getChildContextNames());
        if (this.agents.containsKey(schedulerJobInstance.getAgentName())) {
            schedulerJobInitiationEvent.setAgentUrl(this.agents.get(schedulerJobInstance.getAgentName()).getUrl());
        }
        return schedulerJobInitiationEvent;
    }

    private ContextParameterInstance replaceParamIfNotSet(String contextName, ContextParameterInstance instance) {
        String replacementForContextParamName;
        if ((instance.getValue() == null || instance.getValue().isEmpty()) && (replacementForContextParamName = this.contextParametersInstanceService.getContextParameterValue(contextName, instance.getName())) != null) {
            instance.setValue(replacementForContextParamName);
        }
        return instance;
    }

    private boolean shouldRaiseEvent(LogicalGrouping logicalGrouping, Map<String, SchedulerJobInstance> schedulerJobInstancesMap, String jobIdentifier) {
        boolean result = true;
        if (logicalGrouping == null) {
            return false;
        }
        if (logicalGrouping.getLogicalGrouping() != null) {
            result = this.shouldRaiseEvent(logicalGrouping.getLogicalGrouping(), schedulerJobInstancesMap, jobIdentifier);
        }
        return result && this.assessBaseLogic(logicalGrouping, schedulerJobInstancesMap);
    }

    private boolean isAlreadyComplete(ContextInstance contextInstance, String agentName, String jobName, List<String> childContextIds) {
        SchedulerJobInstance schedulerJob;
        if (contextInstance.getScheduledJobsMap() != null && !contextInstance.getScheduledJobsMap().isEmpty() && (schedulerJob = (SchedulerJobInstance)contextInstance.getScheduledJobsMap().get(agentName + "-" + jobName)) != null && (schedulerJob.getStatus().equals((Object)InstanceStatus.COMPLETE) || schedulerJob.getStatus().equals((Object)InstanceStatus.ERROR)) && ((ContextualisedScheduledProcessEvent)schedulerJob.getScheduledProcessEvent()).getChildContextNames().equals(childContextIds)) {
            return true;
        }
        AtomicReference<Boolean> contextId = new AtomicReference<Boolean>(false);
        if (contextInstance.getContexts() != null && !contextInstance.getContexts().isEmpty()) {
            contextInstance.getContexts().forEach(c -> {
                if (this.isAlreadyComplete((ContextInstance)c, agentName, jobName, childContextIds)) {
                    contextId.set(true);
                }
            });
        }
        return contextId.get();
    }

    ExecutorService getExecutor() {
        return this.executor;
    }
}

