/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.job.orchestration.integration.inbound.component;

import javax.annotation.Resource;
import org.ikasan.bigqueue.IBigQueue;
import org.ikasan.builder.BuilderFactory;
import org.ikasan.component.endpoint.bigqueue.serialiser.SimpleStringSerialiser;
import org.ikasan.job.orchestration.integration.inbound.component.endpoint.ScheduleProcessInboundProducer;
import org.ikasan.job.orchestration.integration.inbound.component.endpoint.configuration.ScheduleProcessInboundProducerConfiguration;
import org.ikasan.spec.component.endpoint.Consumer;
import org.ikasan.spec.component.endpoint.Producer;
import org.ikasan.spec.error.reporting.ErrorReportingService;
import org.ikasan.spec.metadata.ModuleMetaDataService;
import org.ikasan.spec.scheduled.instance.service.ContextInstancePublicationService;
import org.ikasan.spec.scheduled.instance.service.ScheduledContextInstanceService;
import org.ikasan.spec.serialiser.Serialiser;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.transaction.jta.JtaTransactionManager;

@Configuration
@ConditionalOnProperty(value={"is.ikasan.enterprise.scheduler.instance"}, havingValue="true")
public class ScheduledProcessEventInboundFlowComponentFactory {
    @Value(value="${module.name}")
    private String moduleName;
    @Resource
    private IBigQueue inboundQueue;
    @Value(value="${scheduler.inbound.producer.ignore.errors:false}")
    private boolean schedulerInboundProducerIgnoreErrors;
    @Value(value="${scheduler.inbound.producer.log.details:false}")
    private boolean schedulerInboundProducerLogDetails;
    @Resource
    BuilderFactory builderFactory;
    @Resource
    JtaTransactionManager transactionManager;
    @Resource
    ErrorReportingService errorReportingService;
    @Resource
    ScheduledContextInstanceService scheduledContextInstanceService;
    @Resource
    ContextInstancePublicationService contextInstancePublicationService;
    @Resource
    ModuleMetaDataService moduleMetadataService;

    @DependsOn(value={"inboundQueue"})
    public Consumer getInboundBigQueueConsumer() {
        return (Consumer)this.builderFactory.getComponentBuilder().bigQueueConsumer().setInboundQueue(this.inboundQueue).setPutErrorsToBackOfQueue(true).setSerialiser((Serialiser)new SimpleStringSerialiser()).build();
    }

    public Producer getScheduledStatusProducer() {
        ScheduleProcessInboundProducerConfiguration configuration = new ScheduleProcessInboundProducerConfiguration();
        configuration.setIgnoreErrors(this.schedulerInboundProducerIgnoreErrors);
        configuration.setLogDetails(this.schedulerInboundProducerLogDetails);
        ScheduleProcessInboundProducer producer = new ScheduleProcessInboundProducer(this.transactionManager.getTransactionManager(), this.scheduledContextInstanceService, this.contextInstancePublicationService, this.moduleMetadataService);
        producer.setConfiguration(configuration);
        producer.setConfiguredResourceId("scheduleProcessInboundProducer");
        producer.setErrorReportingService(this.errorReportingService);
        return producer;
    }
}

