/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.job.orchestration.integration.inbound.component.endpoint;

import com.arjuna.ats.jta.resources.LastResourceCommitOptimisation;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.ikasan.component.endpoint.bigqueue.message.BigQueueMessageImpl;
import org.ikasan.job.orchestration.context.cache.ContextMachineCache;
import org.ikasan.job.orchestration.core.machine.ContextMachine;
import org.ikasan.job.orchestration.integration.inbound.component.endpoint.ScheduledProcessProducerConnectionCallback;
import org.ikasan.job.orchestration.integration.inbound.component.endpoint.ScheduledProcessProducerConnectionCallbackImpl;
import org.ikasan.job.orchestration.integration.inbound.component.endpoint.configuration.ScheduleProcessInboundProducerConfiguration;
import org.ikasan.job.orchestration.integration.inbound.exception.InvalidContextInstanceIdException;
import org.ikasan.job.orchestration.model.event.ContextualisedScheduledProcessEventImpl;
import org.ikasan.job.orchestration.util.ContextHelper;
import org.ikasan.job.orchestration.util.ObjectMapperFactory;
import org.ikasan.scheduled.instance.model.SolrContextInstanceSearchFilterImpl;
import org.ikasan.spec.bigqueue.message.BigQueueMessage;
import org.ikasan.spec.component.endpoint.EndpointException;
import org.ikasan.spec.component.endpoint.Producer;
import org.ikasan.spec.configuration.ConfigurationException;
import org.ikasan.spec.configuration.ConfiguredResource;
import org.ikasan.spec.error.reporting.ErrorReportingService;
import org.ikasan.spec.error.reporting.IsErrorReportingServiceAware;
import org.ikasan.spec.metadata.ModuleMetaData;
import org.ikasan.spec.metadata.ModuleMetaDataService;
import org.ikasan.spec.metadata.ModuleMetadataSearchResults;
import org.ikasan.spec.module.ModuleType;
import org.ikasan.spec.scheduled.context.model.Context;
import org.ikasan.spec.scheduled.event.model.ContextualisedScheduledProcessEvent;
import org.ikasan.spec.scheduled.instance.model.ContextInstance;
import org.ikasan.spec.scheduled.instance.model.ContextInstanceSearchFilter;
import org.ikasan.spec.scheduled.instance.model.InstanceStatus;
import org.ikasan.spec.scheduled.instance.model.ScheduledContextInstanceRecord;
import org.ikasan.spec.scheduled.instance.service.ContextInstancePublicationService;
import org.ikasan.spec.scheduled.instance.service.ScheduledContextInstanceService;
import org.ikasan.spec.search.SearchResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduleProcessInboundProducer
implements Producer<String>,
ConfiguredResource<ScheduleProcessInboundProducerConfiguration>,
LastResourceCommitOptimisation,
IsErrorReportingServiceAware {
    private static final String FLOW_NAME = "Scheduled Process Event Inbound Flow";
    private Logger logger = LoggerFactory.getLogger(ScheduleProcessInboundProducer.class);
    private ObjectMapper objectMapper = ObjectMapperFactory.newInstance();
    private ScheduleProcessInboundProducerConfiguration configuration;
    private String configurationId;
    private ScheduledProcessProducerConnectionCallback scheduledProcessProducerConnectionCallback;
    private TransactionManager transactionManager;
    private ErrorReportingService errorReportingService;
    private ScheduledContextInstanceService scheduledContextInstanceService;
    private ContextInstancePublicationService contextInstancePublicationService;
    private ModuleMetaDataService moduleMetadataService;

    public ScheduleProcessInboundProducer(TransactionManager transactionManager, ScheduledContextInstanceService scheduledContextInstanceService, ContextInstancePublicationService contextInstancePublicationService, ModuleMetaDataService moduleMetadataService) {
        this.transactionManager = transactionManager;
        this.scheduledContextInstanceService = scheduledContextInstanceService;
        this.contextInstancePublicationService = contextInstancePublicationService;
        this.moduleMetadataService = moduleMetadataService;
    }

    public void invoke(String payload) throws EndpointException {
        try {
            this.enlist();
            BigQueueMessage bigQueueMessage = (BigQueueMessage)this.objectMapper.readValue(payload, BigQueueMessageImpl.class);
            String message = (String)bigQueueMessage.getMessage();
            ContextualisedScheduledProcessEvent contextualisedScheduledProcessEvent = (ContextualisedScheduledProcessEvent)this.objectMapper.readValue(message, ContextualisedScheduledProcessEventImpl.class);
            if (contextualisedScheduledProcessEvent.getContextInstanceId() == null) {
                String errorMessage = String.format("Received scheduler event with null context instance id [%s]. Cache Contents - %s", contextualisedScheduledProcessEvent, ContextMachineCache.instance().toString());
                this.logger.warn(errorMessage);
                this.errorReportingService.notify(FLOW_NAME, (Object)payload, (Throwable)new InvalidContextInstanceIdException(errorMessage));
                this.scheduledProcessProducerConnectionCallback = new ScheduledProcessProducerConnectionCallbackImpl(payload, null);
                return;
            }
            ContextMachine contextMachine = ContextMachineCache.instance().getByContextInstanceId(contextualisedScheduledProcessEvent.getContextInstanceId());
            if (contextMachine == null) {
                if (contextualisedScheduledProcessEvent.getContextName() != null) {
                    SolrContextInstanceSearchFilterImpl filter = new SolrContextInstanceSearchFilterImpl();
                    filter.setContextInstanceNames(Collections.singletonList(contextualisedScheduledProcessEvent.getContextName()));
                    filter.setContextInstanceId(contextualisedScheduledProcessEvent.getContextInstanceId());
                    SearchResults contextInstanceRecords = this.scheduledContextInstanceService.getScheduledContextInstancesByFilter((ContextInstanceSearchFilter)filter, -1, -1, null, null);
                    for (ScheduledContextInstanceRecord scheduledContextInstanceRecord : contextInstanceRecords.getResultList()) {
                        if ((!scheduledContextInstanceRecord.getContextName().equals(contextualisedScheduledProcessEvent.getContextName()) || !scheduledContextInstanceRecord.getContextInstanceId().equals(contextualisedScheduledProcessEvent.getContextInstanceId()) || !scheduledContextInstanceRecord.getContextInstance().getStatus().equals((Object)InstanceStatus.ENDED)) && !scheduledContextInstanceRecord.getContextInstance().getStatus().equals((Object)InstanceStatus.COMPLETE)) continue;
                        String errorMessage = String.format("Context name[%s] and context instance id [%s] has the status of [%s], therefore this event will be discarded. No further action is required. ", contextualisedScheduledProcessEvent.getContextName(), contextualisedScheduledProcessEvent.getContextInstanceId(), scheduledContextInstanceRecord.getContextInstance().getStatus());
                        this.removeAgentInstances(scheduledContextInstanceRecord.getContextInstance());
                        this.logger.warn(errorMessage);
                        if (this.errorReportingService != null) {
                            this.errorReportingService.notify(FLOW_NAME, (Object)payload, (Throwable)new InvalidContextInstanceIdException(errorMessage));
                        }
                        this.scheduledProcessProducerConnectionCallback = new ScheduledProcessProducerConnectionCallbackImpl(payload, null);
                        return;
                    }
                }
                throw new InvalidContextInstanceIdException(String.format("Could not resolve context machine with context name[%s] and context instance id [%s]. Does not exist in the system!  Cache Contents - %s", contextualisedScheduledProcessEvent.getContextName(), contextualisedScheduledProcessEvent.getContextInstanceId(), ContextMachineCache.instance().toString()));
            }
            if (this.configuration.isLogDetails()) {
                this.logger.info(String.format("Received contextualisedScheduledProcessEvent with context instance id[%s]. Processing that against context instance name[%s], with id[%s]", contextualisedScheduledProcessEvent.getContextInstanceId(), contextMachine.getContext().getName(), contextMachine.getContext().getId()));
                if (!contextualisedScheduledProcessEvent.getContextInstanceId().equals(contextMachine.getContext().getId())) {
                    this.logger.warn(String.format("contextualisedScheduledProcessEvent context instance id[%s] does not machine context machine instance id[%s] for context[%s]", contextualisedScheduledProcessEvent.getContextInstanceId(), contextMachine.getContext().getId(), contextMachine.getContext().getName()));
                }
            }
            if (contextMachine.getContext() != null && contextMachine.getContext().getStatus() != null && contextMachine.getContext().getStatus().equals((Object)InstanceStatus.PREPARED)) {
                String errorMessage = String.format("Context name[%s] and context instance id [%s] has the status of [%s], therefore this event will be discarded. No further action is required. ", contextualisedScheduledProcessEvent.getContextName(), contextualisedScheduledProcessEvent.getContextInstanceId(), contextMachine.getContext().getStatus());
                this.logger.warn(errorMessage);
                if (this.errorReportingService != null) {
                    this.errorReportingService.notify(FLOW_NAME, (Object)payload, (Throwable)new InvalidContextInstanceIdException(errorMessage));
                }
                this.scheduledProcessProducerConnectionCallback = new ScheduledProcessProducerConnectionCallbackImpl(payload, null);
                return;
            }
            this.scheduledProcessProducerConnectionCallback = new ScheduledProcessProducerConnectionCallbackImpl(payload, contextMachine);
        }
        catch (InvalidContextInstanceIdException | ConfigurationException e) {
            e.printStackTrace();
            if (this.configuration.isIgnoreErrors()) {
                this.logger.info("Ignoring error [{}] for payload [{}]", (Object)e.getMessage(), (Object)payload);
            }
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (this.configuration.isIgnoreErrors()) {
                this.logger.info("Ignoring error [{}] for payload [{}]", (Object)e.getMessage(), (Object)payload);
            }
            throw new EndpointException((Throwable)e);
        }
    }

    private void removeAgentInstances(ContextInstance instance) {
        HashMap<String, ModuleMetaData> agents = this.getAgents((Context)instance);
        if (!agents.keySet().isEmpty()) {
            for (String key : agents.keySet()) {
                ModuleMetaData agent = agents.get(key);
                this.contextInstancePublicationService.remove(agent.getUrl(), (Object)instance);
            }
        }
    }

    private HashMap<String, ModuleMetaData> getAgents(Context context) {
        HashMap<String, ModuleMetaData> agents = new HashMap<String, ModuleMetaData>();
        List contextAgents = ContextHelper.getAllAgents((Context)context);
        ModuleMetadataSearchResults searchResults = this.moduleMetadataService.find(contextAgents, ModuleType.SCHEDULER_AGENT, Integer.valueOf(-1), Integer.valueOf(-1));
        searchResults.getResultList().forEach(agent -> agents.put(agent.getName(), (ModuleMetaData)agent));
        return agents;
    }

    private void enlist() throws SystemException, RollbackException {
        if (this.transactionManager.getTransaction() != null) {
            if (this.transactionManager.getTransaction().getStatus() != 0) {
                return;
            }
            this.transactionManager.getTransaction().enlistResource((XAResource)((Object)this));
        }
    }

    public String getConfiguredResourceId() {
        return this.configurationId;
    }

    public void setConfiguredResourceId(String configurationId) {
        this.configurationId = configurationId;
    }

    public ScheduleProcessInboundProducerConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ScheduleProcessInboundProducerConfiguration scheduleProcessInboundProducerConfiguration) {
        this.configuration = scheduleProcessInboundProducerConfiguration;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.logger.debug("commit");
        try {
            this.scheduledProcessProducerConnectionCallback.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("Could not commit transaction! Exception!", (Throwable)e);
            throw new XAException(String.format("Could not commit transaction! Exception Class[%s], Message[%s], Payload", e, e.getMessage(), this.scheduledProcessProducerConnectionCallback.getPayload()));
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        this.logger.debug("end");
    }

    public void forget(Xid xid) throws XAException {
        this.logger.debug("forget");
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        return false;
    }

    public int prepare(Xid xid) throws XAException {
        return 0;
    }

    public Xid[] recover(int flag) throws XAException {
        return new Xid[0];
    }

    public void rollback(Xid xid) throws XAException {
        this.logger.debug("rollback");
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return false;
    }

    public void start(Xid xid, int flags) throws XAException {
        this.logger.debug("start");
    }

    public void setErrorReportingService(ErrorReportingService errorReportingService) {
        this.errorReportingService = errorReportingService;
    }
}

