/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.job.orchestration.integration.inbound.component.endpoint;

import java.io.IOException;
import org.ikasan.job.orchestration.context.cache.ContextMachineCache;
import org.ikasan.job.orchestration.core.machine.ContextMachine;
import org.ikasan.job.orchestration.integration.inbound.component.endpoint.ScheduledProcessProducerConnectionCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduledProcessProducerConnectionCallbackImpl
implements ScheduledProcessProducerConnectionCallback {
    private Logger logger = LoggerFactory.getLogger(ScheduledProcessProducerConnectionCallbackImpl.class);
    private String payload;
    private ContextMachine contextMachine;

    public ScheduledProcessProducerConnectionCallbackImpl(String payload, ContextMachine contextMachine) {
        this.payload = payload;
        this.contextMachine = contextMachine;
    }

    @Override
    public void execute() throws IOException {
        if (this.contextMachine != null && this.contextMachine.getContext() != null && ContextMachineCache.instance().containsInstanceIdentifier(this.contextMachine.getContext().getId())) {
            this.contextMachine = ContextMachineCache.instance().getByContextInstanceId(this.contextMachine.getContext().getId());
            if (this.contextMachine != null) {
                this.contextMachine.eventReceived(this.payload);
            }
        } else {
            this.logger.info(String.format("Context machine not available in cache. Ignoring payload!. Payload[%s]", this.payload));
        }
    }

    @Override
    public String getPayload() {
        return this.payload;
    }
}

