/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.job.orchestration.integration.inbound.flow;

import java.io.IOException;
import javax.annotation.Resource;
import org.ikasan.builder.BuilderFactory;
import org.ikasan.job.orchestration.integration.inbound.component.ScheduledProcessEventInboundFlowComponentFactory;
import org.ikasan.spec.flow.Flow;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"is.ikasan.enterprise.scheduler.instance"}, havingValue="true")
public class ScheduledProcessEventInboundFlowFactory {
    @Value(value="${module.name}")
    String moduleName;
    @Resource
    BuilderFactory builderFactory;
    @Resource
    ScheduledProcessEventInboundFlowComponentFactory scheduledProcessEventInboundFlowComponentFactory;
    @Value(value="${scheduler.inbound.flow.error.occurrence.ttl.milliseconds:604800000}")
    Long errorReportingServiceTimeToLive;

    @Bean
    public Flow scheduledProcessEventInboundFlow() throws IOException {
        return (Flow)this.builderFactory.getModuleBuilder(this.moduleName).getFlowBuilder("Scheduled Process Event Inbound Flow").withDescription("Scheduled Process Event Inbound Flow").withErrorReportingServiceTimeToLive(this.errorReportingServiceTimeToLive).consumer("Scheduled Consumer", this.scheduledProcessEventInboundFlowComponentFactory.getInboundBigQueueConsumer()).producer("Dashboard Producer", this.scheduledProcessEventInboundFlowComponentFactory.getScheduledStatusProducer()).build();
    }
}

