/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.module.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ikasan.module.ConfiguredModuleConfiguration;
import org.ikasan.module.FlowFactoryCapable;
import org.ikasan.module.startup.StartupControlImpl;
import org.ikasan.module.startup.dao.StartupControlDao;
import org.ikasan.spec.configuration.ConfigurationService;
import org.ikasan.spec.configuration.ConfiguredResource;
import org.ikasan.spec.dashboard.DashboardRestService;
import org.ikasan.spec.flow.Flow;
import org.ikasan.spec.module.Module;
import org.ikasan.spec.module.ModuleActivator;
import org.ikasan.spec.module.StartupControl;
import org.ikasan.spec.module.StartupType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleActivatorDefaultImpl
implements ModuleActivator<Flow> {
    private static final Logger logger = LoggerFactory.getLogger(ModuleActivatorDefaultImpl.class);
    private ConfigurationService configurationService;
    private DashboardRestService moduleMetadataDashboardRestService;
    private DashboardRestService configurationMetadataDashboardRestService;
    private StartupControlDao startupControlDao;
    private List<Module> activatedModuleNames = new ArrayList<Module>();

    public ModuleActivatorDefaultImpl(ConfigurationService configurationService, StartupControlDao startupControlDao) {
        this.configurationService = configurationService;
        if (configurationService == null) {
            throw new IllegalArgumentException("configurationService cannot be 'null'");
        }
        this.startupControlDao = startupControlDao;
        if (startupControlDao == null) {
            throw new IllegalArgumentException("startupControlDao cannot be 'null'");
        }
    }

    public void activate(Module<Flow> module) {
        if (module instanceof ConfiguredResource) {
            ConfiguredResource configuredModule = (ConfiguredResource)module;
            this.configurationService.configure((Object)configuredModule);
            if (module instanceof FlowFactoryCapable) {
                ConfiguredModuleConfiguration configuration = (ConfiguredModuleConfiguration)configuredModule.getConfiguration();
                module.getFlows().clear();
                if (configuration.getFlowDefinitions() != null) {
                    for (Map.Entry flowDefinition : configuration.getFlowDefinitions().entrySet()) {
                        String flowname = (String)flowDefinition.getKey();
                        String profile = (String)configuration.getFlowDefinitionProfiles().get(flowname);
                        ((FlowFactoryCapable)module).getFlowFactory().create(flowname, profile).forEach(flow -> {
                            StartupControlImpl startupControl = new StartupControlImpl(module.getName(), flow.getName());
                            startupControl.setStartupType(StartupType.valueOf((String)((String)flowDefinition.getValue())));
                            this.startupControlDao.save((StartupControl)startupControl);
                            module.getFlows().add(flow);
                        });
                    }
                }
            }
        }
        for (Flow flow2 : module.getFlows()) {
            StartupControl flowStartupControl = this.startupControlDao.getStartupControl(module.getName(), flow2.getName());
            if (StartupType.AUTOMATIC.equals((Object)flowStartupControl.getStartupType())) {
                try {
                    flow2.start();
                }
                catch (RuntimeException e) {
                    logger.warn("Module [" + module.getName() + "] Flow [" + flow2.getName() + "] failed to start!", (Throwable)e);
                }
                continue;
            }
            logger.info("Module [" + module.getName() + "] Flow [" + flow2.getName() + "] startup is set to [" + flowStartupControl.getStartupType().name() + "]. Not automatically started!");
        }
        this.activatedModuleNames.add(module);
    }

    public void deactivate(Module<Flow> module) {
        for (Flow flow : module.getFlows()) {
            flow.stop();
        }
        if (module instanceof ConfiguredResource) {
            ConfiguredModuleConfiguration configuration;
            ConfiguredResource configuredModule = (ConfiguredResource)module;
            if (module instanceof FlowFactoryCapable && (configuration = (ConfiguredModuleConfiguration)configuredModule.getConfiguration()).getFlowDefinitions() != null) {
                for (Map.Entry flowDefinition : configuration.getFlowDefinitions().entrySet()) {
                    module.getFlows().remove(flowDefinition.getKey());
                }
            }
        }
        this.activatedModuleNames.remove(module);
    }

    public boolean isActivated(Module<Flow> module) {
        return this.activatedModuleNames.contains(module);
    }
}

