/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.ootb.scheduler.agent.rest.client.context;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.HashMap;
import java.util.Map;
import org.ikasan.dashboard.AbstractRestServiceImpl;
import org.ikasan.ootb.scheduler.agent.rest.converters.ObjectMapperFactory;
import org.ikasan.spec.component.endpoint.EndpointException;
import org.ikasan.spec.dashboard.ContextInstanceRestService;
import org.ikasan.spec.scheduled.instance.model.ContextInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class ContextInstanceRestServiceImpl
extends AbstractRestServiceImpl
implements ContextInstanceRestService<ContextInstance> {
    Logger logger = LoggerFactory.getLogger(ContextInstanceRestServiceImpl.class);
    private final String moduleName;
    private final ObjectMapper mapper;

    public ContextInstanceRestServiceImpl(Environment environment, HttpComponentsClientHttpRequestFactory httpComponentsClientHttpRequestFactory, String path) {
        this.restTemplate = new RestTemplate((ClientHttpRequestFactory)httpComponentsClientHttpRequestFactory);
        MappingJackson2HttpMessageConverter jsonHttpMessageConverter = new MappingJackson2HttpMessageConverter();
        jsonHttpMessageConverter.getObjectMapper().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        this.restTemplate.getMessageConverters().add(jsonHttpMessageConverter);
        this.url = environment.getProperty("ikasan.dashboard.extract.base.url") + path;
        this.authenticateUrl = environment.getProperty("ikasan.dashboard.extract.base.url") + "/authenticate";
        this.username = environment.getProperty("ikasan.dashboard.extract.username");
        this.password = environment.getProperty("ikasan.dashboard.extract.password");
        this.moduleName = environment.getProperty("module.name");
        this.mapper = ObjectMapperFactory.newInstance();
    }

    public Map<String, ContextInstance> getAllInstancesDashboardThinksAgentShouldHandle(final String agentName) {
        if (this.token == null) {
            this.authenticate(this.moduleName);
        }
        HttpHeaders headers = super.createHttpHeaders(this.moduleName);
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        try {
            String urlTemplate = UriComponentsBuilder.fromHttpUrl((String)(this.url + "/getByAgentName")).queryParam("agentName", new Object[]{"{agentName}"}).encode().toUriString();
            HashMap<String, String> parameters = new HashMap<String, String>(){
                {
                    this.put("agentName", agentName);
                }
            };
            ResponseEntity response = this.restTemplate.exchange(urlTemplate, HttpMethod.GET, entity, String.class, (Map)parameters);
            return (Map)this.mapper.readValue((String)response.getBody(), (TypeReference)new TypeReference<Map<String, ContextInstance>>(){});
        }
        catch (JsonProcessingException | RestClientException e) {
            String message = "Issue getting context instance for url [" + this.url + "]  with response [{" + e.getLocalizedMessage() + "}]";
            this.logger.error(message);
            throw new EndpointException(e);
        }
    }
}

