/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.security.dao;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.ikasan.security.dao.SecurityDao;
import org.ikasan.security.model.AuthenticationMethod;
import org.ikasan.security.model.IkasanPrincipal;
import org.ikasan.security.model.IkasanPrincipalLite;
import org.ikasan.security.model.Policy;
import org.ikasan.security.model.PolicyLink;
import org.ikasan.security.model.PolicyLinkType;
import org.ikasan.security.model.Role;
import org.ikasan.security.model.User;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

public class HibernateSecurityDao
extends HibernateDaoSupport
implements SecurityDao {
    @Override
    public void saveOrUpdateRole(Role role) {
        role.setUpdatedDateTime(new Date());
        this.getHibernateTemplate().saveOrUpdate((Object)role);
    }

    @Override
    public void saveOrUpdatePolicy(Policy policy) {
        policy.setUpdatedDateTime(new Date());
        this.getHibernateTemplate().saveOrUpdate((Object)policy);
    }

    @Override
    public void saveOrUpdatePrincipal(IkasanPrincipal principal) {
        principal.setUpdatedDateTime(new Date());
        this.getHibernateTemplate().saveOrUpdate((Object)principal);
    }

    @Override
    public IkasanPrincipal getPrincipalByName(String name) {
        return (IkasanPrincipal)this.getHibernateTemplate().execute(session -> {
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = builder.createQuery(IkasanPrincipal.class);
            Root root = criteriaQuery.from(IkasanPrincipal.class);
            criteriaQuery.select((Selection)root).where((Expression)builder.equal((Expression)root.get("name"), (Object)name));
            Query query = session.createQuery(criteriaQuery);
            List results = query.getResultList();
            if (results == null || results.size() == 0) {
                return null;
            }
            return (IkasanPrincipal)results.get(0);
        });
    }

    @Override
    public List<Policy> getAllPolicies() {
        return (List)this.getHibernateTemplate().execute(session -> {
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = builder.createQuery(Policy.class);
            Root root = criteriaQuery.from(Policy.class);
            criteriaQuery.select((Selection)root);
            Query query = session.createQuery(criteriaQuery);
            return query.getResultList();
        });
    }

    @Override
    public List<Role> getAllRoles() {
        return (List)this.getHibernateTemplate().execute(session -> {
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = builder.createQuery(Role.class);
            Root root = criteriaQuery.from(Role.class);
            criteriaQuery.select((Selection)root);
            Query query = session.createQuery(criteriaQuery);
            return query.getResultList();
        });
    }

    @Override
    public List<IkasanPrincipal> getAllPrincipals() {
        return (List)this.getHibernateTemplate().execute(session -> {
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = builder.createQuery(IkasanPrincipal.class);
            Root root = criteriaQuery.from(IkasanPrincipal.class);
            criteriaQuery.select((Selection)root);
            Query query = session.createQuery(criteriaQuery);
            return query.getResultList();
        });
    }

    @Override
    public List<IkasanPrincipalLite> getAllPrincipalLites() {
        return (List)this.getHibernateTemplate().execute(session -> {
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = builder.createQuery(IkasanPrincipalLite.class);
            Root root = criteriaQuery.from(IkasanPrincipalLite.class);
            criteriaQuery.select((Selection)root);
            Query query = session.createQuery(criteriaQuery);
            return query.getResultList();
        });
    }

    @Override
    public Policy getPolicyByName(String name) {
        return (Policy)this.getHibernateTemplate().execute(session -> {
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = builder.createQuery(Policy.class);
            Root root = criteriaQuery.from(Policy.class);
            criteriaQuery.select((Selection)root).where((Expression)builder.equal((Expression)root.get("name"), (Object)name));
            Query query = session.createQuery(criteriaQuery);
            List results = query.getResultList();
            if (results == null || results.size() == 0) {
                return null;
            }
            return (Policy)results.get(0);
        });
    }

    @Override
    public Role getRoleByName(String name) {
        return (Role)this.getHibernateTemplate().execute(session -> {
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = builder.createQuery(Role.class);
            Root root = criteriaQuery.from(Role.class);
            criteriaQuery.select((Selection)root).where((Expression)builder.equal((Expression)root.get("name"), (Object)name));
            Query query = session.createQuery(criteriaQuery);
            List results = query.getResultList();
            if (results == null || results.size() == 0) {
                return null;
            }
            return (Role)results.get(0);
        });
    }

    @Override
    public Role getRoleById(Long id) {
        Role role = (Role)this.getHibernateTemplate().get(Role.class, (Serializable)id);
        return role;
    }

    @Override
    public Policy getPolicyById(Long id) {
        Policy policy = (Policy)this.getHibernateTemplate().get(Policy.class, (Serializable)id);
        return policy;
    }

    @Override
    public void deleteRole(Role role) {
        this.getHibernateTemplate().delete((Object)role);
    }

    @Override
    public void deletePolicy(Policy policy) {
        this.getHibernateTemplate().delete((Object)policy);
    }

    @Override
    public void deletePrincipal(IkasanPrincipal principal) {
        this.getHibernateTemplate().delete((Object)principal);
    }

    @Override
    public void saveOrUpdateAuthenticationMethod(AuthenticationMethod authenticationMethod) {
        this.getHibernateTemplate().saveOrUpdate((Object)authenticationMethod);
    }

    @Override
    public AuthenticationMethod getAuthenticationMethod(Long id) {
        AuthenticationMethod authenticationMethod = (AuthenticationMethod)this.getHibernateTemplate().get(AuthenticationMethod.class, (Serializable)id);
        return authenticationMethod;
    }

    @Override
    public List<AuthenticationMethod> getAuthenticationMethods() {
        return (List)this.getHibernateTemplate().execute(session -> {
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = builder.createQuery(AuthenticationMethod.class);
            Root root = criteriaQuery.from(AuthenticationMethod.class);
            criteriaQuery.select((Selection)root).orderBy(new Order[]{builder.asc((Expression)root.get("order"))});
            Query query = session.createQuery(criteriaQuery);
            return query.getResultList();
        });
    }

    @Override
    public List<IkasanPrincipal> getAllPrincipalsWithRole(String roleName) {
        return (List)this.getHibernateTemplate().execute(session -> {
            Query query = session.createQuery("select p from IkasanPrincipal as p  LEFT JOIN p.roles r  where  r.name = :name");
            query.setParameter("name", (Object)roleName);
            return query.list();
        });
    }

    @Override
    public List<IkasanPrincipal> getPrincipalsByRoleNames(List<String> names) {
        return (List)this.getHibernateTemplate().execute(session -> {
            Query query = session.createQuery("select distinct(p) from IkasanPrincipal as p  LEFT JOIN p.roles r  where  r.name in (:name)");
            query.setParameter("name", (Object)names);
            return query.list();
        });
    }

    @Override
    public List<IkasanPrincipal> getPrincipalByNameLike(String name) {
        List results = this.getHibernateTemplate().findByNamedParam("from IkasanPrincipal where name LIKE :name", "name", (Object)(name + '%'));
        return results;
    }

    @Override
    public List<PolicyLinkType> getAllPolicyLinkTypes() {
        return (List)this.getHibernateTemplate().execute(session -> {
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = builder.createQuery(PolicyLinkType.class);
            Root root = criteriaQuery.from(PolicyLinkType.class);
            criteriaQuery.select((Selection)root);
            Query query = session.createQuery(criteriaQuery);
            return query.getResultList();
        });
    }

    @Override
    public List<Policy> getPolicyByNameLike(String name) {
        List results = this.getHibernateTemplate().findByNamedParam("from Policy where name LIKE :name", "name", (Object)(name + '%'));
        return results;
    }

    @Override
    public List<Role> getRoleByNameLike(String name) {
        List results = this.getHibernateTemplate().findByNamedParam("from Role where name LIKE :name", "name", (Object)(name + '%'));
        return results;
    }

    @Override
    public void saveOrUpdatePolicyLink(PolicyLink policyLink) {
        this.getHibernateTemplate().saveOrUpdate((Object)policyLink);
    }

    @Override
    public void saveOrUpdatePolicyLinkType(PolicyLinkType policyLinkType) {
        this.getHibernateTemplate().saveOrUpdate((Object)policyLinkType);
    }

    @Override
    public void deletePolicyLink(PolicyLink policyLink) {
        this.getHibernateTemplate().delete((Object)policyLink);
    }

    @Override
    public List<Policy> getAllPoliciesWithRole(String roleName) {
        return (List)this.getHibernateTemplate().execute(session -> {
            Query query = session.createQuery("select p from Policy as p  LEFT JOIN p.roles r  where  r.name = :name");
            query.setParameter("name", (Object)roleName);
            return query.list();
        });
    }

    @Override
    public void deleteAuthenticationMethod(AuthenticationMethod authenticationMethod) {
        this.getHibernateTemplate().delete((Object)authenticationMethod);
    }

    @Override
    public long getNumberOfAuthenticationMethods() {
        return (Long)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.createQuery("select count(*) from AuthenticationMethod");
                return (Long)query.uniqueResult();
            }
        });
    }

    @Override
    public AuthenticationMethod getAuthenticationMethodByOrder(long order) {
        return (AuthenticationMethod)this.getHibernateTemplate().execute(session -> {
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = builder.createQuery(AuthenticationMethod.class);
            Root root = criteriaQuery.from(AuthenticationMethod.class);
            criteriaQuery.select((Selection)root).where((Expression)builder.equal((Expression)root.get("order"), (Object)order));
            Query query = session.createQuery(criteriaQuery);
            List results = query.getResultList();
            if (results == null || results.size() == 0) {
                return null;
            }
            return (AuthenticationMethod)results.get(0);
        });
    }

    @Override
    public List<User> getUsersAssociatedWithPrincipal(long principalId) {
        return (List)this.getHibernateTemplate().execute(session -> {
            Query query = session.createQuery("select u from UserPrincipal as up, User as u  where  u.id = up.userId and up.ikasanPrincipalId = :principalId");
            query.setParameter("principalId", (Object)principalId);
            return query.list();
        });
    }
}

