/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.security.service;

import java.util.List;
import org.ikasan.security.model.AuthenticationMethod;
import org.ikasan.security.model.IkasanPrincipal;
import org.ikasan.security.model.IkasanPrincipalLite;
import org.ikasan.security.model.Policy;
import org.ikasan.security.model.PolicyLink;
import org.ikasan.security.model.PolicyLinkType;
import org.ikasan.security.model.Role;
import org.ikasan.security.model.User;

public interface SecurityService {
    public IkasanPrincipal findPrincipalByName(String var1);

    public Role findRoleByName(String var1);

    public Policy findPolicyByName(String var1);

    public IkasanPrincipal createNewPrincipal(String var1, String var2);

    public void savePrincipal(IkasanPrincipal var1);

    public List<IkasanPrincipal> getAllPrincipals();

    public List<IkasanPrincipalLite> getAllPrincipalLites();

    public List<IkasanPrincipal> getAllPrincipalsWithRole(String var1);

    public List<IkasanPrincipal> getPrincipalsByName(List<String> var1);

    public void deletePrincipal(IkasanPrincipal var1);

    public Role createNewRole(String var1, String var2);

    public void saveRole(Role var1);

    public void deleteRole(Role var1);

    public List<Role> getAllRoles();

    public Policy createNewPolicy(String var1, String var2);

    public void savePolicy(Policy var1);

    public void deletePolicy(Policy var1);

    public List<Policy> getAllPolicies();

    public void saveOrUpdateAuthenticationMethod(AuthenticationMethod var1);

    public List<AuthenticationMethod> getAuthenticationMethods();

    public AuthenticationMethod getAuthenticationMethod(Long var1);

    public void deleteAuthenticationMethod(AuthenticationMethod var1);

    public List<IkasanPrincipal> getPrincipalByNameLike(String var1);

    public List<PolicyLinkType> getAllPolicyLinkTypes();

    public List<Policy> getPolicyByNameLike(String var1);

    public void savePolicyLink(PolicyLink var1);

    public void deletePolicyLink(PolicyLink var1);

    public List<Policy> getAllPoliciesWithRole(String var1);

    public List<Role> getRoleByNameLike(String var1);

    public long getNumberOfAuthenticationMethods();

    public AuthenticationMethod getAuthenticationMethodByOrder(long var1);

    public List<User> getUsersAssociatedWithPrincipal(long var1);

    public Role getRoleById(Long var1);

    public Policy getPolicyById(Long var1);
}

