/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.security.service.authentication;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.ikasan.security.model.Policy;
import org.ikasan.security.model.PolicyLink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

public class IkasanAuthentication
implements Authentication {
    private static Logger logger = LoggerFactory.getLogger(IkasanAuthentication.class);
    public static final String MODULE = "Module";
    public static final String MAPPING_CONFIGURATION = "Mapping Configuration";
    public static final String FLOW = "Flow";
    public static final String BUSINESS_STREAM = "Business Stream";
    private boolean isAuthenticated;
    private List<GrantedAuthority> authorities;
    private Principal principal;
    private String credentials;
    private long previousLoginTimestamp;

    public IkasanAuthentication(boolean isAuthenticated, Principal principal, List<GrantedAuthority> authorities, String credentials, long previousLoginTimestamp) {
        this.isAuthenticated = isAuthenticated;
        this.authorities = authorities;
        this.principal = principal;
        this.credentials = credentials;
        this.previousLoginTimestamp = previousLoginTimestamp;
    }

    public String getName() {
        return this.principal.getName();
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public Object getCredentials() {
        return this.credentials;
    }

    public Object getDetails() {
        return null;
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public boolean isAuthenticated() {
        return this.isAuthenticated;
    }

    public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
        this.isAuthenticated = isAuthenticated;
    }

    public long getPreviousLoginTimestamp() {
        return this.previousLoginTimestamp;
    }

    public void setPreviousLoginTimestamp(long previousLoginTimestamp) {
        this.previousLoginTimestamp = previousLoginTimestamp;
    }

    public boolean hasGrantedAuthority(String authorityName) {
        for (GrantedAuthority grantedAuthority : this.getAuthorities()) {
            if (!grantedAuthority.getAuthority().equals(authorityName)) continue;
            return true;
        }
        return false;
    }

    public boolean canAccessLinkedItem(String linkedItemType, Long linkedItemId) {
        for (GrantedAuthority grantedAuthority : this.getAuthorities()) {
            logger.debug("Policy: " + (Policy)grantedAuthority);
            PolicyLink policyLink = ((Policy)grantedAuthority).getPolicyLink();
            logger.debug("PolicyLink: " + policyLink);
            if (policyLink == null || !policyLink.getPolicyLinkType().getName().equals(linkedItemType) || !policyLink.getTargetId().equals(linkedItemId)) continue;
            return true;
        }
        return false;
    }

    public List<Long> getLinkedModuleIds() {
        return this.getLinkedIds(MODULE);
    }

    public List<Long> getLinkedFlowIds() {
        return this.getLinkedIds(FLOW);
    }

    public List<Long> getLinkedBusinessStreamIds() {
        return this.getLinkedIds(BUSINESS_STREAM);
    }

    public List<Long> getLinkedMappingConfigurationIds() {
        return this.getLinkedIds(MAPPING_CONFIGURATION);
    }

    private List<Long> getLinkedIds(String type) {
        ArrayList<Long> id = new ArrayList<Long>();
        for (GrantedAuthority grantedAuthority : this.getAuthorities()) {
            PolicyLink policyLink = ((Policy)grantedAuthority).getPolicyLink();
            if (policyLink == null || !policyLink.getPolicyLinkType().getName().equals(type)) continue;
            id.add(policyLink.getTargetId());
        }
        return id;
    }
}

