/*
 * Decompiled with CFR 0.152.
 */
package com.ikasan.sample.spring.boot.builderpattern;

import com.ikasan.sample.spring.boot.builderpattern.ModuleConfig;
import javax.annotation.Resource;
import org.ikasan.builder.BuilderFactory;
import org.ikasan.builder.FlowBuilder;
import org.ikasan.builder.ModuleBuilder;
import org.ikasan.builder.component.ComponentBuilder;
import org.ikasan.builder.component.endpoint.ScheduledConsumerBuilder;
import org.ikasan.builder.invoker.Configuration;
import org.ikasan.spec.component.endpoint.Consumer;
import org.ikasan.spec.component.endpoint.Producer;
import org.ikasan.spec.flow.Flow;
import org.ikasan.spec.module.Module;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ImportResource;

@org.springframework.context.annotation.Configuration
@ImportResource(value={"classpath:ikasan-transaction-pointcut-jms.xml", "classpath:h2-datasource-conf.xml"})
public class ModuleConfig {
    @Resource
    BuilderFactory builderFactory;
    @Value(value="${jms.provider.url}")
    private String brokerUrl;
    @Value(value="${jms.connectionFactory.jndi.name}")
    private String jmsConnectionFactoryName;
    @Value(value="${jms.naming.factory.initial}")
    private String jmsNamingFactoryInitial;
    @Value(value="${jms.source.destination}")
    private String jmsSourceDestination;
    @Value(value="${jms.target.destination}")
    private String jmsTargetDestination;

    @Bean
    public Module getModule() {
        ModuleBuilder moduleBuilder = this.builderFactory.getModuleBuilder("sample-builder-pattern").withDescription("Example module with pattern builder");
        Flow scheduledFlow = this.getScheduledFlow(moduleBuilder, this.builderFactory.getComponentBuilder());
        Flow jmsFlow = this.getJmsFlow(moduleBuilder, this.builderFactory.getComponentBuilder());
        Module module = moduleBuilder.addFlow(scheduledFlow).addFlow(jmsFlow).build();
        return module;
    }

    public Flow getScheduledFlow(ModuleBuilder moduleBuilder, ComponentBuilder componentBuilder) {
        FlowBuilder flowBuilder = moduleBuilder.getFlowBuilder("Scheduled Flow");
        return (Flow)flowBuilder.withDescription("scheduled flow description").consumer("consumer", (Consumer)((ScheduledConsumerBuilder)((ScheduledConsumerBuilder)((ScheduledConsumerBuilder)((ScheduledConsumerBuilder)componentBuilder.scheduledConsumer().setCronExpression("0/5 * * * * ?")).setConfiguredResourceId("configuredResourceId")).setScheduledJobGroupName("scheduledJobGroupName")).setScheduledJobName("scheduledJobName")).build()).concurrentSplitter("splitterName", componentBuilder.listSplitter(), Configuration.concurrentSplitterInvoker().setConcurrentThreads(5)).producer("producer", (Producer)new MyProducer(this)).build();
    }

    public Flow getJmsFlow(ModuleBuilder moduleBuilder, ComponentBuilder componentBuilder) {
        FlowBuilder flowBuilder = moduleBuilder.getFlowBuilder("Jms Flow");
        return (Flow)flowBuilder.withDescription("Jms flow description").consumer("consumer", (Consumer)componentBuilder.jmsConsumer().setConfiguredResourceId("configuredResourceId").setDestinationJndiName(this.jmsSourceDestination).setConnectionFactoryName(this.jmsConnectionFactoryName).setConnectionFactoryJndiPropertyFactoryInitial(this.jmsNamingFactoryInitial).setConnectionFactoryJndiPropertyProviderUrl(this.brokerUrl).setDestinationJndiPropertyFactoryInitial(this.jmsNamingFactoryInitial).setDestinationJndiPropertyProviderUrl(this.brokerUrl).setAutoContentConversion(true).build()).producer("producer", (Producer)componentBuilder.jmsProducer().setConfiguredResourceId("crid").setDestinationJndiName(this.jmsTargetDestination).setConnectionFactoryName(this.jmsConnectionFactoryName).setConnectionFactoryJndiPropertyFactoryInitial(this.jmsNamingFactoryInitial).setConnectionFactoryJndiPropertyProviderUrl(this.brokerUrl).setDestinationJndiPropertyFactoryInitial(this.jmsNamingFactoryInitial).setDestinationJndiPropertyProviderUrl(this.brokerUrl).build()).build();
    }
}

