/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.elasticsearch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import io.reactivex.Flowable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.elasticsearch.client.RestClient;
import org.immutables.criteria.backend.Backend;
import org.immutables.criteria.backend.DefaultResult;
import org.immutables.criteria.backend.KeyExtractor;
import org.immutables.criteria.backend.PathNaming;
import org.immutables.criteria.backend.ProjectedTuple;
import org.immutables.criteria.backend.StandardOperations;
import org.immutables.criteria.backend.WriteResult;
import org.immutables.criteria.elasticsearch.AggregateQueryBuilder;
import org.immutables.criteria.elasticsearch.CountCall;
import org.immutables.criteria.elasticsearch.DefaultConverter;
import org.immutables.criteria.elasticsearch.Elasticsearch;
import org.immutables.criteria.elasticsearch.ElasticsearchOps;
import org.immutables.criteria.elasticsearch.ElasticsearchSetup;
import org.immutables.criteria.elasticsearch.IndexResolver;
import org.immutables.criteria.elasticsearch.JsonConverter;
import org.immutables.criteria.elasticsearch.QueryBuilders;
import org.immutables.criteria.elasticsearch.ToTupleConverter;
import org.immutables.criteria.expression.Path;
import org.immutables.criteria.expression.Query;
import org.reactivestreams.Publisher;

public class ElasticsearchBackend
implements Backend {
    final RestClient restClient;
    final ObjectMapper objectMapper;
    private final IndexResolver resolver;
    private final KeyExtractor.Factory keyExtractorFactory;
    private final int scrollSize;
    private final PathNaming pathNaming;

    public ElasticsearchBackend(ElasticsearchSetup setup) {
        Objects.requireNonNull(setup, "setup");
        this.restClient = setup.restClient();
        this.objectMapper = setup.objectMapper();
        this.resolver = setup.indexResolver();
        this.scrollSize = setup.scrollSize();
        this.keyExtractorFactory = setup.keyExtractorFactory();
        this.pathNaming = PathNaming.defaultNaming();
    }

    public Backend.Session open(Class<?> entityType) {
        String index = this.resolver.resolve(entityType);
        return new Session(entityType, this.keyExtractorFactory.create(entityType), new ElasticsearchOps(this.restClient, index, this.objectMapper, this.scrollSize), this.pathNaming);
    }

    static class Session
    implements Backend.Session {
        final Class<?> entityType;
        final ObjectMapper objectMapper;
        final ElasticsearchOps ops;
        final KeyExtractor keyExtractor;
        final JsonConverter<Object> converter;
        private final boolean hasId;
        final PathNaming pathNaming;
        final Predicate<Path> idPredicate;

        private Session(Class<?> entityClass, KeyExtractor keyExtractor, ElasticsearchOps ops, PathNaming pathNaming) {
            Objects.requireNonNull(entityClass, "entityClass");
            this.entityType = entityClass;
            this.ops = Objects.requireNonNull(ops, "ops");
            this.objectMapper = ops.mapper();
            this.keyExtractor = keyExtractor;
            this.converter = DefaultConverter.of(this.objectMapper, entityClass);
            KeyExtractor.KeyMetadata metadata = keyExtractor.metadata();
            this.hasId = metadata.isKeyDefined();
            this.pathNaming = pathNaming;
            this.idPredicate = Elasticsearch.idPredicate(keyExtractor.metadata());
        }

        public Class<?> entityType() {
            return this.entityType;
        }

        public Backend.Result execute(Backend.Operation operation) {
            Objects.requireNonNull(operation, "operation");
            if (operation instanceof StandardOperations.Insert) {
                return DefaultResult.of(this.insert((StandardOperations.Insert)operation));
            }
            if (operation instanceof StandardOperations.Select) {
                return DefaultResult.of(this.select((StandardOperations.Select)operation));
            }
            if (operation instanceof StandardOperations.GetByKey) {
                return DefaultResult.of(this.getByKey((StandardOperations.GetByKey)operation));
            }
            if (operation instanceof StandardOperations.DeleteByKey) {
                return DefaultResult.of(this.deleteByKey((StandardOperations.DeleteByKey)operation));
            }
            if (operation instanceof StandardOperations.Delete) {
                return DefaultResult.of(this.delete((StandardOperations.Delete)operation));
            }
            return DefaultResult.of((Publisher)Flowable.error((Throwable)new UnsupportedOperationException(String.format("Op %s not supported", operation))));
        }

        private Flowable<ProjectedTuple> aggregate(StandardOperations.Select op) {
            Query query = op.query();
            Preconditions.checkArgument((boolean)query.hasAggregations(), (Object)"No Aggregations");
            AggregateQueryBuilder builder = new AggregateQueryBuilder(query, this.objectMapper, this.ops.mapping, this.pathNaming, this.idPredicate);
            return this.ops.searchRaw(builder.jsonQuery(), Collections.emptyMap()).map(builder::processResult).toFlowable().flatMapIterable(x -> x);
        }

        private Flowable<?> select(StandardOperations.Select op) {
            Query query = op.query();
            if (query.distinct()) {
                return Flowable.error((Throwable)new UnsupportedOperationException("DISTINCT not yet supported by " + ElasticsearchBackend.class.getSimpleName()));
            }
            if (query.count()) {
                return new CountCall(op, this).call().toFlowable();
            }
            if (query.hasAggregations()) {
                return this.aggregate(op);
            }
            ObjectNode json = this.objectMapper.createObjectNode();
            query.filter().ifPresent(f -> json.set("query", (JsonNode)Elasticsearch.constantScoreQuery(this.objectMapper, this.pathNaming, this.idPredicate).convert(f)));
            query.limit().ifPresent(limit -> json.put("size", limit));
            query.offset().ifPresent(offset -> json.put("from", offset));
            if (!query.collations().isEmpty()) {
                ArrayNode sort = json.withArray("sort");
                query.collations().forEach(c -> sort.add((JsonNode)this.objectMapper.createObjectNode().put(c.path().toStringPath(), c.direction().isAscending() ? "asc" : "desc")));
            }
            ToTupleConverter converter = this.converter;
            if (query.hasProjections()) {
                ArrayNode projection = query.projections().stream().map(p -> ((Path)p).toStringPath()).reduce(this.objectMapper.createArrayNode(), ArrayNode::add, (old, newNode) -> newNode);
                json.set("_source", (JsonNode)projection);
                converter = new ToTupleConverter(query, this.objectMapper);
            }
            Flowable<Object> flowable = query.offset().isPresent() ? this.ops.search(json, converter) : this.ops.scrolledSearch(json, converter);
            return flowable;
        }

        private Publisher<WriteResult> insert(StandardOperations.Insert insert) {
            if (insert.values().isEmpty()) {
                return Flowable.just((Object)WriteResult.empty());
            }
            BiFunction<Object, ObjectNode, ObjectNode> idFn = (entity, node) -> this.hasId ? (ObjectNode)node.set("_id", this.objectMapper.valueToTree(this.keyExtractor.extract(entity))) : node;
            List<ObjectNode> docs = insert.values().stream().map(e -> (ObjectNode)idFn.apply(e, (ObjectNode)this.objectMapper.valueToTree(e))).collect(Collectors.toList());
            return this.ops.insertBulk(docs).toFlowable();
        }

        private Flowable<?> getByKey(StandardOperations.GetByKey op) {
            ObjectNode json = this.objectMapper.createObjectNode();
            ObjectNode query = QueryBuilders.idsQuery(op.keys()).toJson(this.objectMapper);
            json.set("query", (JsonNode)query);
            return this.ops.scrolledSearch(json, this.converter);
        }

        private Flowable<WriteResult> deleteByKey(StandardOperations.DeleteByKey op) {
            ObjectNode json = this.objectMapper.createObjectNode();
            ObjectNode query = QueryBuilders.idsQuery(op.keys()).toJson(this.objectMapper);
            json.set("query", (JsonNode)query);
            return this.ops.deleteByQuery(json).toFlowable();
        }

        private Flowable<WriteResult> delete(StandardOperations.Delete op) {
            Query query = op.query();
            ObjectNode json = this.objectMapper.createObjectNode();
            QueryBuilders.QueryBuilder builder = query.filter().map(f -> Elasticsearch.toBuilder(f, this.pathNaming, this.idPredicate)).orElse(QueryBuilders.matchAll());
            json.set("query", (JsonNode)builder.toJson(this.objectMapper));
            return this.ops.deleteByQuery(json).toFlowable();
        }
    }
}

