/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.elasticsearch.client.RestClient;
import org.immutables.criteria.backend.KeyExtractor;
import org.immutables.criteria.elasticsearch.ElasticsearchSetup;
import org.immutables.criteria.elasticsearch.IndexResolver;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ElasticsearchSetup", generator="Immutables")
@Immutable
final class ImmutableElasticsearchSetup
implements ElasticsearchSetup {
    private final RestClient restClient;
    private final ObjectMapper objectMapper;
    private final IndexResolver indexResolver;
    private final KeyExtractor.Factory keyExtractorFactory;
    private final int scrollSize;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableElasticsearchSetup(RestClient restClient) {
        this.restClient = Objects.requireNonNull(restClient, "restClient");
        this.objectMapper = this.initShim.objectMapper();
        this.indexResolver = this.initShim.indexResolver();
        this.keyExtractorFactory = this.initShim.keyExtractorFactory();
        this.scrollSize = this.initShim.scrollSize();
        this.initShim = null;
    }

    private ImmutableElasticsearchSetup(Builder builder) {
        this.restClient = builder.restClient;
        if (builder.objectMapper != null) {
            this.initShim.objectMapper(builder.objectMapper);
        }
        if (builder.indexResolver != null) {
            this.initShim.indexResolver(builder.indexResolver);
        }
        if (builder.keyExtractorFactory != null) {
            this.initShim.keyExtractorFactory(builder.keyExtractorFactory);
        }
        if (builder.scrollSizeIsSet()) {
            this.initShim.scrollSize(builder.scrollSize);
        }
        this.objectMapper = this.initShim.objectMapper();
        this.indexResolver = this.initShim.indexResolver();
        this.keyExtractorFactory = this.initShim.keyExtractorFactory();
        this.scrollSize = this.initShim.scrollSize();
        this.initShim = null;
    }

    private ImmutableElasticsearchSetup(RestClient restClient, ObjectMapper objectMapper, IndexResolver indexResolver, KeyExtractor.Factory keyExtractorFactory, int scrollSize) {
        this.restClient = restClient;
        this.objectMapper = objectMapper;
        this.indexResolver = indexResolver;
        this.keyExtractorFactory = keyExtractorFactory;
        this.scrollSize = scrollSize;
        this.initShim = null;
    }

    private ObjectMapper objectMapperInitialize() {
        return ElasticsearchSetup.super.objectMapper();
    }

    private IndexResolver indexResolverInitialize() {
        return ElasticsearchSetup.super.indexResolver();
    }

    private KeyExtractor.Factory keyExtractorFactoryInitialize() {
        return ElasticsearchSetup.super.keyExtractorFactory();
    }

    private int scrollSizeInitialize() {
        return ElasticsearchSetup.super.scrollSize();
    }

    @Override
    public RestClient restClient() {
        return this.restClient;
    }

    @Override
    public ObjectMapper objectMapper() {
        InitShim shim = this.initShim;
        return shim != null ? shim.objectMapper() : this.objectMapper;
    }

    @Override
    public IndexResolver indexResolver() {
        InitShim shim = this.initShim;
        return shim != null ? shim.indexResolver() : this.indexResolver;
    }

    @Override
    public KeyExtractor.Factory keyExtractorFactory() {
        InitShim shim = this.initShim;
        return shim != null ? shim.keyExtractorFactory() : this.keyExtractorFactory;
    }

    @Override
    public int scrollSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.scrollSize() : this.scrollSize;
    }

    public final ImmutableElasticsearchSetup withRestClient(RestClient value) {
        if (this.restClient == value) {
            return this;
        }
        RestClient newValue = Objects.requireNonNull(value, "restClient");
        return new ImmutableElasticsearchSetup(newValue, this.objectMapper, this.indexResolver, this.keyExtractorFactory, this.scrollSize);
    }

    public final ImmutableElasticsearchSetup withObjectMapper(ObjectMapper value) {
        if (this.objectMapper == value) {
            return this;
        }
        ObjectMapper newValue = Objects.requireNonNull(value, "objectMapper");
        return new ImmutableElasticsearchSetup(this.restClient, newValue, this.indexResolver, this.keyExtractorFactory, this.scrollSize);
    }

    public final ImmutableElasticsearchSetup withIndexResolver(IndexResolver value) {
        if (this.indexResolver == value) {
            return this;
        }
        IndexResolver newValue = Objects.requireNonNull(value, "indexResolver");
        return new ImmutableElasticsearchSetup(this.restClient, this.objectMapper, newValue, this.keyExtractorFactory, this.scrollSize);
    }

    public final ImmutableElasticsearchSetup withKeyExtractorFactory(KeyExtractor.Factory value) {
        if (this.keyExtractorFactory == value) {
            return this;
        }
        KeyExtractor.Factory newValue = Objects.requireNonNull(value, "keyExtractorFactory");
        return new ImmutableElasticsearchSetup(this.restClient, this.objectMapper, this.indexResolver, newValue, this.scrollSize);
    }

    public final ImmutableElasticsearchSetup withScrollSize(int value) {
        if (this.scrollSize == value) {
            return this;
        }
        return new ImmutableElasticsearchSetup(this.restClient, this.objectMapper, this.indexResolver, this.keyExtractorFactory, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableElasticsearchSetup && this.equalTo(0, (ImmutableElasticsearchSetup)another);
    }

    private boolean equalTo(int synthetic, ImmutableElasticsearchSetup another) {
        return this.restClient.equals(another.restClient) && this.objectMapper.equals(another.objectMapper) && this.indexResolver.equals(another.indexResolver) && this.keyExtractorFactory.equals(another.keyExtractorFactory) && this.scrollSize == another.scrollSize;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.restClient.hashCode();
        h += (h << 5) + this.objectMapper.hashCode();
        h += (h << 5) + this.indexResolver.hashCode();
        h += (h << 5) + this.keyExtractorFactory.hashCode();
        h += (h << 5) + this.scrollSize;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ElasticsearchSetup").omitNullValues().add("restClient", (Object)this.restClient).add("objectMapper", (Object)this.objectMapper).add("indexResolver", (Object)this.indexResolver).add("keyExtractorFactory", (Object)this.keyExtractorFactory).add("scrollSize", this.scrollSize).toString();
    }

    public static ImmutableElasticsearchSetup of(RestClient restClient) {
        return new ImmutableElasticsearchSetup(restClient);
    }

    public static ImmutableElasticsearchSetup copyOf(ElasticsearchSetup instance) {
        if (instance instanceof ImmutableElasticsearchSetup) {
            return (ImmutableElasticsearchSetup)instance;
        }
        return new ElasticsearchSetup.Builder().from(instance).build();
    }

    @Generated(from="ElasticsearchSetup", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_REST_CLIENT = 1L;
        private static final long OPT_BIT_SCROLL_SIZE = 1L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private RestClient restClient;
        @Nullable
        private ObjectMapper objectMapper;
        @Nullable
        private IndexResolver indexResolver;
        @Nullable
        private KeyExtractor.Factory keyExtractorFactory;
        private int scrollSize;

        public Builder() {
            if (!(this instanceof ElasticsearchSetup.Builder)) {
                throw new UnsupportedOperationException("Use: new ElasticsearchSetup.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final ElasticsearchSetup.Builder from(ElasticsearchSetup instance) {
            Objects.requireNonNull(instance, "instance");
            this.restClient(instance.restClient());
            this.objectMapper(instance.objectMapper());
            this.indexResolver(instance.indexResolver());
            this.keyExtractorFactory(instance.keyExtractorFactory());
            this.scrollSize(instance.scrollSize());
            return (ElasticsearchSetup.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ElasticsearchSetup.Builder restClient(RestClient restClient) {
            this.restClient = Objects.requireNonNull(restClient, "restClient");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (ElasticsearchSetup.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ElasticsearchSetup.Builder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper");
            return (ElasticsearchSetup.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ElasticsearchSetup.Builder indexResolver(IndexResolver indexResolver) {
            this.indexResolver = Objects.requireNonNull(indexResolver, "indexResolver");
            return (ElasticsearchSetup.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ElasticsearchSetup.Builder keyExtractorFactory(KeyExtractor.Factory keyExtractorFactory) {
            this.keyExtractorFactory = Objects.requireNonNull(keyExtractorFactory, "keyExtractorFactory");
            return (ElasticsearchSetup.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ElasticsearchSetup.Builder scrollSize(int scrollSize) {
            this.scrollSize = scrollSize;
            this.optBits |= 1L;
            return (ElasticsearchSetup.Builder)this;
        }

        public ImmutableElasticsearchSetup build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableElasticsearchSetup(this);
        }

        private boolean scrollSizeIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("restClient");
            }
            return "Cannot build ElasticsearchSetup, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="ElasticsearchSetup", generator="Immutables")
    private final class InitShim {
        private byte objectMapperBuildStage = 0;
        private ObjectMapper objectMapper;
        private byte indexResolverBuildStage = 0;
        private IndexResolver indexResolver;
        private byte keyExtractorFactoryBuildStage = 0;
        private KeyExtractor.Factory keyExtractorFactory;
        private byte scrollSizeBuildStage = 0;
        private int scrollSize;

        private InitShim() {
        }

        ObjectMapper objectMapper() {
            if (this.objectMapperBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.objectMapperBuildStage == 0) {
                this.objectMapperBuildStage = (byte)-1;
                this.objectMapper = Objects.requireNonNull(ImmutableElasticsearchSetup.this.objectMapperInitialize(), "objectMapper");
                this.objectMapperBuildStage = 1;
            }
            return this.objectMapper;
        }

        void objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            this.objectMapperBuildStage = 1;
        }

        IndexResolver indexResolver() {
            if (this.indexResolverBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.indexResolverBuildStage == 0) {
                this.indexResolverBuildStage = (byte)-1;
                this.indexResolver = Objects.requireNonNull(ImmutableElasticsearchSetup.this.indexResolverInitialize(), "indexResolver");
                this.indexResolverBuildStage = 1;
            }
            return this.indexResolver;
        }

        void indexResolver(IndexResolver indexResolver) {
            this.indexResolver = indexResolver;
            this.indexResolverBuildStage = 1;
        }

        KeyExtractor.Factory keyExtractorFactory() {
            if (this.keyExtractorFactoryBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.keyExtractorFactoryBuildStage == 0) {
                this.keyExtractorFactoryBuildStage = (byte)-1;
                this.keyExtractorFactory = Objects.requireNonNull(ImmutableElasticsearchSetup.this.keyExtractorFactoryInitialize(), "keyExtractorFactory");
                this.keyExtractorFactoryBuildStage = 1;
            }
            return this.keyExtractorFactory;
        }

        void keyExtractorFactory(KeyExtractor.Factory keyExtractorFactory) {
            this.keyExtractorFactory = keyExtractorFactory;
            this.keyExtractorFactoryBuildStage = 1;
        }

        int scrollSize() {
            if (this.scrollSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.scrollSizeBuildStage == 0) {
                this.scrollSizeBuildStage = (byte)-1;
                this.scrollSize = ImmutableElasticsearchSetup.this.scrollSizeInitialize();
                this.scrollSizeBuildStage = 1;
            }
            return this.scrollSize;
        }

        void scrollSize(int scrollSize) {
            this.scrollSize = scrollSize;
            this.scrollSizeBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.objectMapperBuildStage == -1) {
                attributes.add("objectMapper");
            }
            if (this.indexResolverBuildStage == -1) {
                attributes.add("indexResolver");
            }
            if (this.keyExtractorFactoryBuildStage == -1) {
                attributes.add("keyExtractorFactory");
            }
            if (this.scrollSizeBuildStage == -1) {
                attributes.add("scrollSize");
            }
            return "Cannot build ElasticsearchSetup, attribute initializers form cycle " + attributes;
        }
    }
}

