/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.elasticsearch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

class QueryBuilders {
    private QueryBuilders() {
    }

    static TermQueryBuilder termQuery(String name, String value) {
        return new TermQueryBuilder(name, value);
    }

    static TermQueryBuilder termQuery(String name, int value) {
        return new TermQueryBuilder(name, value);
    }

    static TermQueryBuilder termQuery(String name, char value) {
        return new TermQueryBuilder(name, Character.valueOf(value));
    }

    static TermQueryBuilder termQuery(String name, long value) {
        return new TermQueryBuilder(name, value);
    }

    static TermQueryBuilder termQuery(String name, float value) {
        return new TermQueryBuilder(name, Float.valueOf(value));
    }

    static TermQueryBuilder termQuery(String name, double value) {
        return new TermQueryBuilder(name, value);
    }

    static TermQueryBuilder termQuery(String name, boolean value) {
        return new TermQueryBuilder(name, value);
    }

    static TermQueryBuilder termQuery(String name, Object value) {
        return new TermQueryBuilder(name, value);
    }

    static TermsQueryBuilder termsQuery(String name, Iterable<?> values) {
        return new TermsQueryBuilder(name, values);
    }

    static RangeQueryBuilder rangeQuery(String name) {
        return new RangeQueryBuilder(name);
    }

    static RegexpQueryBuilder regexpQuery(String name, String regexp) {
        return new RegexpQueryBuilder(name, regexp);
    }

    static BoolQueryBuilder boolQuery() {
        return new BoolQueryBuilder();
    }

    static ConstantScoreQueryBuilder constantScoreQuery(QueryBuilder queryBuilder) {
        return new ConstantScoreQueryBuilder(queryBuilder);
    }

    static ExistsQueryBuilder existsQuery(String name) {
        return new ExistsQueryBuilder(name);
    }

    static PrefixQueryBuilder prefixQuery(String name, String prefix) {
        return new PrefixQueryBuilder(name, prefix);
    }

    static WildcardQueryBuilder wildcardQuery(String name, String wildcard) {
        return new WildcardQueryBuilder(name, wildcard);
    }

    static IdsQueryBuilder idsQuery(Iterable<?> values) {
        return new IdsQueryBuilder(values);
    }

    static MatchAllQueryBuilder matchAll() {
        return new MatchAllQueryBuilder();
    }

    private static JsonNode toJsonValue(Object value, ObjectMapper mapper) {
        if (value == null) {
            return mapper.getNodeFactory().nullNode();
        }
        return (JsonNode)mapper.convertValue(value, JsonNode.class);
    }

    static class TermQueryBuilder
    extends QueryBuilder {
        private final String fieldName;
        private final Object value;

        private TermQueryBuilder(String fieldName, Object value) {
            this.fieldName = Objects.requireNonNull(fieldName, "fieldName");
            this.value = Objects.requireNonNull(value, "value");
        }

        @Override
        ObjectNode toJson(ObjectMapper mapper) {
            ObjectNode result = mapper.createObjectNode();
            result.with("term").set(this.fieldName, QueryBuilders.toJsonValue(this.value, mapper));
            return result;
        }
    }

    private static class TermsQueryBuilder
    extends QueryBuilder {
        private final String fieldName;
        private final Iterable<?> values;

        private TermsQueryBuilder(String fieldName, Iterable<?> values) {
            this.fieldName = Objects.requireNonNull(fieldName, "fieldName");
            this.values = Objects.requireNonNull(values, "values");
        }

        @Override
        ObjectNode toJson(ObjectMapper mapper) {
            ObjectNode result = mapper.createObjectNode();
            ArrayNode terms = result.with("terms").withArray(this.fieldName);
            for (Object value : this.values) {
                terms.add(QueryBuilders.toJsonValue(value, mapper));
            }
            return result;
        }
    }

    static class RangeQueryBuilder
    extends QueryBuilder {
        private final String fieldName;
        private Object lt;
        private boolean lte;
        private Object gt;
        private boolean gte;
        private String format;

        private RangeQueryBuilder(String fieldName) {
            this.fieldName = Objects.requireNonNull(fieldName, "fieldName");
        }

        private RangeQueryBuilder to(Object value, boolean lte) {
            this.lt = Objects.requireNonNull(value, "value");
            this.lte = lte;
            return this;
        }

        private RangeQueryBuilder from(Object value, boolean gte) {
            this.gt = Objects.requireNonNull(value, "value");
            this.gte = gte;
            return this;
        }

        RangeQueryBuilder lt(Object value) {
            return this.to(value, false);
        }

        RangeQueryBuilder lte(Object value) {
            return this.to(value, true);
        }

        RangeQueryBuilder gt(Object value) {
            return this.from(value, false);
        }

        RangeQueryBuilder gte(Object value) {
            return this.from(value, true);
        }

        RangeQueryBuilder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        ObjectNode toJson(ObjectMapper mapper) {
            String op;
            if (this.lt == null && this.gt == null) {
                throw new IllegalStateException("Either lower or upper bound should be provided");
            }
            ObjectNode result = mapper.createObjectNode();
            ObjectNode range = result.with("range").with(this.fieldName);
            if (this.gt != null) {
                op = this.gte ? "gte" : "gt";
                range.set(op, QueryBuilders.toJsonValue(this.gt, mapper));
            }
            if (this.lt != null) {
                op = this.lte ? "lte" : "lt";
                range.set(op, QueryBuilders.toJsonValue(this.lt, mapper));
            }
            if (this.format != null) {
                range.put("format", this.format);
            }
            return result;
        }
    }

    static class RegexpQueryBuilder
    extends QueryBuilder {
        private final String fieldName;
        private final String value;

        RegexpQueryBuilder(String fieldName, String value) {
            this.fieldName = fieldName;
            this.value = value;
        }

        @Override
        ObjectNode toJson(ObjectMapper mapper) {
            ObjectNode result = mapper.createObjectNode();
            result.with("regexp").with(this.fieldName).put("value", this.value);
            return result;
        }
    }

    static class BoolQueryBuilder
    extends QueryBuilder {
        private final List<QueryBuilder> mustClauses = new ArrayList<QueryBuilder>();
        private final List<QueryBuilder> mustNotClauses = new ArrayList<QueryBuilder>();
        private final List<QueryBuilder> filterClauses = new ArrayList<QueryBuilder>();
        private final List<QueryBuilder> shouldClauses = new ArrayList<QueryBuilder>();

        BoolQueryBuilder() {
        }

        BoolQueryBuilder must(QueryBuilder queryBuilder) {
            Objects.requireNonNull(queryBuilder, "queryBuilder");
            this.mustClauses.add(queryBuilder);
            return this;
        }

        BoolQueryBuilder filter(QueryBuilder queryBuilder) {
            Objects.requireNonNull(queryBuilder, "queryBuilder");
            this.filterClauses.add(queryBuilder);
            return this;
        }

        BoolQueryBuilder mustNot(QueryBuilder queryBuilder) {
            Objects.requireNonNull(queryBuilder, "queryBuilder");
            this.mustNotClauses.add(queryBuilder);
            return this;
        }

        BoolQueryBuilder should(QueryBuilder queryBuilder) {
            Objects.requireNonNull(queryBuilder, "queryBuilder");
            this.shouldClauses.add(queryBuilder);
            return this;
        }

        @Override
        ObjectNode toJson(ObjectMapper mapper) {
            ObjectNode result = mapper.createObjectNode();
            ObjectNode bool = result.with("bool");
            BoolQueryBuilder.writeJsonArray("must", this.mustClauses, bool, mapper);
            BoolQueryBuilder.writeJsonArray("filter", this.filterClauses, bool, mapper);
            BoolQueryBuilder.writeJsonArray("must_not", this.mustNotClauses, bool, mapper);
            BoolQueryBuilder.writeJsonArray("should", this.shouldClauses, bool, mapper);
            return result;
        }

        private static void writeJsonArray(String field, List<QueryBuilder> clauses, ObjectNode node, ObjectMapper mapper) {
            if (clauses.isEmpty()) {
                return;
            }
            if (clauses.size() == 1) {
                node.set(field, (JsonNode)clauses.get(0).toJson(mapper));
            } else {
                ArrayNode arrayNode = node.withArray(field);
                for (QueryBuilder clause : clauses) {
                    arrayNode.add((JsonNode)clause.toJson(mapper));
                }
            }
        }
    }

    static class ConstantScoreQueryBuilder
    extends QueryBuilder {
        private final QueryBuilder builder;

        private ConstantScoreQueryBuilder(QueryBuilder builder) {
            this.builder = Objects.requireNonNull(builder, "builder");
        }

        @Override
        ObjectNode toJson(ObjectMapper mapper) {
            ObjectNode result = mapper.createObjectNode();
            result.with("constant_score").set("filter", (JsonNode)this.builder.toJson(mapper));
            return result;
        }
    }

    static abstract class QueryBuilder {
        QueryBuilder() {
        }

        abstract ObjectNode toJson(ObjectMapper var1);
    }

    static class ExistsQueryBuilder
    extends QueryBuilder {
        private final String fieldName;

        ExistsQueryBuilder(String fieldName) {
            this.fieldName = Objects.requireNonNull(fieldName, "fieldName");
        }

        @Override
        ObjectNode toJson(ObjectMapper mapper) {
            ObjectNode result = mapper.createObjectNode();
            result.with("exists").put("field", this.fieldName);
            return result;
        }
    }

    static class PrefixQueryBuilder
    extends QueryBuilder {
        private final String fieldName;
        private final String value;

        PrefixQueryBuilder(String fieldName, String value) {
            this.fieldName = Objects.requireNonNull(fieldName, "fieldName");
            this.value = Objects.requireNonNull(value, "value");
        }

        @Override
        ObjectNode toJson(ObjectMapper mapper) {
            ObjectNode result = mapper.createObjectNode();
            result.with("prefix").put(this.fieldName, this.value);
            return result;
        }
    }

    static class WildcardQueryBuilder
    extends QueryBuilder {
        private final String fieldName;
        private final String wildcard;

        private WildcardQueryBuilder(String fieldName, String wildcard) {
            this.fieldName = Objects.requireNonNull(fieldName, "fieldName");
            this.wildcard = Objects.requireNonNull(wildcard, "wildcard");
        }

        @Override
        ObjectNode toJson(ObjectMapper mapper) {
            ObjectNode result = mapper.createObjectNode();
            result.with("wildcard").put(this.fieldName, this.wildcard);
            return result;
        }
    }

    static class IdsQueryBuilder
    extends QueryBuilder {
        private final Iterable<?> values;

        IdsQueryBuilder(Iterable<?> values) {
            this.values = Objects.requireNonNull(values, "values");
        }

        @Override
        ObjectNode toJson(ObjectMapper mapper) {
            ObjectNode result = mapper.createObjectNode();
            ArrayNode array = result.with("ids").withArray("values");
            this.values.forEach(v -> array.add(QueryBuilders.toJsonValue(v, mapper)));
            return result;
        }
    }

    static class MatchAllQueryBuilder
    extends QueryBuilder {
        private MatchAllQueryBuilder() {
        }

        @Override
        ObjectNode toJson(ObjectMapper mapper) {
            ObjectNode node = mapper.createObjectNode();
            node.putObject("match_all");
            return node;
        }
    }
}

