/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.elasticsearch;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Version {
    private static final Pattern MAJOR_VERSION = Pattern.compile("^\\d+");
    final int major;
    final String full;

    private Version(String full) {
        this.full = Objects.requireNonNull(full, "full");
        Matcher matcher = MAJOR_VERSION.matcher(full);
        Preconditions.checkArgument((boolean)matcher.lookingAt(), (String)"Invalid version string: %s", (Object)full);
        this.major = Integer.parseInt(matcher.group());
    }

    static Version of(String full) {
        return new Version(full);
    }
}

