package org.immutables.criteria.geode;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.criteria.backend.PathNaming;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link OqlGenerator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableOqlGenerator.builder()}.
 */
@Generated(from = "OqlGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableOqlGenerator extends OqlGenerator {
  private final PathNaming pathNaming;
  private final String regionName;
  private final boolean useBindVariables;

  private ImmutableOqlGenerator(ImmutableOqlGenerator.Builder builder) {
    this.pathNaming = builder.pathNaming;
    this.regionName = builder.regionName;
    this.useBindVariables = builder.useBindVariablesIsSet()
        ? builder.useBindVariables
        : super.useBindVariables();
  }

  private ImmutableOqlGenerator(
      PathNaming pathNaming,
      String regionName,
      boolean useBindVariables) {
    this.pathNaming = pathNaming;
    this.regionName = regionName;
    this.useBindVariables = useBindVariables;
  }

  /**
   * @return The value of the {@code pathNaming} attribute
   */
  @Override
  PathNaming pathNaming() {
    return pathNaming;
  }

  /**
   * @return The value of the {@code regionName} attribute
   */
  @Override
  String regionName() {
    return regionName;
  }

  /**
   * @return The value of the {@code useBindVariables} attribute
   */
  @Override
  boolean useBindVariables() {
    return useBindVariables;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OqlGenerator#pathNaming() pathNaming} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pathNaming
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOqlGenerator withPathNaming(PathNaming value) {
    if (this.pathNaming == value) return this;
    PathNaming newValue = Objects.requireNonNull(value, "pathNaming");
    return new ImmutableOqlGenerator(newValue, this.regionName, this.useBindVariables);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OqlGenerator#regionName() regionName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for regionName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOqlGenerator withRegionName(String value) {
    String newValue = Objects.requireNonNull(value, "regionName");
    if (this.regionName.equals(newValue)) return this;
    return new ImmutableOqlGenerator(this.pathNaming, newValue, this.useBindVariables);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OqlGenerator#useBindVariables() useBindVariables} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for useBindVariables
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOqlGenerator withUseBindVariables(boolean value) {
    if (this.useBindVariables == value) return this;
    return new ImmutableOqlGenerator(this.pathNaming, this.regionName, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableOqlGenerator} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableOqlGenerator
        && equalTo(0, (ImmutableOqlGenerator) another);
  }

  private boolean equalTo(int synthetic, ImmutableOqlGenerator another) {
    return pathNaming.equals(another.pathNaming)
        && regionName.equals(another.regionName)
        && useBindVariables == another.useBindVariables;
  }

  /**
   * Computes a hash code from attributes: {@code pathNaming}, {@code regionName}, {@code useBindVariables}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + pathNaming.hashCode();
    h += (h << 5) + regionName.hashCode();
    h += (h << 5) + Booleans.hashCode(useBindVariables);
    return h;
  }

  /**
   * Prints the immutable value {@code OqlGenerator} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("OqlGenerator")
        .omitNullValues()
        .add("pathNaming", pathNaming)
        .add("regionName", regionName)
        .add("useBindVariables", useBindVariables)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link OqlGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable OqlGenerator instance
   */
  public static ImmutableOqlGenerator copyOf(OqlGenerator instance) {
    if (instance instanceof ImmutableOqlGenerator) {
      return (ImmutableOqlGenerator) instance;
    }
    return ImmutableOqlGenerator.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableOqlGenerator ImmutableOqlGenerator}.
   * <pre>
   * ImmutableOqlGenerator.builder()
   *    .pathNaming(org.immutables.criteria.backend.PathNaming) // required {@link OqlGenerator#pathNaming() pathNaming}
   *    .regionName(String) // required {@link OqlGenerator#regionName() regionName}
   *    .useBindVariables(boolean) // optional {@link OqlGenerator#useBindVariables() useBindVariables}
   *    .build();
   * </pre>
   * @return A new ImmutableOqlGenerator builder
   */
  public static ImmutableOqlGenerator.Builder builder() {
    return new ImmutableOqlGenerator.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableOqlGenerator ImmutableOqlGenerator}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "OqlGenerator", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_PATH_NAMING = 0x1L;
    private static final long INIT_BIT_REGION_NAME = 0x2L;
    private static final long OPT_BIT_USE_BIND_VARIABLES = 0x1L;
    private long initBits = 0x3L;
    private long optBits;

    private @Nullable PathNaming pathNaming;
    private @Nullable String regionName;
    private boolean useBindVariables;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OqlGenerator} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(OqlGenerator instance) {
      Objects.requireNonNull(instance, "instance");
      pathNaming(instance.pathNaming());
      regionName(instance.regionName());
      useBindVariables(instance.useBindVariables());
      return this;
    }

    /**
     * Initializes the value for the {@link OqlGenerator#pathNaming() pathNaming} attribute.
     * @param pathNaming The value for pathNaming 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder pathNaming(PathNaming pathNaming) {
      this.pathNaming = Objects.requireNonNull(pathNaming, "pathNaming");
      initBits &= ~INIT_BIT_PATH_NAMING;
      return this;
    }

    /**
     * Initializes the value for the {@link OqlGenerator#regionName() regionName} attribute.
     * @param regionName The value for regionName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder regionName(String regionName) {
      this.regionName = Objects.requireNonNull(regionName, "regionName");
      initBits &= ~INIT_BIT_REGION_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link OqlGenerator#useBindVariables() useBindVariables} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link OqlGenerator#useBindVariables() useBindVariables}.</em>
     * @param useBindVariables The value for useBindVariables 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder useBindVariables(boolean useBindVariables) {
      this.useBindVariables = useBindVariables;
      optBits |= OPT_BIT_USE_BIND_VARIABLES;
      return this;
    }

    /**
     * Builds a new {@link ImmutableOqlGenerator ImmutableOqlGenerator}.
     * @return An immutable instance of OqlGenerator
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableOqlGenerator build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableOqlGenerator(this);
    }

    private boolean useBindVariablesIsSet() {
      return (optBits & OPT_BIT_USE_BIND_VARIABLES) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PATH_NAMING) != 0) attributes.add("pathNaming");
      if ((initBits & INIT_BIT_REGION_NAME) != 0) attributes.add("regionName");
      return "Cannot build OqlGenerator, some of required attributes are not set " + attributes;
    }
  }
}
