/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.geode;

import io.reactivex.disposables.Disposable;
import java.util.Objects;
import org.apache.geode.cache.query.CqException;
import org.apache.geode.cache.query.CqQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CqDisposable
implements Disposable {
    private static final Logger logger = LoggerFactory.getLogger(CqDisposable.class);
    private final CqQuery cqQuery;

    CqDisposable(CqQuery cqQuery) {
        this.cqQuery = Objects.requireNonNull(cqQuery, "cqQuery");
    }

    public void dispose() {
        try {
            this.cqQuery.close();
        }
        catch (CqException e) {
            logger.error("Failed to close {} [{}]", new Object[]{this.cqQuery.getName(), this.cqQuery.getQueryString(), e});
        }
    }

    public boolean isDisposed() {
        return this.cqQuery.isClosed();
    }
}

