/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.geode;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.internal.cache.InternalRegion;
import org.immutables.criteria.geode.QueryServiceResolver;

class DefaultQueryServiceResolver
implements QueryServiceResolver {
    static final QueryServiceResolver INSTANCE = new DefaultQueryServiceResolver();

    private DefaultQueryServiceResolver() {
    }

    @Override
    public QueryService resolve(Region<?, ?> region) {
        Objects.requireNonNull(region, "region");
        return region.getRegionService() instanceof ClientCache ? DefaultQueryServiceResolver.resolveClientQueryService(region) : DefaultQueryServiceResolver.queryServiceFrom(region);
    }

    private static QueryService resolveClientQueryService(Region<?, ?> region) {
        Preconditions.checkArgument((boolean)(region.getRegionService() instanceof ClientCache), (String)"Expected to get %s got %s for region %s", ClientCache.class, (Object)region.getRegionService(), (Object)region.getFullPath());
        ClientCache clientCache = (ClientCache)region.getRegionService();
        return DefaultQueryServiceResolver.requiresLocalQueryService(region) ? clientCache.getLocalQueryService() : (DefaultQueryServiceResolver.requiresPooledQueryService(region) ? clientCache.getQueryService(DefaultQueryServiceResolver.poolNameFrom(region)) : DefaultQueryServiceResolver.queryServiceFrom(region));
    }

    private static boolean requiresLocalQueryService(Region<?, ?> region) {
        return Scope.LOCAL.equals(region.getAttributes().getScope()) && DefaultQueryServiceResolver.isLocalWithNoServerProxy(region);
    }

    private static boolean isLocalWithNoServerProxy(Region<?, ?> region) {
        return region instanceof InternalRegion && !((InternalRegion)region).hasServerProxy();
    }

    private static boolean requiresPooledQueryService(Region<?, ?> region) {
        String pool = DefaultQueryServiceResolver.poolNameFrom(region);
        return pool != null && !pool.isEmpty();
    }

    private static QueryService queryServiceFrom(Region<?, ?> region) {
        return region.getRegionService().getQueryService();
    }

    private static String poolNameFrom(Region<?, ?> region) {
        return region.getAttributes().getPoolName();
    }
}

