/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.geode;

import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.disposables.Disposable;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.CqAttributesFactory;
import org.apache.geode.cache.query.CqQuery;
import org.apache.geode.cache.query.QueryService;
import org.immutables.criteria.backend.Backend;
import org.immutables.criteria.backend.DefaultResult;
import org.immutables.criteria.backend.KeyExtractor;
import org.immutables.criteria.backend.PathNaming;
import org.immutables.criteria.backend.StandardOperations;
import org.immutables.criteria.backend.WatchEvent;
import org.immutables.criteria.geode.CqDisposable;
import org.immutables.criteria.geode.GeodeEventListener;
import org.immutables.criteria.geode.GeodeSetup;
import org.immutables.criteria.geode.KeyLookupAnalyzer;
import org.immutables.criteria.geode.OqlGenerator;
import org.immutables.criteria.geode.ReservedWordNaming;
import org.immutables.criteria.geode.SyncDelete;
import org.immutables.criteria.geode.SyncDeleteByKey;
import org.immutables.criteria.geode.SyncGetByKey;
import org.immutables.criteria.geode.SyncInsert;
import org.immutables.criteria.geode.SyncSelect;
import org.immutables.criteria.geode.SyncUpdate;
import org.reactivestreams.Publisher;

public class GeodeBackend
implements Backend {
    static final Logger logger = Logger.getLogger(GeodeBackend.class.getName());
    private final GeodeSetup setup;
    private final PathNaming pathNaming;

    public GeodeBackend(GeodeSetup setup) {
        this.setup = Objects.requireNonNull(setup, "setup");
        this.pathNaming = ReservedWordNaming.of(PathNaming.defaultNaming());
    }

    public Backend.Session open(Class<?> entityType) {
        Objects.requireNonNull(entityType, "context");
        return new Session(entityType, this);
    }

    static class Session
    implements Backend.Session {
        final Class<?> entityType;
        final Region<Object, Object> region;
        final KeyExtractor keyExtractor;
        final QueryService queryService;
        final PathNaming pathNaming;
        final KeyLookupAnalyzer keyLookupAnalyzer;

        private Session(Class<?> entityType, GeodeBackend backend) {
            this.entityType = Objects.requireNonNull(entityType, "entityType");
            GeodeSetup setup = backend.setup;
            Region<?, ?> region = setup.regionResolver().resolve(entityType);
            this.region = region;
            KeyExtractor keyExtractor = setup.keyExtractorFactory().create(entityType);
            if (!keyExtractor.metadata().isKeyDefined()) {
                throw new IllegalArgumentException(String.format("Key on %s is required for %s", entityType, GeodeBackend.class.getSimpleName()));
            }
            this.keyExtractor = keyExtractor;
            this.queryService = setup.queryServiceResolver().resolve(region);
            this.pathNaming = backend.pathNaming;
            this.keyLookupAnalyzer = KeyLookupAnalyzer.fromExtractor(keyExtractor);
        }

        public Class<?> entityType() {
            return this.entityType;
        }

        public Backend.Result execute(Backend.Operation operation) {
            return DefaultResult.of((Publisher)Flowable.defer(() -> this.executeInternal(operation)));
        }

        private Publisher<?> executeInternal(Backend.Operation operation) {
            if (operation instanceof StandardOperations.Select) {
                return Flowable.fromCallable((Callable)new SyncSelect(this, (StandardOperations.Select)operation)).flatMapIterable(x -> x);
            }
            if (operation instanceof StandardOperations.Update) {
                return Flowable.fromCallable((Callable)new SyncUpdate(this, (StandardOperations.Update)operation));
            }
            if (operation instanceof StandardOperations.Insert) {
                return Flowable.fromCallable((Callable)new SyncInsert(this, (StandardOperations.Insert)operation));
            }
            if (operation instanceof StandardOperations.Delete) {
                return Flowable.fromCallable((Callable)new SyncDelete(this, (StandardOperations.Delete)operation));
            }
            if (operation instanceof StandardOperations.Watch) {
                return this.watch((StandardOperations.Watch)operation);
            }
            if (operation instanceof StandardOperations.DeleteByKey) {
                return Flowable.fromCallable((Callable)new SyncDeleteByKey(this, (StandardOperations.DeleteByKey)operation));
            }
            if (operation instanceof StandardOperations.GetByKey) {
                return Flowable.fromCallable((Callable)new SyncGetByKey(this, (StandardOperations.GetByKey)operation)).flatMapIterable(x -> x);
            }
            return Flowable.error((Throwable)new UnsupportedOperationException(String.format("Operation %s not supported by %s", operation, GeodeBackend.class.getSimpleName())));
        }

        private <T> Publisher<WatchEvent<T>> watch(StandardOperations.Watch operation) {
            return Flowable.create(e -> {
                FlowableEmitter emitter = e.serialize();
                String oql = this.oqlGenerator().withoutBindVariables().generate(operation.query()).oql();
                CqAttributesFactory factory = new CqAttributesFactory();
                factory.addCqListener(new GeodeEventListener(oql, emitter));
                CqQuery cqQuery = this.queryService.newCq(oql, factory.create());
                emitter.setDisposable((Disposable)new CqDisposable(cqQuery));
                cqQuery.execute();
            }, (BackpressureStrategy)BackpressureStrategy.ERROR);
        }

        OqlGenerator oqlGenerator() {
            return OqlGenerator.of(this.region.getFullPath(), this.pathNaming);
        }
    }
}

