/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.geode;

import io.reactivex.Emitter;
import java.util.Objects;
import org.apache.geode.cache.query.CqEvent;
import org.apache.geode.cache.query.CqStatusListener;
import org.immutables.criteria.backend.WatchEvent;
import org.immutables.criteria.geode.GeodeWatchEvent;

class GeodeEventListener<T>
implements CqStatusListener {
    private final Emitter<WatchEvent<T>> emitter;
    private final String query;

    GeodeEventListener(String query, Emitter<WatchEvent<T>> emitter) {
        this.emitter = Objects.requireNonNull(emitter, "emitter");
        this.query = Objects.requireNonNull(query, "query");
    }

    public void onCqDisconnected() {
        this.emitter.onError((Throwable)new IllegalStateException(String.format("CQ disconnected [%s]", this.query)));
    }

    public void onCqConnected() {
    }

    public void onEvent(CqEvent event) {
        this.emitter.onNext(new GeodeWatchEvent(event));
    }

    public void onError(CqEvent event) {
        this.emitter.onError(event.getThrowable());
    }

    public void close() {
        this.emitter.onComplete();
    }
}

