/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.geode;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.immutables.criteria.backend.PathNaming;
import org.immutables.criteria.expression.AbstractExpressionVisitor;
import org.immutables.criteria.expression.Call;
import org.immutables.criteria.expression.ComparableOperators;
import org.immutables.criteria.expression.Constant;
import org.immutables.criteria.expression.Expression;
import org.immutables.criteria.expression.ExpressionVisitor;
import org.immutables.criteria.expression.Expressions;
import org.immutables.criteria.expression.IterableOperators;
import org.immutables.criteria.expression.Operator;
import org.immutables.criteria.expression.Operators;
import org.immutables.criteria.expression.OptionalOperators;
import org.immutables.criteria.expression.Path;
import org.immutables.criteria.expression.StringOperators;
import org.immutables.criteria.expression.Visitors;
import org.immutables.criteria.geode.Oql;
import org.immutables.criteria.geode.OqlLiterals;

class GeodeQueryVisitor
extends AbstractExpressionVisitor<Oql> {
    private final PathNaming pathNaming;
    private final List<Object> variables;
    private final boolean useBindVariables;

    GeodeQueryVisitor(boolean useBindVariables, PathNaming pathNaming) {
        super(e -> {
            throw new UnsupportedOperationException();
        });
        this.pathNaming = Objects.requireNonNull(pathNaming, "pathFn");
        this.variables = new ArrayList<Object>();
        this.useBindVariables = useBindVariables;
    }

    public Oql visit(Call call) {
        Operator op = call.operator();
        List args = call.arguments();
        if (op == Operators.NOT_IN || op == IterableOperators.NOT_EMPTY) {
            return this.visit(Expressions.not((Expression)Expressions.call((Operator)GeodeQueryVisitor.inverseOp(op), (Iterable)call.arguments())));
        }
        if (op == Operators.AND || op == Operators.OR) {
            Preconditions.checkArgument((!args.isEmpty() ? 1 : 0) != 0, (String)"Size should be >=1 for %s but was %s", (Object)op, (int)args.size());
            String join = ") " + op.name() + " (";
            String newOql = "(" + args.stream().map(a -> (Oql)a.accept((ExpressionVisitor)this)).map(Oql::oql).collect(Collectors.joining(join)) + ")";
            return new Oql(this.variables, newOql);
        }
        if (op.arity() == Operator.Arity.BINARY) {
            return this.binaryOperator(call);
        }
        if (op.arity() == Operator.Arity.UNARY) {
            return this.unaryOperator(call);
        }
        throw new UnsupportedOperationException("Don't know how to handle " + call);
    }

    private static Operator inverseOp(Operator op) {
        if (op == Operators.NOT_IN) {
            return Operators.IN;
        }
        if (op == IterableOperators.NOT_EMPTY) {
            return IterableOperators.IS_EMPTY;
        }
        throw new IllegalArgumentException("Don't know inverse operator of " + op);
    }

    private Oql unaryOperator(Call call) {
        Operator op = call.operator();
        List args = call.arguments();
        Preconditions.checkArgument((args.size() == 1 ? 1 : 0) != 0, (String)"Size should be == 1 for unary operator %s but was %s", (Object)op, (int)args.size());
        Expression arg0 = (Expression)args.get(0);
        String path = ((Oql)arg0.accept((ExpressionVisitor)this)).oql();
        if (op instanceof OptionalOperators) {
            String expr = op == OptionalOperators.IS_PRESENT ? String.format("is_defined(%s) AND %s != null", path, path) : String.format("is_undefined(%s) OR %s = null", path, path);
            return this.oql(expr);
        }
        if (op == Operators.NOT) {
            return this.oql(String.format("NOT (%s)", path));
        }
        if (op == IterableOperators.IS_EMPTY || op == StringOperators.TO_LOWER_CASE || op == StringOperators.TO_UPPER_CASE) {
            return this.oql(String.format("%s.%s()", path, GeodeQueryVisitor.toMethodName(op)));
        }
        throw new UnsupportedOperationException("Unknown unary operator " + call);
    }

    private Oql binaryOperator(Call call) {
        String operator;
        Operator op = call.operator();
        List args = call.arguments();
        Preconditions.checkArgument((args.size() == 2 ? 1 : 0) != 0, (String)"Size should be 2 for %s but was %s on call %s", (Object)op, (Object)args.size(), (Object)call);
        Expression left = (Expression)args.get(0);
        Expression right = (Expression)args.get(1);
        if (op == IterableOperators.CONTAINS || op == StringOperators.MATCHES || op == StringOperators.CONTAINS || op == StringOperators.STARTS_WITH || op == StringOperators.ENDS_WITH) {
            return this.oql(String.format("%s.%s(%s)", ((Oql)left.accept((ExpressionVisitor)this)).oql(), GeodeQueryVisitor.toMethodName(op), ((Oql)right.accept((ExpressionVisitor)this)).oql()));
        }
        if (op == StringOperators.HAS_LENGTH || op == IterableOperators.HAS_SIZE) {
            return this.oql(String.format("%s.%s = %s", ((Oql)left.accept((ExpressionVisitor)this)).oql(), GeodeQueryVisitor.toMethodName(op), ((Oql)right.accept((ExpressionVisitor)this)).oql()));
        }
        if (op == Operators.EQUAL || op == Operators.NOT_EQUAL) {
            operator = op == Operators.EQUAL ? "=" : "!=";
        } else if (op == Operators.IN || op == Operators.NOT_IN) {
            if (right instanceof Constant) {
                ImmutableSet newValues = ImmutableSet.copyOf((Collection)Visitors.toConstant((Expression)right).values());
                right = Expressions.constant((Object)newValues);
            }
            operator = op == Operators.IN ? "IN" : "NOT IN";
        } else if (op == ComparableOperators.GREATER_THAN) {
            operator = ">";
        } else if (op == ComparableOperators.GREATER_THAN_OR_EQUAL) {
            operator = ">=";
        } else if (op == ComparableOperators.LESS_THAN) {
            operator = "<";
        } else if (op == ComparableOperators.LESS_THAN_OR_EQUAL) {
            operator = "<=";
        } else {
            throw new IllegalArgumentException("Unknown binary operator " + call);
        }
        return this.oql(String.format("%s %s %s", ((Oql)left.accept((ExpressionVisitor)this)).oql(), operator, ((Oql)right.accept((ExpressionVisitor)this)).oql()));
    }

    public Oql visit(Path path) {
        String name = this.pathNaming.name(path);
        Type type = path.returnType();
        if (!this.useBindVariables && type instanceof Class && ((Class)type).isEnum()) {
            name = name + ".name";
        }
        return this.oql(name);
    }

    public Oql visit(Constant constant) {
        String oqlAsString;
        if (this.useBindVariables) {
            this.variables.add(constant.value());
            oqlAsString = "$" + this.variables.size();
        } else {
            oqlAsString = GeodeQueryVisitor.valueToString(constant.value());
        }
        return this.oql(oqlAsString);
    }

    private Oql oql(String oql) {
        return new Oql(this.variables, oql);
    }

    private static String toMethodName(Operator op) {
        if (op == IterableOperators.IS_EMPTY) {
            return "isEmpty";
        }
        if (op == StringOperators.TO_LOWER_CASE) {
            return "toLowerCase";
        }
        if (op == StringOperators.TO_UPPER_CASE) {
            return "toUpperCase";
        }
        if (op == StringOperators.HAS_LENGTH) {
            return "length";
        }
        if (op == IterableOperators.HAS_SIZE) {
            return "size";
        }
        if (op == StringOperators.CONTAINS || op == IterableOperators.CONTAINS) {
            return "contains";
        }
        if (op == StringOperators.STARTS_WITH) {
            return "startsWith";
        }
        if (op == StringOperators.ENDS_WITH) {
            return "endsWith";
        }
        if (op == StringOperators.MATCHES) {
            return "matches";
        }
        throw new UnsupportedOperationException("Don't know how to handle Operator " + op);
    }

    private static String valueToString(Object value) {
        return OqlLiterals.fromObject(value);
    }
}

