/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.geode;

import java.util.Objects;
import org.apache.geode.cache.GemFireCache;
import org.immutables.criteria.backend.KeyExtractor;
import org.immutables.criteria.geode.ImmutableGeodeSetup;
import org.immutables.criteria.geode.QueryServiceResolver;
import org.immutables.criteria.geode.RegionResolver;
import org.immutables.value.Value;

@Value.Style(visibility=Value.Style.ImplementationVisibility.PACKAGE)
@Value.Immutable
public interface GeodeSetup {
    @Value.Parameter
    public RegionResolver regionResolver();

    @Value.Default
    default public KeyExtractor.Factory keyExtractorFactory() {
        return KeyExtractor.defaultFactory();
    }

    @Value.Default
    default public QueryServiceResolver queryServiceResolver() {
        return QueryServiceResolver.defaultResolver();
    }

    public static GeodeSetup of(GemFireCache cache) {
        Objects.requireNonNull(cache, "cache");
        return GeodeSetup.of(RegionResolver.defaultResolver(cache));
    }

    public static GeodeSetup of(RegionResolver resolver) {
        return ImmutableGeodeSetup.of(resolver);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ImmutableGeodeSetup.Builder {
    }
}

