/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.geode;

import java.util.Objects;
import java.util.Optional;
import org.apache.geode.cache.query.CqEvent;
import org.immutables.criteria.backend.WatchEvent;

class GeodeWatchEvent<T>
implements WatchEvent<T> {
    private final Object key;
    private final T newValue;
    private final WatchEvent.Operation operation;

    GeodeWatchEvent(CqEvent cqEvent) {
        this.key = Objects.requireNonNull(cqEvent.getKey(), "event.key");
        Object newValue = cqEvent.getNewValue();
        this.newValue = newValue;
        this.operation = GeodeWatchEvent.toOperation(cqEvent);
    }

    public Object key() {
        return this.key;
    }

    public Optional<T> newValue() {
        return Optional.ofNullable(this.newValue);
    }

    public WatchEvent.Operation operation() {
        return this.operation;
    }

    private static WatchEvent.Operation toOperation(CqEvent event) {
        return WatchEvent.Operation.UPDATE;
    }
}

