/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.geode;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.criteria.backend.KeyExtractor;
import org.immutables.criteria.geode.GeodeSetup;
import org.immutables.criteria.geode.QueryServiceResolver;
import org.immutables.criteria.geode.RegionResolver;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="GeodeSetup", generator="Immutables")
@Immutable
final class ImmutableGeodeSetup
implements GeodeSetup {
    private final RegionResolver regionResolver;
    private final KeyExtractor.Factory keyExtractorFactory;
    private final QueryServiceResolver queryServiceResolver;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGeodeSetup(RegionResolver regionResolver) {
        this.regionResolver = Objects.requireNonNull(regionResolver, "regionResolver");
        this.keyExtractorFactory = this.initShim.keyExtractorFactory();
        this.queryServiceResolver = this.initShim.queryServiceResolver();
        this.initShim = null;
    }

    private ImmutableGeodeSetup(Builder builder) {
        this.regionResolver = builder.regionResolver;
        if (builder.keyExtractorFactory != null) {
            this.initShim.keyExtractorFactory(builder.keyExtractorFactory);
        }
        if (builder.queryServiceResolver != null) {
            this.initShim.queryServiceResolver(builder.queryServiceResolver);
        }
        this.keyExtractorFactory = this.initShim.keyExtractorFactory();
        this.queryServiceResolver = this.initShim.queryServiceResolver();
        this.initShim = null;
    }

    private ImmutableGeodeSetup(RegionResolver regionResolver, KeyExtractor.Factory keyExtractorFactory, QueryServiceResolver queryServiceResolver) {
        this.regionResolver = regionResolver;
        this.keyExtractorFactory = keyExtractorFactory;
        this.queryServiceResolver = queryServiceResolver;
        this.initShim = null;
    }

    private KeyExtractor.Factory keyExtractorFactoryInitialize() {
        return GeodeSetup.super.keyExtractorFactory();
    }

    private QueryServiceResolver queryServiceResolverInitialize() {
        return GeodeSetup.super.queryServiceResolver();
    }

    @Override
    public RegionResolver regionResolver() {
        return this.regionResolver;
    }

    @Override
    public KeyExtractor.Factory keyExtractorFactory() {
        InitShim shim = this.initShim;
        return shim != null ? shim.keyExtractorFactory() : this.keyExtractorFactory;
    }

    @Override
    public QueryServiceResolver queryServiceResolver() {
        InitShim shim = this.initShim;
        return shim != null ? shim.queryServiceResolver() : this.queryServiceResolver;
    }

    public final ImmutableGeodeSetup withRegionResolver(RegionResolver value) {
        if (this.regionResolver == value) {
            return this;
        }
        RegionResolver newValue = Objects.requireNonNull(value, "regionResolver");
        return new ImmutableGeodeSetup(newValue, this.keyExtractorFactory, this.queryServiceResolver);
    }

    public final ImmutableGeodeSetup withKeyExtractorFactory(KeyExtractor.Factory value) {
        if (this.keyExtractorFactory == value) {
            return this;
        }
        KeyExtractor.Factory newValue = Objects.requireNonNull(value, "keyExtractorFactory");
        return new ImmutableGeodeSetup(this.regionResolver, newValue, this.queryServiceResolver);
    }

    public final ImmutableGeodeSetup withQueryServiceResolver(QueryServiceResolver value) {
        if (this.queryServiceResolver == value) {
            return this;
        }
        QueryServiceResolver newValue = Objects.requireNonNull(value, "queryServiceResolver");
        return new ImmutableGeodeSetup(this.regionResolver, this.keyExtractorFactory, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGeodeSetup && this.equalTo(0, (ImmutableGeodeSetup)another);
    }

    private boolean equalTo(int synthetic, ImmutableGeodeSetup another) {
        return this.regionResolver.equals(another.regionResolver) && this.keyExtractorFactory.equals(another.keyExtractorFactory) && this.queryServiceResolver.equals(another.queryServiceResolver);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.regionResolver.hashCode();
        h += (h << 5) + this.keyExtractorFactory.hashCode();
        h += (h << 5) + this.queryServiceResolver.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"GeodeSetup").omitNullValues().add("regionResolver", (Object)this.regionResolver).add("keyExtractorFactory", (Object)this.keyExtractorFactory).add("queryServiceResolver", (Object)this.queryServiceResolver).toString();
    }

    public static ImmutableGeodeSetup of(RegionResolver regionResolver) {
        return new ImmutableGeodeSetup(regionResolver);
    }

    public static ImmutableGeodeSetup copyOf(GeodeSetup instance) {
        if (instance instanceof ImmutableGeodeSetup) {
            return (ImmutableGeodeSetup)instance;
        }
        return new GeodeSetup.Builder().from(instance).build();
    }

    @Generated(from="GeodeSetup", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_REGION_RESOLVER = 1L;
        private long initBits = 1L;
        @Nullable
        private RegionResolver regionResolver;
        @Nullable
        private KeyExtractor.Factory keyExtractorFactory;
        @Nullable
        private QueryServiceResolver queryServiceResolver;

        public Builder() {
            if (!(this instanceof GeodeSetup.Builder)) {
                throw new UnsupportedOperationException("Use: new GeodeSetup.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final GeodeSetup.Builder from(GeodeSetup instance) {
            Objects.requireNonNull(instance, "instance");
            this.regionResolver(instance.regionResolver());
            this.keyExtractorFactory(instance.keyExtractorFactory());
            this.queryServiceResolver(instance.queryServiceResolver());
            return (GeodeSetup.Builder)this;
        }

        @CanIgnoreReturnValue
        public final GeodeSetup.Builder regionResolver(RegionResolver regionResolver) {
            this.regionResolver = Objects.requireNonNull(regionResolver, "regionResolver");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (GeodeSetup.Builder)this;
        }

        @CanIgnoreReturnValue
        public final GeodeSetup.Builder keyExtractorFactory(KeyExtractor.Factory keyExtractorFactory) {
            this.keyExtractorFactory = Objects.requireNonNull(keyExtractorFactory, "keyExtractorFactory");
            return (GeodeSetup.Builder)this;
        }

        @CanIgnoreReturnValue
        public final GeodeSetup.Builder queryServiceResolver(QueryServiceResolver queryServiceResolver) {
            this.queryServiceResolver = Objects.requireNonNull(queryServiceResolver, "queryServiceResolver");
            return (GeodeSetup.Builder)this;
        }

        public ImmutableGeodeSetup build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGeodeSetup(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("regionResolver");
            }
            return "Cannot build GeodeSetup, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="GeodeSetup", generator="Immutables")
    private final class InitShim {
        private byte keyExtractorFactoryBuildStage = 0;
        private KeyExtractor.Factory keyExtractorFactory;
        private byte queryServiceResolverBuildStage = 0;
        private QueryServiceResolver queryServiceResolver;

        private InitShim() {
        }

        KeyExtractor.Factory keyExtractorFactory() {
            if (this.keyExtractorFactoryBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.keyExtractorFactoryBuildStage == 0) {
                this.keyExtractorFactoryBuildStage = (byte)-1;
                this.keyExtractorFactory = Objects.requireNonNull(ImmutableGeodeSetup.this.keyExtractorFactoryInitialize(), "keyExtractorFactory");
                this.keyExtractorFactoryBuildStage = 1;
            }
            return this.keyExtractorFactory;
        }

        void keyExtractorFactory(KeyExtractor.Factory keyExtractorFactory) {
            this.keyExtractorFactory = keyExtractorFactory;
            this.keyExtractorFactoryBuildStage = 1;
        }

        QueryServiceResolver queryServiceResolver() {
            if (this.queryServiceResolverBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.queryServiceResolverBuildStage == 0) {
                this.queryServiceResolverBuildStage = (byte)-1;
                this.queryServiceResolver = Objects.requireNonNull(ImmutableGeodeSetup.this.queryServiceResolverInitialize(), "queryServiceResolver");
                this.queryServiceResolverBuildStage = 1;
            }
            return this.queryServiceResolver;
        }

        void queryServiceResolver(QueryServiceResolver queryServiceResolver) {
            this.queryServiceResolver = queryServiceResolver;
            this.queryServiceResolverBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.keyExtractorFactoryBuildStage == -1) {
                attributes.add("keyExtractorFactory");
            }
            if (this.queryServiceResolverBuildStage == -1) {
                attributes.add("queryServiceResolver");
            }
            return "Cannot build GeodeSetup, attribute initializers form cycle " + attributes;
        }
    }
}

