/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.geode;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.criteria.backend.PathNaming;
import org.immutables.criteria.geode.OqlGenerator;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="OqlGenerator", generator="Immutables")
@Immutable
final class ImmutableOqlGenerator
extends OqlGenerator {
    private final PathNaming pathNaming;
    private final String regionName;
    private final boolean useBindVariables;

    private ImmutableOqlGenerator(Builder builder) {
        this.pathNaming = builder.pathNaming;
        this.regionName = builder.regionName;
        this.useBindVariables = builder.useBindVariablesIsSet() ? builder.useBindVariables : super.useBindVariables();
    }

    private ImmutableOqlGenerator(PathNaming pathNaming, String regionName, boolean useBindVariables) {
        this.pathNaming = pathNaming;
        this.regionName = regionName;
        this.useBindVariables = useBindVariables;
    }

    @Override
    PathNaming pathNaming() {
        return this.pathNaming;
    }

    @Override
    String regionName() {
        return this.regionName;
    }

    @Override
    boolean useBindVariables() {
        return this.useBindVariables;
    }

    public final ImmutableOqlGenerator withPathNaming(PathNaming value) {
        if (this.pathNaming == value) {
            return this;
        }
        PathNaming newValue = Objects.requireNonNull(value, "pathNaming");
        return new ImmutableOqlGenerator(newValue, this.regionName, this.useBindVariables);
    }

    public final ImmutableOqlGenerator withRegionName(String value) {
        String newValue = Objects.requireNonNull(value, "regionName");
        if (this.regionName.equals(newValue)) {
            return this;
        }
        return new ImmutableOqlGenerator(this.pathNaming, newValue, this.useBindVariables);
    }

    public final ImmutableOqlGenerator withUseBindVariables(boolean value) {
        if (this.useBindVariables == value) {
            return this;
        }
        return new ImmutableOqlGenerator(this.pathNaming, this.regionName, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOqlGenerator && this.equalTo(0, (ImmutableOqlGenerator)another);
    }

    private boolean equalTo(int synthetic, ImmutableOqlGenerator another) {
        return this.pathNaming.equals(another.pathNaming) && this.regionName.equals(another.regionName) && this.useBindVariables == another.useBindVariables;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.pathNaming.hashCode();
        h += (h << 5) + this.regionName.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.useBindVariables);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"OqlGenerator").omitNullValues().add("pathNaming", (Object)this.pathNaming).add("regionName", (Object)this.regionName).add("useBindVariables", this.useBindVariables).toString();
    }

    public static ImmutableOqlGenerator copyOf(OqlGenerator instance) {
        if (instance instanceof ImmutableOqlGenerator) {
            return (ImmutableOqlGenerator)instance;
        }
        return ImmutableOqlGenerator.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="OqlGenerator", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PATH_NAMING = 1L;
        private static final long INIT_BIT_REGION_NAME = 2L;
        private static final long OPT_BIT_USE_BIND_VARIABLES = 1L;
        private long initBits = 3L;
        private long optBits;
        @Nullable
        private PathNaming pathNaming;
        @Nullable
        private String regionName;
        private boolean useBindVariables;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(OqlGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            this.pathNaming(instance.pathNaming());
            this.regionName(instance.regionName());
            this.useBindVariables(instance.useBindVariables());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pathNaming(PathNaming pathNaming) {
            this.pathNaming = Objects.requireNonNull(pathNaming, "pathNaming");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder regionName(String regionName) {
            this.regionName = Objects.requireNonNull(regionName, "regionName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder useBindVariables(boolean useBindVariables) {
            this.useBindVariables = useBindVariables;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableOqlGenerator build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableOqlGenerator(this);
        }

        private boolean useBindVariablesIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("pathNaming");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("regionName");
            }
            return "Cannot build OqlGenerator, some of required attributes are not set " + attributes;
        }
    }
}

