/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.geode;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.immutables.criteria.backend.KeyExtractor;
import org.immutables.criteria.expression.Call;
import org.immutables.criteria.expression.Constant;
import org.immutables.criteria.expression.Expression;
import org.immutables.criteria.expression.Operators;
import org.immutables.criteria.expression.Path;
import org.immutables.criteria.expression.Visitors;

abstract class KeyLookupAnalyzer {
    private static final Result NOT_OPTIMIZABLE = new Result(){

        @Override
        public boolean isOptimizable() {
            return false;
        }

        @Override
        public Set<?> values() {
            throw new UnsupportedOperationException("Expression can not be optimized for key lookup. Did you check isOptimizable() method ? ");
        }
    };

    KeyLookupAnalyzer() {
    }

    public abstract Result analyze(Expression var1);

    static KeyLookupAnalyzer disabled() {
        return new KeyLookupAnalyzer(){

            @Override
            public Result analyze(Expression filter) {
                return NOT_OPTIMIZABLE;
            }
        };
    }

    static KeyLookupAnalyzer fromExtractor(KeyExtractor extractor) {
        Objects.requireNonNull(extractor, "extractor");
        KeyExtractor.KeyMetadata metadata = extractor.metadata();
        if (!metadata.isExpression() || !metadata.isKeyDefined() || metadata.keys().size() > 1) {
            return KeyLookupAnalyzer.disabled();
        }
        Optional path = Visitors.maybePath((Expression)((Expression)metadata.keys().get(0)));
        return path.map(KeyLookupAnalyzer::forPath).orElse(KeyLookupAnalyzer.disabled());
    }

    static KeyLookupAnalyzer forPath(Path idPath) {
        Objects.requireNonNull(idPath, "idPath");
        return new PathAnalyzer(idPath);
    }

    public static interface Result {
        public boolean isOptimizable();

        public Set<?> values();
    }

    private static class PathAnalyzer
    extends KeyLookupAnalyzer {
        private final Path idPath;

        private PathAnalyzer(Path idPath) {
            Objects.requireNonNull(idPath, "id");
            Preconditions.checkArgument((!idPath.members().isEmpty() ? 1 : 0) != 0, (String)"Path %s does not have any members", (Object)idPath);
            this.idPath = idPath;
        }

        @Override
        public Result analyze(Expression filter) {
            Objects.requireNonNull(filter, "filter");
            if (!(filter instanceof Call)) {
                return NOT_OPTIMIZABLE;
            }
            Call predicate = (Call)filter;
            if (predicate.operator() != Operators.EQUAL && predicate.operator() != Operators.IN) {
                return NOT_OPTIMIZABLE;
            }
            List args = predicate.arguments();
            Preconditions.checkArgument((args.size() == 2 ? 1 : 0) != 0, (String)"Expected size 2 but got %s for %s", (int)args.size(), (Object)predicate);
            if (!(args.get(0) instanceof Path) || !(args.get(1) instanceof Constant)) {
                return NOT_OPTIMIZABLE;
            }
            Path path = Visitors.toPath((Expression)((Expression)predicate.arguments().get(0)));
            if (!this.idPath.equals((Object)path)) {
                return NOT_OPTIMIZABLE;
            }
            ImmutableSet values = ImmutableSet.copyOf((Collection)Visitors.toConstant((Expression)((Expression)predicate.arguments().get(1))).values());
            return new Result(){
                final /* synthetic */ Set val$values;
                {
                    this.val$values = set;
                }

                @Override
                public boolean isOptimizable() {
                    return true;
                }

                @Override
                public Set<?> values() {
                    return this.val$values;
                }
            };
        }
    }
}

