/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.geode;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.immutables.criteria.backend.PathNaming;
import org.immutables.criteria.expression.Call;
import org.immutables.criteria.expression.Collation;
import org.immutables.criteria.expression.Expression;
import org.immutables.criteria.expression.Ordering;
import org.immutables.criteria.expression.Path;
import org.immutables.criteria.expression.Query;
import org.immutables.criteria.expression.Visitors;
import org.immutables.criteria.geode.Geodes;
import org.immutables.criteria.geode.ImmutableOqlGenerator;
import org.immutables.criteria.geode.Oql;
import org.immutables.value.Value;

@Value.Immutable
abstract class OqlGenerator {
    OqlGenerator() {
    }

    abstract PathNaming pathNaming();

    abstract String regionName();

    static OqlGenerator of(String regionName, PathNaming pathNaming) {
        return ImmutableOqlGenerator.builder().regionName(regionName).pathNaming(pathNaming).build();
    }

    @Value.Default
    boolean useBindVariables() {
        return true;
    }

    OqlGenerator withoutBindVariables() {
        return ImmutableOqlGenerator.copyOf(this).withUseBindVariables(false);
    }

    Oql generate(Query query) {
        if (query.count() && (query.hasAggregations() || !query.groupBy().isEmpty())) {
            throw new UnsupportedOperationException("Aggregations / Group By and count(*) are not yet supported");
        }
        boolean addOuterCountQuery = query.count() && (query.distinct() || query.hasProjections() || query.limit().isPresent());
        StringBuilder oql = new StringBuilder("SELECT");
        if (query.distinct()) {
            oql.append(" DISTINCT");
        }
        if (query.hasProjections()) {
            List paths = query.projections().stream().map(this::toProjection).collect(Collectors.toList());
            String projections = query.count() && !addOuterCountQuery ? " COUNT(*) " : String.join((CharSequence)", ", paths);
            oql.append(" ");
            oql.append(projections);
        } else {
            oql.append(query.count() && !addOuterCountQuery ? " COUNT(*)" : " *");
        }
        oql.append(" FROM ").append(this.regionName());
        ArrayList<Object> variables = new ArrayList<Object>();
        if (query.filter().isPresent()) {
            Oql withVars = (Oql)Geodes.converter(this.useBindVariables(), this.pathNaming()).convert((Expression)query.filter().get());
            oql.append(" WHERE ").append(withVars.oql());
            variables.addAll(withVars.variables());
        }
        if (!query.groupBy().isEmpty()) {
            oql.append(" GROUP BY ");
            oql.append(query.groupBy().stream().map(this::toProjection).collect(Collectors.joining(", ")));
        }
        if (!query.collations().isEmpty()) {
            oql.append(" ORDER BY ");
            String ascending = OqlGenerator.isMultiDirectionCollation(query) ? " ASC" : "";
            String orderBy = query.collations().stream().map(c -> this.pathNaming().name(c.path()) + (c.direction().isAscending() ? ascending : " DESC")).collect(Collectors.joining(", "));
            oql.append(orderBy);
        }
        query.limit().ifPresent(limit -> oql.append(" LIMIT ").append(limit));
        query.offset().ifPresent(offset -> oql.append(" OFFSET ").append(offset));
        if (addOuterCountQuery) {
            oql.insert(0, "SELECT COUNT(*) FROM (");
            oql.append(")");
        }
        return new Oql(variables, oql.toString());
    }

    private static boolean isMultiDirectionCollation(Query query) {
        long directionCount = query.collations().stream().map(Collation::direction).distinct().limit(Ordering.Direction.values().length).count();
        return directionCount > 1L;
    }

    private String toProjection(Expression expression) {
        if (Visitors.isAggregationCall((Expression)expression)) {
            Call aggregation = Visitors.toCall((Expression)expression);
            return String.format("%s(%s)", aggregation.operator().name(), this.toProjection((Expression)aggregation.arguments().get(0)));
        }
        return this.pathNaming().name((Path)expression);
    }
}

