/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.geode;

import com.google.common.collect.ImmutableSet;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

final class OqlLiterals {
    private OqlLiterals() {
    }

    static String fromObject(Object value) {
        if (value == null) {
            return Objects.toString(null);
        }
        if (value instanceof CharSequence) {
            return OqlLiterals.charSequence((CharSequence)value);
        }
        if (value instanceof Pattern) {
            return OqlLiterals.pattern((Pattern)value);
        }
        if (value instanceof Iterable) {
            return OqlLiterals.iterable((Iterable)value);
        }
        if (value.getClass().isEnum()) {
            return OqlLiterals.fromEnum((Enum)value);
        }
        if (value instanceof LocalDate) {
            return OqlLiterals.localDate((LocalDate)value);
        }
        if (value instanceof LocalDateTime) {
            return OqlLiterals.localDateTime((LocalDateTime)value);
        }
        if (value instanceof Instant) {
            return OqlLiterals.instant((Instant)value);
        }
        if (value instanceof Date) {
            return OqlLiterals.date((Date)value);
        }
        if (value instanceof Long) {
            return OqlLiterals.longValue((Long)value);
        }
        return Objects.toString(value);
    }

    private static String iterable(Iterable<?> value) {
        ImmutableSet set = ImmutableSet.copyOf(value);
        String asString = set.stream().map(OqlLiterals::fromObject).collect(Collectors.joining(", "));
        return "SET(" + asString + ")";
    }

    private static String pattern(Pattern pattern) {
        return OqlLiterals.charSequence(pattern.pattern());
    }

    private static String charSequence(CharSequence string) {
        return "'" + OqlLiterals.escape(string) + "'";
    }

    private static String localDate(LocalDate localDate) {
        return String.format("to_date('%s', '%s')", DateTimeFormatter.ISO_DATE.format(localDate), "yyyy-MM-dd");
    }

    private static String localDateTime(LocalDateTime localDateTime) {
        return OqlLiterals.instant(localDateTime.toInstant(ZoneOffset.UTC));
    }

    private static String instant(Instant instant) {
        return OqlLiterals.date(Date.from(instant));
    }

    private static String date(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return String.format("to_date('%s', '%s')", format.format(date), format.toPattern());
    }

    private static String longValue(Long value) {
        return value.toString() + 'L';
    }

    private static String fromEnum(Enum<?> value) {
        return OqlLiterals.charSequence(value.name());
    }

    static String escape(CharSequence oql) {
        return oql.toString().replace("'", "''");
    }
}

