/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.geode;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

final class Primitive
extends Enum<Primitive> {
    public static final /* enum */ Primitive BOOLEAN;
    public static final /* enum */ Primitive BYTE;
    public static final /* enum */ Primitive CHAR;
    public static final /* enum */ Primitive SHORT;
    public static final /* enum */ Primitive INT;
    public static final /* enum */ Primitive LONG;
    public static final /* enum */ Primitive FLOAT;
    public static final /* enum */ Primitive DOUBLE;
    public static final /* enum */ Primitive VOID;
    public static final /* enum */ Primitive OTHER;
    public final Class primitiveClass;
    public final Class boxClass;
    private static final Map<Class, Primitive> PRIMITIVE_MAP;
    private static final Map<Class, Primitive> BOX_MAP;
    private static final /* synthetic */ Primitive[] $VALUES;

    public static Primitive[] values() {
        return (Primitive[])$VALUES.clone();
    }

    public static Primitive valueOf(String name) {
        return Enum.valueOf(Primitive.class, name);
    }

    private Primitive(Class primitiveClass, Class boxClass) {
        this.primitiveClass = primitiveClass;
        this.boxClass = boxClass;
    }

    private static Primitive of(Type type) {
        return PRIMITIVE_MAP.get(type);
    }

    private static Primitive ofBox(Type type) {
        return BOX_MAP.get(type);
    }

    public static Primitive ofAny(Type type) {
        Primitive found = Primitive.of(type);
        return found != null ? found : Primitive.ofBox(type);
    }

    public static boolean is(Type type) {
        return PRIMITIVE_MAP.containsKey(type);
    }

    public Number cast(Number value) {
        switch (this) {
            case BYTE: {
                return value.byteValue();
            }
            case DOUBLE: {
                return value.doubleValue();
            }
            case FLOAT: {
                return Float.valueOf(value.floatValue());
            }
            case INT: {
                return value.intValue();
            }
            case LONG: {
                return value.longValue();
            }
            case SHORT: {
                return value.shortValue();
            }
        }
        throw new AssertionError((Object)((Object)((Object)this) + ": " + value));
    }

    private static /* synthetic */ Primitive[] $values() {
        return new Primitive[]{BOOLEAN, BYTE, CHAR, SHORT, INT, LONG, FLOAT, DOUBLE, VOID, OTHER};
    }

    static {
        Primitive[] values;
        BOOLEAN = new Primitive(Boolean.TYPE, Boolean.class);
        BYTE = new Primitive(Byte.TYPE, Byte.class);
        CHAR = new Primitive(Character.TYPE, Character.class);
        SHORT = new Primitive(Short.TYPE, Short.class);
        INT = new Primitive(Integer.TYPE, Integer.class);
        LONG = new Primitive(Long.TYPE, Long.class);
        FLOAT = new Primitive(Float.TYPE, Float.class);
        DOUBLE = new Primitive(Double.TYPE, Double.class);
        VOID = new Primitive(Void.TYPE, Void.class);
        OTHER = new Primitive(null, null);
        $VALUES = Primitive.$values();
        PRIMITIVE_MAP = new HashMap<Class, Primitive>();
        BOX_MAP = new HashMap<Class, Primitive>();
        for (Primitive value : values = Primitive.values()) {
            if (value.primitiveClass != null) {
                PRIMITIVE_MAP.put(value.primitiveClass, value);
            }
            if (value.boxClass == null) continue;
            BOX_MAP.put(value.boxClass, value);
        }
    }
}

