/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.geode;

import java.util.Objects;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.Region;
import org.immutables.criteria.backend.ContainerNaming;

public interface RegionResolver {
    public Region<?, ?> resolve(Class<?> var1);

    public static RegionResolver defaultResolver(GemFireCache cache) {
        Objects.requireNonNull(cache, "cache");
        return ctx -> {
            String name = ContainerNaming.DEFAULT.name(ctx);
            Region region = cache.getRegion(name);
            if (region == null) {
                throw new IllegalArgumentException(String.format("Failed to find geode region for %s. Region %s not found in %s cache", ctx.getName(), name, cache.getName()));
            }
            return region;
        };
    }
}

