/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.geode;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.immutables.criteria.backend.PathNaming;
import org.immutables.criteria.expression.Path;

class ReservedWordNaming
implements PathNaming {
    private static final Set<String> RESERVED_WORDS = ImmutableSet.of((Object)"abs", (Object)"all", (Object)"and", (Object)"andthen", (Object)"any", (Object)"array", (Object[])new String[]{"as", "asc", "avg", "bag", "boolean", "by", "byte", "char", "collection", "count", "date", "declare", "define", "desc", "dictionary", "distinct", "double", "element", "enum", "except", "exists", "false", "first", "flatten", "float", "for", "from", "group", "having", "import", "in", "int", "intersect", "interval", "is_defined", "is_undefined", "last", "like", "limit", "list", "listtoset", "long", "map", "max", "min", "mod", "nil", "not", "null", "nvl", "octet", "or", "order", "orelse", "query", "select", "set", "short", "some", "string", "struct", "sum", "time", "timestamp", "to_date", "true", "type", "undefine", "undefined", "union", "unique", "where"});
    private final PathNaming delegate;

    private ReservedWordNaming(PathNaming delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
    }

    public String name(Path path) {
        String name = this.delegate.name(path);
        return Arrays.stream(name.split("\\.")).map(p -> RESERVED_WORDS.contains(p) ? '\"' + p + '\"' : p).collect(Collectors.joining("."));
    }

    static PathNaming of(PathNaming delegate) {
        return new ReservedWordNaming(delegate);
    }
}

