/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.geode;

import java.util.Collection;
import java.util.concurrent.Callable;
import org.apache.geode.cache.Region;
import org.immutables.criteria.backend.StandardOperations;
import org.immutables.criteria.backend.WriteResult;
import org.immutables.criteria.expression.Expression;
import org.immutables.criteria.expression.ExpressionVisitor;
import org.immutables.criteria.geode.GeodeBackend;
import org.immutables.criteria.geode.GeodeQueryVisitor;
import org.immutables.criteria.geode.KeyLookupAnalyzer;
import org.immutables.criteria.geode.Oql;
import org.immutables.criteria.geode.SyncDeleteByKey;

class SyncDelete
implements Callable<WriteResult> {
    private final GeodeBackend.Session session;
    private final StandardOperations.Delete operation;
    private final Region<Object, Object> region;

    SyncDelete(GeodeBackend.Session session, StandardOperations.Delete operation) {
        this.session = session;
        this.operation = operation;
        this.region = session.region;
    }

    @Override
    public WriteResult call() throws Exception {
        if (!this.operation.query().filter().isPresent()) {
            this.region.clear();
            return WriteResult.unknown();
        }
        Expression filter = (Expression)this.operation.query().filter().orElseThrow(() -> new IllegalStateException("For " + this.operation));
        KeyLookupAnalyzer.Result result = this.session.keyLookupAnalyzer.analyze(filter);
        if (result.isOptimizable()) {
            return this.deleteByKeys(result.values());
        }
        GeodeQueryVisitor visitor = new GeodeQueryVisitor(true, path -> String.format("e.value.%s", this.session.pathNaming.name(path)));
        Oql oql = (Oql)filter.accept((ExpressionVisitor)visitor);
        String query = String.format("select distinct e.key from %s.entries e where %s", this.region.getFullPath(), oql.oql());
        Collection keys = (Collection)this.session.queryService.newQuery(query).execute(oql.variables().toArray(new Object[0]));
        this.deleteByKeys(keys);
        return WriteResult.empty().withDeletedCount((long)keys.size());
    }

    private WriteResult deleteByKeys(Iterable<?> keys) throws Exception {
        return new SyncDeleteByKey(this.session, keys).call();
    }
}

