/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.geode;

import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import org.immutables.criteria.backend.StandardOperations;
import org.immutables.criteria.backend.WriteResult;
import org.immutables.criteria.geode.GeodeBackend;

class SyncDeleteByKey
implements Callable<WriteResult> {
    private final Set<?> keys;
    private final GeodeBackend.Session session;

    SyncDeleteByKey(GeodeBackend.Session session, StandardOperations.DeleteByKey operation) {
        this(session, operation.keys());
    }

    SyncDeleteByKey(GeodeBackend.Session session, Iterable<?> keys) {
        this.keys = ImmutableSet.copyOf(keys);
        this.session = Objects.requireNonNull(session, "session");
    }

    @Override
    public WriteResult call() throws Exception {
        if (this.keys.isEmpty()) {
            return WriteResult.empty();
        }
        if (this.keys.size() == 1) {
            boolean removed = this.session.region.remove(this.keys.iterator().next()) != null;
            return WriteResult.empty().withDeletedCount(removed ? 1L : 0L);
        }
        this.session.region.removeAll(this.keys);
        return WriteResult.unknown();
    }
}

