/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.geode;

import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.immutables.criteria.backend.StandardOperations;
import org.immutables.criteria.geode.GeodeBackend;

class SyncGetByKey
implements Callable<Iterable<Object>> {
    private final GeodeBackend.Session session;
    private final Set<?> keys;

    SyncGetByKey(GeodeBackend.Session session, StandardOperations.GetByKey op) {
        this(session, op.keys());
    }

    SyncGetByKey(GeodeBackend.Session session, Iterable<?> keys) {
        this.session = Objects.requireNonNull(session, "session");
        this.keys = ImmutableSet.copyOf(keys);
    }

    @Override
    public Iterable<Object> call() throws Exception {
        return this.session.region.getAll(this.keys).values().stream().filter(Objects::nonNull).collect(Collectors.toList());
    }
}

