/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.geode;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.geode.cache.Region;
import org.immutables.criteria.backend.BackendException;
import org.immutables.criteria.backend.KeyExtractor;
import org.immutables.criteria.backend.StandardOperations;
import org.immutables.criteria.backend.WriteResult;
import org.immutables.criteria.geode.GeodeBackend;

class SyncInsert
implements Callable<WriteResult> {
    private final GeodeBackend.Session session;
    private final StandardOperations.Insert operation;
    private final Region<Object, Object> region;

    SyncInsert(GeodeBackend.Session session, StandardOperations.Insert operation) {
        this.session = session;
        this.operation = operation;
        this.region = session.region;
    }

    @Override
    public WriteResult call() {
        if (this.operation.values().isEmpty()) {
            return WriteResult.empty();
        }
        Map<Object, Object> toInsert = this.operation.values().stream().collect(Collectors.toMap(arg_0 -> ((KeyExtractor)this.session.keyExtractor).extract(arg_0), x -> x));
        Region<Object, Object> region = this.region;
        for (Map.Entry<Object, Object> entry : toInsert.entrySet()) {
            Object previous = region.putIfAbsent(entry.getKey(), entry.getValue());
            if (previous == null) continue;
            throw new BackendException(String.format("Duplicate id %s for %s", entry.getKey(), this.session.entityType()));
        }
        return WriteResult.empty().withInsertedCount((long)toInsert.size());
    }
}

