/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.geode;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.Struct;
import org.immutables.criteria.backend.ProjectedTuple;
import org.immutables.criteria.backend.StandardOperations;
import org.immutables.criteria.expression.Expression;
import org.immutables.criteria.expression.Query;
import org.immutables.criteria.geode.BindVariableConverter;
import org.immutables.criteria.geode.GeodeBackend;
import org.immutables.criteria.geode.Geodes;
import org.immutables.criteria.geode.KeyLookupAnalyzer;
import org.immutables.criteria.geode.Oql;
import org.immutables.criteria.geode.SyncGetByKey;

class SyncSelect
implements Callable<Iterable<Object>> {
    private static final Function<Object, Object> UNDEFINED_TO_NULL = value -> QueryService.UNDEFINED.equals(value) ? null : value;
    private static final Function<Object, Object> BIND_VARIABLE_CONVERTER = new BindVariableConverter();
    private final GeodeBackend.Session session;
    private final StandardOperations.Select operation;

    SyncSelect(GeodeBackend.Session session, StandardOperations.Select operation) {
        this.session = session;
        this.operation = operation;
    }

    private static ProjectedTuple toTuple(Query query, Object value) {
        if (!(value instanceof Struct)) {
            Preconditions.checkArgument((query.projections().size() == 1 ? 1 : 0) != 0, (String)"Expected single projection got %s", (int)query.projections().size());
            Expression projection = (Expression)query.projections().get(0);
            return ProjectedTuple.ofSingle((Expression)projection, (Object)UNDEFINED_TO_NULL.apply(value));
        }
        Struct struct = (Struct)value;
        List values = Arrays.stream(struct.getFieldValues()).map(UNDEFINED_TO_NULL).collect(Collectors.toList());
        return ProjectedTuple.of((Iterable)query.projections(), values);
    }

    @Override
    public Iterable<Object> call() throws Exception {
        KeyLookupAnalyzer.Result result;
        boolean maybeGetById;
        Query query = this.operation.query();
        Oql oql = this.session.oqlGenerator().generate(query);
        if (GeodeBackend.logger.isLoggable(Level.FINE)) {
            GeodeBackend.logger.log(Level.FINE, "Querying Geode with {0}", oql);
        }
        boolean bl = maybeGetById = query.filter().isPresent() && !query.hasAggregations() && !query.hasProjections() && !query.count() && query.collations().isEmpty();
        if (maybeGetById && (result = this.session.keyLookupAnalyzer.analyze((Expression)query.filter().get())).isOptimizable()) {
            return new SyncGetByKey(this.session, result.values()).call();
        }
        Function<Object, Object> tupleFn = query.count() ? x -> Geodes.convert(x, Long.class) : (query.hasProjections() ? x -> Geodes.castNumbers(SyncSelect.toTuple(query, x)) : Function.identity());
        Object[] variables = oql.variables().stream().map(BIND_VARIABLE_CONVERTER).toArray(Object[]::new);
        Iterable result2 = (Iterable)this.session.queryService.newQuery(oql.oql()).execute(variables);
        return Iterables.transform((Iterable)result2, tupleFn::apply);
    }
}

