/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.geode;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.geode.cache.Region;
import org.immutables.criteria.backend.KeyExtractor;
import org.immutables.criteria.backend.StandardOperations;
import org.immutables.criteria.backend.WriteResult;
import org.immutables.criteria.geode.GeodeBackend;

class SyncUpdate
implements Callable<WriteResult> {
    private final GeodeBackend.Session session;
    private final StandardOperations.Update operation;
    private final Region<Object, Object> region;

    SyncUpdate(GeodeBackend.Session session, StandardOperations.Update operation) {
        this.session = session;
        this.operation = operation;
        this.region = session.region;
    }

    @Override
    public WriteResult call() {
        if (this.operation.values().isEmpty()) {
            return WriteResult.empty();
        }
        Map<Object, Object> toInsert = this.operation.values().stream().collect(Collectors.toMap(arg_0 -> ((KeyExtractor)this.session.keyExtractor).extract(arg_0), x -> x));
        Region<Object, Object> region = this.region;
        if (this.operation.upsert()) {
            return this.upsert(toInsert);
        }
        long inserted = 0L;
        long updated = 0L;
        for (Map.Entry<Object, Object> entry : toInsert.entrySet()) {
            boolean wasInserted;
            boolean bl = wasInserted = region.replace(entry.getKey(), entry.getValue()) == null;
            if (wasInserted) {
                ++inserted;
                continue;
            }
            ++updated;
        }
        return WriteResult.empty().withInsertedCount(inserted).withUpdatedCount(updated);
    }

    private WriteResult upsert(Map<Object, Object> toUpsert) {
        if (toUpsert.size() == 1) {
            Map.Entry<Object, Object> entry = toUpsert.entrySet().iterator().next();
            Object result = this.region.put(entry.getKey(), entry.getValue());
            return result == null ? WriteResult.empty().withInsertedCount(1L) : WriteResult.empty().withUpdatedCount(1L);
        }
        this.region.putAll(toUpsert);
        return WriteResult.unknown();
    }
}

