package org.immutables.criteria.mongo;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.criteria.backend.KeyExtractor;
import org.immutables.criteria.backend.PathNaming;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MongoSetup}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new MongoSetup.Builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableMongoSetup.of()}.
 */
@Generated(from = "MongoSetup", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableMongoSetup implements MongoSetup {
  private final CollectionResolver collectionResolver;
  private final KeyExtractor.Factory keyExtractorFactory;
  private final PathNaming pathNaming;

  private ImmutableMongoSetup(CollectionResolver collectionResolver) {
    this.collectionResolver = Objects.requireNonNull(collectionResolver, "collectionResolver");
    this.keyExtractorFactory = initShim.keyExtractorFactory();
    this.pathNaming = initShim.pathNaming();
    this.initShim = null;
  }

  private ImmutableMongoSetup(ImmutableMongoSetup.Builder builder) {
    this.collectionResolver = builder.collectionResolver;
    if (builder.keyExtractorFactory != null) {
      initShim.keyExtractorFactory(builder.keyExtractorFactory);
    }
    if (builder.pathNaming != null) {
      initShim.pathNaming(builder.pathNaming);
    }
    this.keyExtractorFactory = initShim.keyExtractorFactory();
    this.pathNaming = initShim.pathNaming();
    this.initShim = null;
  }

  private ImmutableMongoSetup(
      CollectionResolver collectionResolver,
      KeyExtractor.Factory keyExtractorFactory,
      PathNaming pathNaming) {
    this.collectionResolver = collectionResolver;
    this.keyExtractorFactory = keyExtractorFactory;
    this.pathNaming = pathNaming;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "MongoSetup", generator = "Immutables")
  private final class InitShim {
    private byte keyExtractorFactoryBuildStage = STAGE_UNINITIALIZED;
    private KeyExtractor.Factory keyExtractorFactory;

    KeyExtractor.Factory keyExtractorFactory() {
      if (keyExtractorFactoryBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (keyExtractorFactoryBuildStage == STAGE_UNINITIALIZED) {
        keyExtractorFactoryBuildStage = STAGE_INITIALIZING;
        this.keyExtractorFactory = Objects.requireNonNull(keyExtractorFactoryInitialize(), "keyExtractorFactory");
        keyExtractorFactoryBuildStage = STAGE_INITIALIZED;
      }
      return this.keyExtractorFactory;
    }

    void keyExtractorFactory(KeyExtractor.Factory keyExtractorFactory) {
      this.keyExtractorFactory = keyExtractorFactory;
      keyExtractorFactoryBuildStage = STAGE_INITIALIZED;
    }

    private byte pathNamingBuildStage = STAGE_UNINITIALIZED;
    private PathNaming pathNaming;

    PathNaming pathNaming() {
      if (pathNamingBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (pathNamingBuildStage == STAGE_UNINITIALIZED) {
        pathNamingBuildStage = STAGE_INITIALIZING;
        this.pathNaming = Objects.requireNonNull(pathNamingInitialize(), "pathNaming");
        pathNamingBuildStage = STAGE_INITIALIZED;
      }
      return this.pathNaming;
    }

    void pathNaming(PathNaming pathNaming) {
      this.pathNaming = pathNaming;
      pathNamingBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (keyExtractorFactoryBuildStage == STAGE_INITIALIZING) attributes.add("keyExtractorFactory");
      if (pathNamingBuildStage == STAGE_INITIALIZING) attributes.add("pathNaming");
      return "Cannot build MongoSetup, attribute initializers form cycle " + attributes;
    }
  }

  private KeyExtractor.Factory keyExtractorFactoryInitialize() {
    return MongoSetup.super.keyExtractorFactory();
  }

  private PathNaming pathNamingInitialize() {
    return MongoSetup.super.pathNaming();
  }

  /**
   * @return The value of the {@code collectionResolver} attribute
   */
  @Override
  public CollectionResolver collectionResolver() {
    return collectionResolver;
  }

  /**
   * @return The value of the {@code keyExtractorFactory} attribute
   */
  @Override
  public KeyExtractor.Factory keyExtractorFactory() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.keyExtractorFactory()
        : this.keyExtractorFactory;
  }

  /**
   * @return The value of the {@code pathNaming} attribute
   */
  @Override
  public PathNaming pathNaming() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.pathNaming()
        : this.pathNaming;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoSetup#collectionResolver() collectionResolver} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for collectionResolver
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoSetup withCollectionResolver(CollectionResolver value) {
    if (this.collectionResolver == value) return this;
    CollectionResolver newValue = Objects.requireNonNull(value, "collectionResolver");
    return new ImmutableMongoSetup(newValue, this.keyExtractorFactory, this.pathNaming);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoSetup#keyExtractorFactory() keyExtractorFactory} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for keyExtractorFactory
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoSetup withKeyExtractorFactory(KeyExtractor.Factory value) {
    if (this.keyExtractorFactory == value) return this;
    KeyExtractor.Factory newValue = Objects.requireNonNull(value, "keyExtractorFactory");
    return new ImmutableMongoSetup(this.collectionResolver, newValue, this.pathNaming);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoSetup#pathNaming() pathNaming} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pathNaming
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoSetup withPathNaming(PathNaming value) {
    if (this.pathNaming == value) return this;
    PathNaming newValue = Objects.requireNonNull(value, "pathNaming");
    return new ImmutableMongoSetup(this.collectionResolver, this.keyExtractorFactory, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMongoSetup} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMongoSetup
        && equalTo(0, (ImmutableMongoSetup) another);
  }

  private boolean equalTo(int synthetic, ImmutableMongoSetup another) {
    return collectionResolver.equals(another.collectionResolver)
        && keyExtractorFactory.equals(another.keyExtractorFactory)
        && pathNaming.equals(another.pathNaming);
  }

  /**
   * Computes a hash code from attributes: {@code collectionResolver}, {@code keyExtractorFactory}, {@code pathNaming}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + collectionResolver.hashCode();
    h += (h << 5) + keyExtractorFactory.hashCode();
    h += (h << 5) + pathNaming.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MongoSetup} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("MongoSetup")
        .omitNullValues()
        .add("collectionResolver", collectionResolver)
        .add("keyExtractorFactory", keyExtractorFactory)
        .add("pathNaming", pathNaming)
        .toString();
  }

  /**
   * Construct a new immutable {@code MongoSetup} instance.
   * @param collectionResolver The value for the {@code collectionResolver} attribute
   * @return An immutable MongoSetup instance
   */
  public static ImmutableMongoSetup of(CollectionResolver collectionResolver) {
    return new ImmutableMongoSetup(collectionResolver);
  }

  /**
   * Creates an immutable copy of a {@link MongoSetup} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MongoSetup instance
   */
  public static ImmutableMongoSetup copyOf(MongoSetup instance) {
    if (instance instanceof ImmutableMongoSetup) {
      return (ImmutableMongoSetup) instance;
    }
    return new MongoSetup.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableMongoSetup ImmutableMongoSetup}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MongoSetup", generator = "Immutables")
  @NotThreadSafe
  public static class Builder {
    private static final long INIT_BIT_COLLECTION_RESOLVER = 0x1L;
    private long initBits = 0x1L;

    private @Nullable CollectionResolver collectionResolver;
    private @Nullable KeyExtractor.Factory keyExtractorFactory;
    private @Nullable PathNaming pathNaming;

    /**
     * Creates a builder for {@link ImmutableMongoSetup ImmutableMongoSetup} instances.
     * <pre>
     * new MongoSetup.Builder()
     *    .collectionResolver(org.immutables.criteria.mongo.CollectionResolver) // required {@link MongoSetup#collectionResolver() collectionResolver}
     *    .keyExtractorFactory(org.immutables.criteria.backend.KeyExtractor.Factory) // optional {@link MongoSetup#keyExtractorFactory() keyExtractorFactory}
     *    .pathNaming(org.immutables.criteria.backend.PathNaming) // optional {@link MongoSetup#pathNaming() pathNaming}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof MongoSetup.Builder)) {
        throw new UnsupportedOperationException("Use: new MongoSetup.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code MongoSetup} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final MongoSetup.Builder from(MongoSetup instance) {
      Objects.requireNonNull(instance, "instance");
      collectionResolver(instance.collectionResolver());
      keyExtractorFactory(instance.keyExtractorFactory());
      pathNaming(instance.pathNaming());
      return (MongoSetup.Builder) this;
    }

    /**
     * Initializes the value for the {@link MongoSetup#collectionResolver() collectionResolver} attribute.
     * @param collectionResolver The value for collectionResolver 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final MongoSetup.Builder collectionResolver(CollectionResolver collectionResolver) {
      this.collectionResolver = Objects.requireNonNull(collectionResolver, "collectionResolver");
      initBits &= ~INIT_BIT_COLLECTION_RESOLVER;
      return (MongoSetup.Builder) this;
    }

    /**
     * Initializes the value for the {@link MongoSetup#keyExtractorFactory() keyExtractorFactory} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoSetup#keyExtractorFactory() keyExtractorFactory}.</em>
     * @param keyExtractorFactory The value for keyExtractorFactory 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final MongoSetup.Builder keyExtractorFactory(KeyExtractor.Factory keyExtractorFactory) {
      this.keyExtractorFactory = Objects.requireNonNull(keyExtractorFactory, "keyExtractorFactory");
      return (MongoSetup.Builder) this;
    }

    /**
     * Initializes the value for the {@link MongoSetup#pathNaming() pathNaming} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoSetup#pathNaming() pathNaming}.</em>
     * @param pathNaming The value for pathNaming 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final MongoSetup.Builder pathNaming(PathNaming pathNaming) {
      this.pathNaming = Objects.requireNonNull(pathNaming, "pathNaming");
      return (MongoSetup.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableMongoSetup ImmutableMongoSetup}.
     * @return An immutable instance of MongoSetup
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMongoSetup build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableMongoSetup(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_COLLECTION_RESOLVER) != 0) attributes.add("collectionResolver");
      return "Cannot build MongoSetup, some of required attributes are not set " + attributes;
    }
  }
}
